
<!DOCTYPE html>
<html>
	<head>
		<!-- Basic Page Info -->
		<meta charset="utf-8" />
		<title><?php echo $__env->yieldContent('pageTitle'); ?> | Compta App</title>

		<!-- Site favicon -->
		<link
			rel="apple-touch-icon"
			sizes="180x180"
			href="<?php echo e(asset('assets/vendors/images/apple-touch-icon.png')); ?>"
		/>
		<link
			rel="icon"
			type="image/png"
			sizes="32x32"
			href="<?php echo e(asset('assets/vendors/images/favicon-32x32.png')); ?>"
		/>
		<link
			rel="icon"
			type="image/png"
			sizes="16x16"
			href="<?php echo e(asset('assets/vendors/images/favicon-16x16.png')); ?>"
		/>

		<!-- Mobile Specific Metas -->
		<meta
			name="viewport"
			content="width=device-width, initial-scale=1, maximum-scale=1"
		/>

		<!-- Google Font -->
		<link
			href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap"
			rel="stylesheet"
		/>
		<!-- CSS -->
		<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/vendors/styles/core.css')); ?>" />
		<link
			rel="stylesheet"
			type="text/css"
			href="<?php echo e(asset('assets/vendors/styles/icon-font.min.css')); ?>"
		/>
		<link
			rel="stylesheet"
			type="text/css"
			href="<?php echo e(asset('assets/src/plugins/datatables/css/dataTables.bootstrap4.min.css')); ?>"
		/>
		<link
			rel="stylesheet"
			type="text/css"
			href="<?php echo e(asset('assets/src/plugins/datatables/css/responsive.bootstrap4.min.css')); ?>"
		/>
		<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/vendors/styles/style.css')); ?>" />
		<link rel="stylesheet" type="text/css" href="<?php echo e(asset('extra_assets/ijaboCropTool/ijaboCropTool.min.css')); ?>" />
		<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/src/plugins/switchery/switchery.min.css')); ?>" />
		<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jstree/3.2.1/themes/default/style.min.css" />
		<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

		<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css" integrity="sha512-vKMx8UnXk60zUwyUnUPM3HbQo8QfmNx7+ltw8Pm5zLusl1XIfwcxo8DbWCqMGKaWeNxWA8yrx5v3SaVpMvR3CA==" 
    crossorigin="anonymous" referrerpolicy="no-referrer" />

		<style>
			.select2-dropdown {
				top: 22px !important;
				left: 8px !important;
			}

			.select2-selection__rendered {
				line-height: 30px !important;
			}
			.select2-container .select2-selection--single {
				height: 38px !important;
			}
			.select2-selection__arrow {
				height: 30px !important;
			}
			
			#table, #table th, #table td {
				border: 1px solid #efeaea;
			}

			.type_t{
				font-weight: 600;
				color: brown;
			}

			.spinner_t{
				text-align: center;
			}

			

			.al_r{
				text-align: right;
			}

			.list_compte{
				border: 0.3px solid black;  
				height:105px; 
				box-shadow: 10px 10px 40px #efeaea;
			}

			.zone_btn button{
				margin-right: 3px;
			}

		</style>
	

		<?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

        <?php echo $__env->yieldPushContent('stylesheets'); ?>
	</head>
	<body class="sidebar-light">
	<!--	<div class="pre-loader">
			<div class="pre-loader-box">
				<div class="loader-logo">
					<img src="  asset('assets/vendors/images/deskapp-logo.svg') }}" alt="" />
				</div>
				<div class="loader-progress" id="progress_div">
					<div class="bar" id="bar1"></div>
				</div>
				<div class="percent" id="percent1">0%</div>
				<div class="loading-text">Loading...</div>
			</div>
		</div> -->

		<div class="header">
			<div class="header-left">
				<div class="menu-icon bi bi-list"></div>
				<div
					class="search-toggle-icon bi bi-search"
					data-toggle="header_search"
				></div>

				
			</div>
			
			<div class="header-right pr-5">

			<!-- comment 

				<div class="dashboard-setting user-notification">
					<div class="dropdown">
						<a
							class="dropdown-toggle no-arrow"
							href="javascript:;"
							data-toggle="right-sidebar"
						>
							<i class="dw dw-settings2"></i>
						</a>
					</div>
				</div>
			-->
				
				<div class="user-info-dropdown">
					<div class="dropdown">
						<a
							class="dropdown-toggle"
							href="#"
							role="button"
							data-toggle="dropdown"
						>
							<span class="user-icon">
								<img src="<?php echo e(asset(auth()->user()->picture)); ?>" alt="" />
							</span>
							<span class="user-name"><?php echo e(Str::ucfirst(auth()->user()->firstname)); ?>  <?php echo e(Str::ucfirst(auth()->user()->lastname)); ?></span>
						</a>
						<div
							class="dropdown-menu dropdown-menu-right dropdown-menu-icon-list"
						>
							<a class="dropdown-item" href="<?php echo e(route('profile')); ?>"
								><i class="dw dw-user1"></i> Profil</a
							>
							<a class="dropdown-item" href="profile.html"
								><i class="dw dw-settings2"></i> Setting</a
							>
							
							<a class="dropdown-item" href="<?php echo e(route('logout_handler')); ?>"
								onclick="event.preventDefault();document.getElementById('adminLogoutForm').submit();">
								<i class="dw dw-logout"></i> Log Out</a
							>
							<form action="<?php echo e(route('logout_handler')); ?>" method="post" id="adminLogoutForm"><?php echo csrf_field(); ?></form>
						
						</div>
					</div>
				</div>

			</div>
		</div>

		<!-- comment 
		<div class="right-sidebar">
			<div class="sidebar-title">
				<h3 class="weight-600 font-16 text-blue">
					Layout Settings
					<span class="btn-block font-weight-400 font-12"
						>User Interface Settings</span
					>
				</h3>
				<div class="close-sidebar" data-toggle="right-sidebar-close">
					<i class="icon-copy ion-close-round"></i>
				</div>
			</div>
			<div class="right-sidebar-body customscroll">
				<div class="right-sidebar-body-content">
					<h4 class="weight-600 font-18 pb-10">Header Background</h4>
					<div class="sidebar-btn-group pb-30 mb-10">
						<a
							href="javascript:void(0);"
							class="btn btn-outline-primary header-white active"
							>White</a
						>
						<a
							href="javascript:void(0);"
							class="btn btn-outline-primary header-dark"
							>Dark</a
						>
					</div>

					<h4 class="weight-600 font-18 pb-10">Sidebar Background</h4>
					<div class="sidebar-btn-group pb-30 mb-10">
						<a
							href="javascript:void(0);"
							class="btn btn-outline-primary sidebar-light"
							>White</a
						>
						<a
							href="javascript:void(0);"
							class="btn btn-outline-primary sidebar-dark active"
							>Dark</a
						>
					</div>

					<h4 class="weight-600 font-18 pb-10">Menu Dropdown Icon</h4>
					<div class="sidebar-radio-group pb-10 mb-10">
						<div class="custom-control custom-radio custom-control-inline">
							<input
								type="radio"
								id="sidebaricon-1"
								name="menu-dropdown-icon"
								class="custom-control-input"
								value="icon-style-1"
								checked=""
							/>
							<label class="custom-control-label" for="sidebaricon-1"
								><i class="fa fa-angle-down"></i
							></label>
						</div>
						<div class="custom-control custom-radio custom-control-inline">
							<input
								type="radio"
								id="sidebaricon-2"
								name="menu-dropdown-icon"
								class="custom-control-input"
								value="icon-style-2"
							/>
							<label class="custom-control-label" for="sidebaricon-2"
								><i class="ion-plus-round"></i
							></label>
						</div>
						<div class="custom-control custom-radio custom-control-inline">
							<input
								type="radio"
								id="sidebaricon-3"
								name="menu-dropdown-icon"
								class="custom-control-input"
								value="icon-style-3"
							/>
							<label class="custom-control-label" for="sidebaricon-3"
								><i class="fa fa-angle-double-right"></i
							></label>
						</div>
					</div>

					<h4 class="weight-600 font-18 pb-10">Menu List Icon</h4>
					<div class="sidebar-radio-group pb-30 mb-10">
						<div class="custom-control custom-radio custom-control-inline">
							<input
								type="radio"
								id="sidebariconlist-1"
								name="menu-list-icon"
								class="custom-control-input"
								value="icon-list-style-1"
								checked=""
							/>
							<label class="custom-control-label" for="sidebariconlist-1"
								><i class="ion-minus-round"></i
							></label>
						</div>
						<div class="custom-control custom-radio custom-control-inline">
							<input
								type="radio"
								id="sidebariconlist-2"
								name="menu-list-icon"
								class="custom-control-input"
								value="icon-list-style-2"
							/>
							<label class="custom-control-label" for="sidebariconlist-2"
								><i class="fa fa-circle-o" aria-hidden="true"></i
							></label>
						</div>
						<div class="custom-control custom-radio custom-control-inline">
							<input
								type="radio"
								id="sidebariconlist-3"
								name="menu-list-icon"
								class="custom-control-input"
								value="icon-list-style-3"
							/>
							<label class="custom-control-label" for="sidebariconlist-3"
								><i class="dw dw-check"></i
							></label>
						</div>
						<div class="custom-control custom-radio custom-control-inline">
							<input
								type="radio"
								id="sidebariconlist-4"
								name="menu-list-icon"
								class="custom-control-input"
								value="icon-list-style-4"
								checked=""
							/>
							<label class="custom-control-label" for="sidebariconlist-4"
								><i class="icon-copy dw dw-next-2"></i
							></label>
						</div>
						<div class="custom-control custom-radio custom-control-inline">
							<input
								type="radio"
								id="sidebariconlist-5"
								name="menu-list-icon"
								class="custom-control-input"
								value="icon-list-style-5"
							/>
							<label class="custom-control-label" for="sidebariconlist-5"
								><i class="dw dw-fast-forward-1"></i
							></label>
						</div>
						<div class="custom-control custom-radio custom-control-inline">
							<input
								type="radio"
								id="sidebariconlist-6"
								name="menu-list-icon"
								class="custom-control-input"
								value="icon-list-style-6"
							/>
							<label class="custom-control-label" for="sidebariconlist-6"
								><i class="dw dw-next"></i
							></label>
						</div>
					</div>

					<div class="reset-options pt-30 text-center">
						<button class="btn btn-danger" id="reset-settings">
							Reset Settings
						</button>
					</div>
				</div>
			</div>
		</div>

		-->


		<div class="left-side-bar">
			<div class="brand-logo">
				<a href="<?php echo e(route('home')); ?>">
				<!--	<img src=" asset('assets/vendors/images/deskapp-logo.svg') " alt="" class="dark-logo" />
					<img
						src=" asset('assets/vendors/images/deskapp-logo-white.svg') "
						alt=""
						class="light-logo"
					/>  -->
					Compta App
				</a>
				<div class="close-sidebar" data-toggle="left-sidebar-close">
					<i class="ion-close-round"></i>
				</div>
			</div>
			<div class="menu-block customscroll">
				<div class="sidebar-menu">
					<ul id="accordion-menu">

						
					
						
							<li>
								<a href="<?php echo e(route('admin.home')); ?>" class="dropdown-toggle no-arrow <?php echo e(Route::is('admin.home') ? 'active' : ''); ?>">
									<span class="micon bi bi-house"></span
									><span class="mtext">Accueil</span>
								</a>
							</li>
							<li>
								<div class="dropdown-divider"></div>
							</li>
							<li>
								<div class="sidebar-small-cap">Gestion</div>
							</li>
							<li>
								<a href="#" class="dropdown-toggle no-arrow ">
									<span class="micon bi bi-house"></span
									><span class="mtext">Demandes</span>
								</a>
							</li>

							<li>
								<a href="<?php echo e(route('admin.customer')); ?>" class="dropdown-toggle no-arrow <?php echo e(Route::is('admin.customer') ? 'active' : ''); ?>">
									<span class="micon bi bi-house"></span
									><span class="mtext">Entreprises</span>
								</a>
							</li>
							<li>
								<a
									href="<?php echo e(route('compte-devise')); ?>" class="dropdown-toggle no-arrow <?php echo e(Route::is('compte-devise') ? 'active' : ''); ?>"
								>
									<span class="micon bi bi-hdd-stack"></span>
									<span class="mtext"
										>Compte & Devise
										</span>
								</a>
							</li>
							
							<li>
								<div class="dropdown-divider"></div>
							</li>
							<li>
								<div class="sidebar-small-cap">Gestion Demande</div>
							</li>
							<li>
								<a href="#" class="dropdown-toggle no-arrow ">
									<span class="micon bi bi-house"></span
									><span class="mtext">Nouvelle</span>
								</a>
							</li>

							<li>
								<a href="<?php echo e(route('administration')); ?>" class="dropdown-toggle no-arrow <?php echo e(Route::is('administration') ? 'active' : ''); ?>">
									<span class="micon bi bi-house"></span
									><span class="mtext">Suivi</span>
								</a>
							</li>
							
							
							<li>
								<div class="dropdown-divider"></div>
							</li>
							<li>
								<div class="sidebar-small-cap">Settings</div>
							</li>
						
							<li>
								<a
									href="<?php echo e(route('profile')); ?>" class="dropdown-toggle no-arrow <?php echo e(Route::is('profile') ? 'active' : ''); ?>"
								>
									<span class="micon fa fa-user-o"></span>
									<span class="mtext"
										>Profil
										</span>
								</a>
							</li>

						

					<li class="dropdown">
						<a href="javascript:;" class="dropdown-toggle">
							<span class="micon bi bi-gear"></span
							><span class="mtext">Réglage</span>
						</a>
						<ul class="submenu">
							<li><a href="#" class="">Utilisateurs</a></li>
							<li><a href="<?php echo e(route('profil-entreprise')); ?>" class="<?php echo e(Route::is('profil-entreprise') ? 'active' : ''); ?>">Profil de l'Entreprise</a></li>
							
						</ul>
					</li>

					
					
						
					</ul>
				</div>
			</div>
		</div>
		<div class="mobile-menu-overlay"></div>

		<div class="main-container">
			<div class="pd-ltr-20 xs-pd-20-10">
				<div class="min-height-200px">
                        <?php echo $__env->yieldContent('content'); ?>
				</div>
			</div>
		</div>

		<!-- js -->
		<script src="<?php echo e(asset('assets/vendors/scripts/core.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/vendors/scripts/script.min.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/vendors/scripts/process.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/vendors/scripts/layout-settings.js')); ?>"></script>

		<script src="<?php echo e(asset('assets/src/plugins/datatables/js/jquery.dataTables.min.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/src/plugins/datatables/js/dataTables.bootstrap4.min.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/src/plugins/datatables/js/dataTables.responsive.min.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/src/plugins/datatables/js/responsive.bootstrap4.min.js')); ?>"></script>
		<!-- switchery js -->
		<script src="<?php echo e(asset('assets/src/plugins/switchery/switchery.min.js')); ?>"></script>

		<!-- Datatable Setting js -->
		<script src="<?php echo e(asset('assets/vendors/scripts/datatable-setting.js')); ?>"></script>
		
		<script src="<?php echo e(asset('extra_assets/ijaboCropTool/ijaboCropTool.min.js')); ?>"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js" integrity="sha512-VEd+nq25CkR676O+pLBnDW09R7VQX9Mdiij052gVCp5yVH3jGtH70Ho/UUv4mJDsEdTvqRCFZg0NKGiojGnUCw==" 
    crossorigin="anonymous" referrerpolicy="no-referrer"></script>

	<script src="https://cdnjs.cloudflare.com/ajax/libs/jstree/3.2.1/jstree.min.js"></script>
		<!-- <script>
			if(navigator.userAgent.indexOf("Firefox") != -1){
				history.pushState(null, null, document.URL);
				window.addEventLister('popstate',function(){
					history.pushState(null, null, document.URL);
				});
			}
		</script> -->


		<script>
			jQuery(document).ready(function($){
			   window.addEventListener('showToast', event => {
					Toast(event.detail.message);
				});

				
			});
		 </script>

		<script>
			function Toast(info){

				/*toast.remove();
				toastr.options = {
					"progressBar" : false ,
					"closeButton" : true
				}*/

				let res = info.split("|");
				let type = res[0];
				let message = res[1];


				if(type === "success"){
					toastr.success(""+ message +"",{timeOut:20000});
				}
				if(type === "failed"){
					toastr.error(""+ message +"",{timeOut:20000});
				}
				if(type === "info"){
					toastr.info(""+ message +"","info",{timeOut:20000});
				}
			}


	
			
		</script>
		<?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

		<?php echo $__env->yieldPushContent('scripts'); ?>
	</body>
</html>
<?php /**PATH C:\laragon\www\access\resources\views/layout/page-layout.blade.php ENDPATH**/ ?>