<!DOCTYPE html>
<html lang="fr">




<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>



    <style>
        body {
            font-family: sans-serif;
        }

        .box-container {
            /*width: 100%;
            /*padding: 2rem;
            border: 1px solid #f2f2f2;
            border-radius: 5px;
            background-color: #ffffff; 
            margin-left: 10%;
            margin-right: 10%; */
        }

        .pl-1 {
            padding-left: 0.3rem;
        }

        .pr-1 {
            padding-right: 0.3rem;
        }

        .box-container .title {
            font-weight: bold;
            padding: 1rem;
            border-bottom: 1px solid #f2f2f2;
            background-color: #f2f2f2;
        }

        .transaction-box {
            margin-top: 1rem;
        }

        .transaction-box .item {
            display: table;
            width: 100%;
            margin-bottom: 1rem;
        }

        .transaction-box .item>* {
            display: table-cell;
            vertical-align: middle;
        }

        .transaction-box .item> :first-child {
            text-align-last: left;
        }

        .transaction-box .item> :last-child {
            text-align-last: right;
            font-weight: bold;
        }

        .transaction_details_box {
            margin-top: 3rem;
            border-radius: 5px;
            display: table;
            width: 100%;
            margin-bottom: 3rem;
        }

        .transaction_details_box .left {
            display: table;
            margin-bottom: 1rem;
            width: 100%;
        }

        .transaction_details_box .left>* {
            display: table-cell;
            vertical-align: middle;
        }



        .transaction_details_box .left .item {
            display: table;
            width: 100%;
            float: left;
            margin-bottom: 1rem;
        }

        .transaction_details_box .left .item>* {
            display: table-cell;
            vertical-align: middle;

            width: 100%;
            margin-bottom: 1rem;
        }

        .transaction_details_box .left .item> :first-child {
            text-align: left;
        }

        .transaction_details_box .left .item> :last-child {
            text-align: right;
        }

        .transaction_details_box .right {
            display: table;
            width: 100%;
        }

        .transaction_details_box .right table {
            width: 100%;
        }

        .payment_tile {
            text-align: center;
            text-transform: uppercase;
            font-weight: bold;
            margin-top: 0.5rem;
            margin-bottom: 1.5rem;
            padding: 1rem;
            border-bottom: 1px solid #f2f2f2;
            background-color: #f2f2f2;
        }

        .mb-3 {
            margin-bottom: 1.5rem ;
        }

        th {
            background: #8a97a0;
            color: #fff;
        }

        trr {
            background: #f4f7f8;
        }

        trr:nth-child(even) {
            background: #e8eeef;
        }

        th,
        tdd {
            padding: 0.5rem;
        }

        .single_item .value {
            font-weight: bold;
        }
    </style>



</head>

<body>
    <div class="box-container">

                    <?php
                        $grand_t_montant = 0;
                        $grand_t_ant = 0;
                        $grand_t_amort = 0;
                        $grand_t_val_res = 0;
                        $libTitle = ($affiche_amort == "detail")? 'détaillé' : 'général';
                        $libColonne = ($affiche_amort == "detail")? 'date' : 'compte';

                    ?>


                    <div class="payment_tile">Tableau <?php echo e($libTitle); ?> des amortissements</div>

                    <table style="width: 100%; font-size:13.5px;" class="mb-3">
                        <tr>
                            <td style="width: 30%;" >Amortissement limites sur </td>
                            <td>: <?php echo e($amort_sur); ?> mois à la date du <?php echo e(get_format_date($amort_date,'L')); ?></td>
                        </tr>
                        <tr>
                            <td> Devise </td>
                            <td>: <?php echo e($devise); ?> - <?php echo e(get_libelle_devise($devise)); ?></td>
                        </tr>
                    </table>

                    
            <table class="" border="0" style="width: 100%; font-size:13px;">
                <tr style="background-color: black; color:white;" >
                    <td class="pl-1" style="width: 10%;"  ><?php echo e($libColonne); ?></td>
                    <td class="pl-1" style="width: %;"  >libellé</td>
                    <td class="pr-1" style="width: 12%;" align="center" >montant</td>

                    <?php if($affiche_amort == "detail"): ?>
                        <td class="pl-1" style="width: 2%;" align="center">D</td>
                    <?php endif; ?>

                    <td class="pr-1" style="width: 12%;" align="center" >ant</td>
                    <td class="pr-1" style="width: 12%;" align="center">amort</td>
                    <td class="pr-1" style="width: 12%;" align="center">val.rés</td>
                </tr>
                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $info): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <?php if($affiche_amort == "detail"): ?>
                    <tr style="background-color:#e3eae9;font-size:12px;">
                        <td class="pl-1"  ><b><?php echo e($info['num_compte']); ?></b></td>
                        <td class="pl-1" ><b><?php echo e($info['nom_compte']); ?></b></td>
                        <td class="pr-1" align="right" ><b><?php echo e(get_format_montant($info['t_montant'])); ?></b></td>
                        <td  align="center"></td>
                        <td class="pr-1" align="right" ><b><?php echo e(get_format_montant($info['t_ant'])); ?></b></td>
                        <td class="pr-1" align="right"><b><?php echo e(get_format_montant($info['t_amort'])); ?></b></td>
                        <td class="pr-1" align="right"><b><?php echo e(get_format_montant($info['t_val_res'])); ?></b></td>
                    </tr>
                    
                    <?php $__currentLoopData = $info['detail']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $immo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr style = "font-size:12px;">
                            <td class="pl-1"  ><?php echo e(get_format_date($immo['date_acq'])); ?></td>
                            <td class="pl-1"  ><?php echo e($immo['libelle']); ?></td>
                            <td class="pr-1" align="right" ><?php echo e(get_format_montant($immo['montant'] )); ?></td>
                            <td  align="center"><?php echo e($immo['periode']); ?></td>
                            <td class="pr-1" align="right" ><?php echo e(get_format_montant($immo['ant'])); ?></td>
                            <td class="pr-1" align="right"><?php echo e(get_format_montant($immo['amort'])); ?></td>
                            <td class="pr-1" align="right"><?php echo e(get_format_montant($immo['val_res'])); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <tr style="font-size:12px;">
                        <td class="pl-1"  ><?php echo e($info['num_compte']); ?></td>
                        <td class="pl-1" ><?php echo e($info['nom_compte']); ?></td>
                        <td class="pr-1" align="right" ><?php echo e(get_format_montant($info['t_montant'])); ?></td>
                        <td class="pr-1" align="right" ><?php echo e(get_format_montant($info['t_ant'])); ?></td>
                        <td class="pr-1" align="right"><?php echo e(get_format_montant($info['t_amort'])); ?></td>
                        <td class="pr-1" align="right"><?php echo e(get_format_montant($info['t_val_res'])); ?></td>
                    </tr>
                <?php endif; ?>

                    <?php
                    $grand_t_montant += $info['t_montant'];
                    $grand_t_ant += $info['t_ant'];
                    $grand_t_amort += $info['t_amort'];
                    $grand_t_val_res += $info['t_val_res'];
                    ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <tr style="background-color: black; color:white;">
                    <td class="pl-1" colspan="2" align="center" ><b>TOTAL GENERAL</b></td>
                    <td class="pr-1" align="right" ><b><?php echo e(get_format_montant($grand_t_montant)); ?></b></td>
                    
                    <?php if($affiche_amort == "detail"): ?>
                        <td  align="center"></td>
                    <?php endif; ?>

                    <td class="pr-1" align="right" ><b><?php echo e(get_format_montant( $grand_t_ant)); ?></b></td>
                    <td class="pr-1" align="right"><b><?php echo e(get_format_montant($grand_t_amort)); ?></b></td>
                    <td class="pr-1" align="right"><b><?php echo e(get_format_montant($grand_t_val_res)); ?></b></td>
                </tr>
            </table>


        
               

    </div>
</body>

</html>
<?php /**PATH D:\laravel_apps\big-manager\resources\views/pdf/table_immobilisation.blade.php ENDPATH**/ ?>