<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>



    <style>
        body {
            font-family: sans-serif;
        }

        .box-container {
            /*width: 100%;
            /*padding: 2rem;
            border: 1px solid #f2f2f2;
            border-radius: 5px;
            background-color: #ffffff; 
            margin-left: 10%;
            margin-right: 10%; */
        }

        .pl-1 {
            padding-left: 0.3rem;
        }

        .pr-1 {
            padding-right: 0.3rem;
        }

        .box-container .title {
            font-weight: bold;
            padding: 1rem;
            border-bottom: 1px solid #f2f2f2;
            background-color: #f2f2f2;
        }

        .transaction-box {
            margin-top: 1rem;
        }

        .transaction-box .item {
            display: table;
            width: 100%;
            margin-bottom: 1rem;
        }

        .transaction-box .item>* {
            display: table-cell;
            vertical-align: middle;
        }

        .transaction-box .item> :first-child {
            text-align-last: left;
        }

        .transaction-box .item> :last-child {
            text-align-last: right;
            font-weight: bold;
        }

        .transaction_details_box {
            margin-top: 3rem;
            border-radius: 5px;
            display: table;
            width: 100%;
            margin-bottom: 3rem;
        }

        .transaction_details_box .left {
            display: table;
            margin-bottom: 1rem;
            width: 100%;
        }

        .transaction_details_box .left>* {
            display: table-cell;
            vertical-align: middle;
        }



        .transaction_details_box .left .item {
            display: table;
            width: 100%;
            float: left;
            margin-bottom: 1rem;
        }

        .transaction_details_box .left .item>* {
            display: table-cell;
            vertical-align: middle;

            width: 100%;
            margin-bottom: 1rem;
        }

        .transaction_details_box .left .item> :first-child {
            text-align: left;
        }

        .transaction_details_box .left .item> :last-child {
            text-align: right;
        }

        .transaction_details_box .right {
            display: table;
            width: 100%;
        }

        .transaction_details_box .right table {
            width: 100%;
        }

        .payment_tile {
            text-align: center;
            text-transform: uppercase;
            font-weight: bold;
            margin-top: 0.5rem;
            margin-bottom: 1.5rem;
            padding: 1rem;
            border-bottom: 1px solid #f2f2f2;
            background-color: #f2f2f2;
        }

        .mb-3 {
            margin-bottom: 1.5rem ;
        }

        th {
            background: #8a97a0;
            color: #fff;
        }

        trr {
            background: #f4f7f8;
        }

        trr:nth-child(even) {
            background: #e8eeef;
        }

        th,
        tdd {
            padding: 0.5rem;
        }

        .single_item .value {
            font-weight: bold;
        }
    </style>



</head>

<body>
    <div class="box-container">

        @php
        $debit_somme  = 0 ;
        $credit_somme = 0 ;  
        $soldeInitial = get_soldeInitial($compte,$date_end); 
        $infoCompte   = get_info_compte($compte);

        if($infoCompte->type_compte === 'credit')
        {
            if($soldeInitial < 0){
                $soldeDebit = $soldeInitial ;
                $soldeCredit = null ;
            }else{
                $soldeDebit = null ;
                $soldeCredit = $soldeInitial ;
            }
        }else{

            if($soldeInitial < 0){
                $soldeDebit = null ;
                $soldeCredit = $soldeInitial ;
            }else{
                $soldeDebit = $soldeInitial ;
                $soldeCredit = null ;
            }
        }

        if($soldeDebit){
             $debit_somme += $soldeDebit ;
        }

        if($soldeCredit){
             $credit_somme += $soldeCredit ;
        }

    @endphp

    
    <div class="payment_tile">grand livre</div>

    <table style="width: 100%; font-size:13px;" class="mb-3">
        <tr>
            <td align="center" colspan="3" >Compte 
                : <b> {{ $compte }} - {{ $infoCompte->nom_compte }} </b>
            </td>
            
        </tr>
        <tr>
            
            <td style="width: 12%;" >Exercice </td> 
            <td>: {{ $exercice }} </td> 
            <td align="right">Période : {{ get_format_date($date_start,'L') }} au {{ get_format_date($date_end,'L') }}</td>
            
        </tr>
        <tr>
            <td> Devise </td>
            <td>: {{ $devise }} - {{ get_libelle_devise($devise) }}</td>
            <td style="  font-size:11px;" align="right">date print : </td>
        </tr>
    </table>

    

    <table border="1" style="width: 100%;  font-size:13px;border-collapse: collapse;">
        <tr >
            <td class="pl-1" style="width: 12%;"><b>Date</b></td>
            <td class="pl-1"><b>Libellé</b></td>
            <td align="center" style="width: 15%;"><b>Débit</b></td>
            <td align="center" style="width: 15%;"><b>Crédit</b></td>
        </tr>
        <tr>
            <td></td>
            <td colspan="1" align="right" class="pr-1"><b>Solde initial :</b></td>
            <td align="right" class="pr-1"><b>{{ get_format_montant($soldeDebit) }}</b></td>
            <td align="right" class="pr-1"><b>{{ get_format_montant($soldeCredit) }}</b></td>
        </tr>
        @foreach($data AS $info)
            <tr>
                <td class="pl-1">{{ get_format_date($info->date_valeur) }}</td>
                <td class="pl-1">{{ $info->intitule }}</td>
                <td class="pr-1" align="right">{{ get_format_montant($info->debit) }}</td>
                <td class="pr-1" align="right">{{ get_format_montant($info->credit) }}</td>
            </tr>
            @php
                $debit_somme += $info->debit ;
                $credit_somme += $info->credit ;   
           @endphp
        @endforeach

            @php
                 if($infoCompte->type_compte === 'credit')
                  {
                    /*** solde = totCredit - TotDebit  */
                       $solde = $credit_somme - $debit_somme ;
                  }else{
                    /** solde = totDébit - TotCredit */
                        $solde = $debit_somme - $credit_somme ;
                  }
            @endphp
        <tr style="background-color: #e3eae9; color:black;">
            <td colspan="2" align="right" class="pr-1">
                <b>Totaux :</b>
                </br>
                <b>Solde :</b>
            </td>
            <td align="right" valign="top" class="pr-1">
                <b>{{ get_format_montant($debit_somme) }}</b>
                </br>
                <b>
                @if($debit_somme < $credit_somme)
                       {{ get_format_montant(abs($solde)) }} 
                @endif
                </b>
            </td>
            <td align="right" valign="top" class="pr-1">
                <b>{{ get_format_montant($credit_somme) }}</b>
                </br>
                <b> 
                @if($credit_somme < $debit_somme)
                    {{ get_format_montant(abs($solde)) }} 
                @endif
            </b>
            </td>
        </tr>
    </table>

        
               

    </div>
</body>

</html>
