<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>



    <style>
        body {
            font-family: sans-serif;
        }

        .box-container {
            /*width: 100%;
            /*padding: 2rem;
            border: 1px solid #f2f2f2;
            border-radius: 5px;
            background-color: #ffffff; 
            margin-left: 10%;
            margin-right: 10%; */
        }

        .pl-1 {
            padding-left: 0.3rem;
        }

        .pr-1 {
            padding-right: 0.3rem;
        }

        .box-container .title {
            font-weight: bold;
            padding: 1rem;
            border-bottom: 1px solid #f2f2f2;
            background-color: #f2f2f2;
        }

        .transaction-box {
            margin-top: 1rem;
        }

        .transaction-box .item {
            display: table;
            width: 100%;
            margin-bottom: 1rem;
        }

        .transaction-box .item>* {
            display: table-cell;
            vertical-align: middle;
        }

        .transaction-box .item> :first-child {
            text-align-last: left;
        }

        .transaction-box .item> :last-child {
            text-align-last: right;
            font-weight: bold;
        }

        .transaction_details_box {
            margin-top: 3rem;
            border-radius: 5px;
            display: table;
            width: 100%;
            margin-bottom: 3rem;
        }

        .transaction_details_box .left {
            display: table;
            margin-bottom: 1rem;
            width: 100%;
        }

        .transaction_details_box .left>* {
            display: table-cell;
            vertical-align: middle;
        }



        .transaction_details_box .left .item {
            display: table;
            width: 100%;
            float: left;
            margin-bottom: 1rem;
        }

        .transaction_details_box .left .item>* {
            display: table-cell;
            vertical-align: middle;

            width: 100%;
            margin-bottom: 1rem;
        }

        .transaction_details_box .left .item> :first-child {
            text-align: left;
        }

        .transaction_details_box .left .item> :last-child {
            text-align: right;
        }

        .transaction_details_box .right {
            display: table;
            width: 100%;
        }

        .transaction_details_box .right table {
            width: 100%;
        }

        .payment_tile {
            text-align: center;
            text-transform: uppercase;
            font-weight: bold;
            margin-top: 0.5rem;
            margin-bottom: 1.5rem;
            padding: 1rem;
            border-bottom: 1px solid #f2f2f2;
            background-color: #f2f2f2;
        }

        .mb-3 {
            margin-bottom: 1.5rem ;
        }

        th {
            background: #8a97a0;
            color: #fff;
        }

        trr {
            background: #f4f7f8;
        }

        trr:nth-child(even) {
            background: #e8eeef;
        }

        th,
        tdd {
            padding: 0.5rem;
        }

        .single_item .value {
            font-weight: bold;
        }
    </style>



</head>

<body>
    <div class="box-container">

        @php

            $somme_init_debit = 0 ;
            $somme_init_credit= 0 ;
            $somme_variation_debit = 0 ;
            $somme_variation_credit= 0 ;
            $somme_solde_debit = 0 ;
            $somme_solde_credit= 0 ;

        @endphp

    
    <div class="payment_tile">balance des comptes</div>

    <table style="width: 100%; font-size:13.5px;" class="mb-3">
        <tr>
            <td style="width: 8%;">Exercice</td> 
            <td>: {{ $exercice }}</td>
            <td align="right">Période : {{ get_format_date($date_start,'L') }} au {{ get_format_date($date_end,'L') }}</td>
        </tr>
        <tr>
            <td>Devise</td>
            <td>: {{ $devise }} - {{ get_libelle_devise($devise) }}</td>
            <td style="  font-size:11px;" align="right">date print : </td>
        </tr>
    </table>

    <table class="" border="1" style="width: 100%;  font-size:13px;border-collapse: collapse;">
        <tr>
            <td class="pl-1" style="width: 8%;"><b>COMPTE</b></td>
            <td class="pl-1" align="center" style="width: 34%;"><b>INTITULE DE COMPTE</b></td>
            <td class="pl-1" style="width: 14%;" colspan="2" align="center"><b>SOLDE INITIAL</b></td>
            <td class="pl-1" style="width: 14%;" colspan="2" align="center"><b>VARIATIONS</b></td>
            <td class="pl-1" style="width: 14%;" colspan="2" align="center"><b>SOLDE</b></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td  class="pl-1" align="center">débit</td>
            <td  class="pl-1" align="center">crédit</td>
            <td  class="pl-1" align="center">débit</td>
            <td  class="pl-1" align="center">crédit</td>
            <td  class="pl-1" align="center">débit</td>
            <td  class="pl-1" align="center">crédit</td>
        </tr>
        @foreach($data AS $info)
               
                @php
                    $bgColor = "";
                    $textColor = "";

                    if($info['compte'] <> '')
                    { 
                        $somme_init_debit += $info['soldeInitial']['debit_true'] ;
                        $somme_init_credit += $info['soldeInitial']['credit_true'] ;
                        $somme_variation_debit += $info['variations']['debit_true'] ;
                        $somme_variation_credit += $info['variations']['credit_true'] ;
                        $somme_solde_debit += $info['solde']['debit_true'] ;
                        $somme_solde_credit += $info['solde']['credit_true'] ;
                    }else{
                        $bgColor = "#e3eae9";
                        $textColor = "";
                    }
                @endphp
                 <tr style="background-color: {{ $bgColor }};color: {{ $textColor }};">
                    <td class="pl-1">{{ $info['compte'] }}</td>
                    <td class="pl-1">{{ $info['intitule'] }}</td>
                    <td class="pr-1" align="right">{{ get_format_montant($info['soldeInitial']['debit']) }}</td>
                    <td class="pr-1" align="right">{{ get_format_montant($info['soldeInitial']['credit']) }}</td>
                    <td class="pr-1" align="right">{{ get_format_montant($info['variations']['debit']) }}</td>
                    <td class="pr-1" align="right">{{ get_format_montant($info['variations']['credit']) }}</td>
                    <td class="pr-1" align="right">{{ get_format_montant($info['solde']['debit']) }}</td>
                    <td class="pr-1" align="right">{{ get_format_montant($info['solde']['credit']) }}</td>
                </tr>
        @endforeach
        <tr style="background-color: black;color: white;">
                    
                    <td class="pl-1" colspan="2" align="center">TOTAL GENERAL</td>
                    <td class="pr-1" align="right">{{ get_format_montant($somme_init_debit) }}</td>
                    <td class="pr-1" align="right">{{ get_format_montant($somme_init_credit) }}</td>
                    <td class="pr-1" align="right">{{ get_format_montant($somme_variation_debit) }}</td>
                    <td class="pr-1" align="right">{{ get_format_montant($somme_variation_credit) }}</td>
                    <td class="pr-1" align="right">{{ get_format_montant($somme_solde_debit) }}</td>
                    <td class="pr-1" align="right">{{ get_format_montant($somme_solde_credit) }}</td>
        </tr>
    </table>

    
        

    </div>

    <script type="text/php"> 
    
        if (isset($pdf)) { 
         //Shows number center-bottom of A4 page with $x,$y values
            $x = 250;  //X-axis i.e. vertical position 
            $y = 820; //Y-axis horizontal position
            $text = "Page {PAGE_NUM} of {PAGE_COUNT}";  //format of display message
            $font =  $fontMetrics->get_font("helvetica", "bold");
            $size = 10;
            $color = array(255,0,0);
            $word_space = 0.0;  //  default
            $char_space = 0.0;  //  default
            $angle = 0.0;   //  default
            $pdf->page_text($x, $y, $text, $font, $size, $color, $word_space, $char_space, $angle);
        }
        
        </script>
</body>

</html>
