@extends('layout.page-layout')
@section('pageTitle',isset($pageTitle) ? $pageTitle : 'Profile user')

@section('content')

<div class="row mb-3 ">
    <div class="col-md-6 col-sm-12">
        <div class="title">
            <h2 class="h3 mb-0">Profil</h2>
        </div>
    </div>
</div>


<div class="row">
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 mb-30">
        <div class="pd-20 card-box height-100-p">
            <div class="profile-photo">
                <a href="javascript:;"  onclick="event.preventDefault();document.getElementById
                ('ProfilePictureFile').click();"  
                class="edit-avatar"><i class="fa fa-pencil"></i></a>
                <img src="{{ $user->picture }}" alt="" class="avatar-photo" id="ProfilePicture">
                <input type="file" name="ProfilePictureFile" id="ProfilePictureFile" class="d-none"
                style="opacity: 0">

            </div>
            <h5 class="text-center h5 mb-0" id="ProfileName">{{ Str::ucfirst($user->prenom) }}  {{ Str::ucfirst($user->nom) }}</h5>
            <p class="text-center text-muted font-14" id="ProfileEmail">
                {{ $user->email }}
            </p>
         
        </div>
    </div>
    <div class="col-xl-8 col-lg-8 col-md-8 col-sm-12 mb-30">
        <div class="card-box height-100-p overflow-hidden">
            @livewire('profile-tabs')
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
          $('input[type="file"][name="ProfilePictureFile"][id="ProfilePictureFile"]').ijaboCropTool({
          preview : '#ProfilePicture',
          setRatio:1,
          allowedExtensions: ['jpg', 'jpeg','png'],
          buttonsText:['Save','Cancel'],
          buttonsColor:['#30bf7d','#ee5155', -15],
          processUrl:'',
          withCSRF:['_token','{{ csrf_token() }}'],
          onSuccess:function(message, element, status){
             alert(message);
          },
          onError:function(message, element, status){
            alert(message +' '+JSON.stringify(element)) ;
          }
       });
</script>
    
@endpush

