@extends('admin.layout.page-layout')
@section('pageTitle',isset($pageTitle) ? $pageTitle : 'Partenaires')

@section('content')

<div class="page-header">
    <div class="row">
        <div class="col-md-6 col-sm-12">
            <div class="title">
                <h4>Partenaires</h4>
            </div>
            <nav aria-label="breadcrumb" role="navigation">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="{{ route('admin.home') }}">Home</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        Partenaires
                    </li>
                </ol>
            </nav>
        </div>
        
    </div>
</div>


<div class="row">
    <div class="col-lg-12 col-md-12 col-sm-12 mb-30">
        <div class="pd-20 card-box">
           
            @livewire('admin.partenaire')
        </div>
    </div>
</div>


@endsection


@push('scripts')

<script>
    	window.addEventListener('hideModal', event => {
					$('#confirmation-modal').modal('hide');
                    $('#modal-update-partenaire-lg').modal('hide');
				})

        window.addEventListener('showModal', event => {
					$('#modal-update-partenaire-lg').modal('show');
				})
</script>
    
@endpush

