@extends('layout.access-layout')
@section('pageTitle',isset($pageTitle) ? $pageTitle : 'Access')

@section('content')


<div class="row">

    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 ">

        @if($demande)

        <div class="pd-20 bg-white border-radius-4 box-shadow mb-30" style="padding: 50px 80px 50px 80px;">
            <div class="row mb-8">
                <div class="col-2">
                    <img src="{{ asset('images/logo.png') }}" alt="logo" width="110" height="110">
                </div>
                <div class="col-8" style="padding-top: 10px;">
                    <div style="font-size:larger; font-weight: 900;text-align:center; color:dodgerblue;">REPUBLIQUE DEMOCRATIQUE DU CONGO</div>
                    <div style="font-size: smaller; font-weight: 800;text-align: center;color:brown;">PRESIDENCE DE LA REPUBLIQUE</div>
                    <div style="font-size: smaller; font-weight: 800;text-align: center; color:dodgerblue;">CONSEIL NATIONAL DE CYBERDEFENCE</div>
                    <div style="font-size: smaller; font-weight: 800;text-align: center; color:dodgerblue;">
                        CNC
                    </div>
                </div>
                <div class="col-2">

                </div>

            </div>
            <hr>

            <h5 class="mb-10 mt-5">Object : Autorisation d’accès pour maintenance sur le site {{$demande->nom_site}}</h5>
            <br><br>
            <p style="font-family: tahoma;text-align: justify;">
                Je soussigné(e), <b>[Nom et Prénom]</b>, agissant en qualité de <b>[Fonction]</b> au sein de <b> CNC </b> ,
                autorise par la présente l’accès au site <b>{{ $demande->nom_site }}</b> situé à {{ $demande->adress_society }} à l’équipe technique désignée ci-dessous
                , afin de procéder à des opérations de maintenance sur les équipements informatiques.
            </p>


            Date intervention : {{$demande->date_d}} à {{$demande->heure_d}}</br>
            Date fin travaux : {{$demande->date_f}} à {{$demande->heure_f}}


            <h6 class="mb-10 mt-3">Liste des techniciens intervenants :</h6>


            <table border="0" class="table-sm" style="font-size:0.8em; width:100%;">
                <thead>
                    <tr style="font-weight: 600;">
                        <td>#</td>
                        <td>Noms</td>
                        <td>Téléphone</td>
                        <td>Email</td>

                    </tr>
                </thead>
                <tbody>
                    @php
                    $n = 0 ;
                    @endphp
                    @forelse ($listIntervenants as $data )

                    @php
                    $n++ ;
                    @endphp

                    <tr>
                        <td>{{ $n }}</td>
                        <td>{{ $data->full_name }}</td>
                        <td>{{ $data->telephone }}</td>
                        <td>{{ $data->address_mail }}</td>
                    </tr>
                    @empty

                    @endforelse
                </tbody>
            </table>

            <p style="margin-top:30px;">
                L’équipe est autorisée à accéder aux zones nécessaires à la réalisation des travaux.
                Elle est tenue de respecter strictement les règles de sécurité et de confidentialité en vigueur sur le site.
                <br><br>

                Je reste à votre disposition pour toute information complémentaire.
                <br><br>
            </p>
            <div style="text-align: right; padding-bottom: 150px;">
                Fait à kinshasa, le {{ $demande->dtraitment }}
                <br><br>
                Signature
                <br>
                Nom, fonction et tampon
            </div>


        </div>


        @endif

    </div>
</div>

@endsection