<div>
    
    <div wire:ignore.self
									class="modal fade"
									id="confirmation_modal_achat"
									tabindex="-1"
									role="dialog"
									aria-hidden="true"
                                    data-backdrop="static"
								>
									<div
										class="modal-dialog modal-dialog-centered"
										role="document"
									>
										<div class="modal-content">
											<div class="modal-body text-center font-18">
												<h4 class="padding-top-30 mb-30 weight-500">
													Voulez-vous faire ce changement?
												</h4>
												<div
													class="padding-bottom-30 row"
													style="max-width: 170px; margin: 0 auto"
												>
													<div class="col-6">
														<button
															type="button"
															class="btn btn-secondary border-radius-100 "
															data-dismiss="modal"
														>
															<i class="fa fa-times"></i> Non
														</button>
														
													</div>
													<div class="col-6">
														<button
															type="button"
															class="btn btn-primary border-radius-100 "
															wire:click=""
														>
															<i class="fa fa-check"></i> Oui
														</button>
														
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>











    <div class="profile-tab height-100-p">
        <div class="tab height-100-p">
            <ul class="nav nav-tabs customtab" role="tablist">
                <li class="nav-item">
                    <a wire:click.prevent="selectTab('achat')" class="nav-link {{ $tab == 'achat' ? 'active' : '' }}" data-toggle="tab" href="#timeline" role="tab">Achats</a>
                </li>
                <li class="nav-item">
                    <a wire:click.prevent="selectTab('vente')" class="nav-link {{ $tab == 'vente' ? 'active' : '' }}" data-toggle="tab" href="#tasks" role="tab">Ventes</a>
                </li>
                <li class="nav-item">
                    <a wire:click.prevent="selectTab('od')" class="nav-link {{ $tab == 'od' ? 'active' : '' }}" data-toggle="tab" href="#od" role="tab">Opérations diverses</a>
                </li>
                
            </ul>
            <div class="tab-content">
                <!-- Timeline Tab start -->
                <div class="tab-pane fade {{ $tab == 'achat' ? 'show active' : '' }}" id="timeline" role="tabpanel">
                    <div class="pd-20">
                    <form >
                       <div class="row">
                         <div class="col-md-6">
                           
                                <div class="row mb-2">
                                    <div class="col-md-6">
                                       
                                            <label for="">Date <span style="color:red;">*</span></label>
                                            <input type="date"  class="form-control form-control-sm" wire:model="date_achat" tabindex="1" >
                                            @error('date_achat')
                                                <small class="form-text text-danger">{{ $message }}</small>
                                            @enderror
                                        
                                    </div>
                                    <div class="col-md-6">
                                        
                                            <label for="">Réference doc.<span style="color:red;">*</span></label>
                                            <input type="text"  class="form-control form-control-sm" wire:model="reference_achat" tabindex="2"   >
                                            @error('reference_achat')
                                                <small class="form-text text-danger">{{ $message }}</small>
                                            @enderror
                                        
                                    </div>
                                    </div>

                              
                                    <div class=" row mb-2">
                                        <div class="col-md-12">
                                           
                                                <label for="">Libellé<span style="color:red;">*</span></label>
                                                <input type="text"  class="form-control form-control-sm" wire:model="libelle_achat" tabindex="5"   >
                                                @error('libelle_achat')
                                                    <small class="form-text text-danger">{{ $message }}</small>
                                                @enderror
                                            
                                        </div>
                                    </div>

                                    <div class="row mb-2">
                                    <div class="col-md-6">
                                       
                                            <label for="">Fournisseur <span style="color:red;">*</span></label>
                                          
                                            <select 
                                                class="form-control form-control-sm"
                                                wire:model.live="idFournisseur_achat"
                                                tabindex="6"
                                                        >
                                                    <option value="">select</option>
                                                @foreach(get_tiers('fourn') AS $info )
                                                        <option value="{{ $info->id }}">{{ $info->denomination}} </option>
                                                @endforeach
                                                            
                                            </select>
                                            
                                        
                                    </div>
                                    <div class="col-md-6">
                                 
                                            <label for="">Compte tiers</label>
                                            
                                            <select 
                                                        class="form-control form-control-sm"
                                                        wire:model.live="compte_tiers_achat" 
                                                        tabindex="7"
                                                                >
                                                            <option value="" disabled></option>
                                                        @if($ListCompte_achat)
                                                            @foreach($ListCompte_achat AS $compte )
                                                                    <option @selected($value_tiers == $compte->num_compte) value="{{ $compte->num_compte }}">{{ $compte->num_compte}} - {{ $compte->nom_compte }}</option>
                                                            @endforeach
                                                        @endif
                                                                    
                                            </select>
                                            @error('')
                                                <small class="form-text text-danger">{{ $message }}</small>
                                            @enderror
                                            
                                    
                                       
                                    </div>
                                 
                                </div>
                            
                           
                                <div class="row mb-3">
                                    <div class="col-md-4">
                                        
                                            <label for="">Compte Géneral</label>
                                            
                                            <input type="text"  class="form-control form-control-sm" wire:model="compte_achat" maxlength="8"  tabindex="9">
                                            
                                            @error('compte_achat')
                                                <small class="form-text text-danger">{{ $message }}</small>
                                            @enderror
                                            
                                        
                                       
                                    </div>
                                    <div class="col-md-3">
                                        
                                            <label for="">Débit</label>
                                            <input type="text"  class="form-control form-control-sm" wire:model="debit_achat" wire:keydown.enter="addItemby"
                                            tabindex="10"
                                            >
                                            @error('debit_achat')
                                                <small class="form-text text-danger">{{ $message }}</small>
                                            @enderror
                                        
                                    </div>
                                    <div class="col-md-3">
                                        
                                            <label for="">Crédit</label>
                                            <input type="text"  class="form-control form-control-sm" wire:model="credit_achat" wire:keydown.enter="addItemby"
                                            tabindex="11"
                                            >
                                            @error('credit_achat')
                                                <small class="form-text text-danger">{{ $message }}</small>
                                            @enderror
                                        
                                    </div>
                                    <div class="col-md-2 ">
                                        <div class="row " style="padding-top: 38px;">
                                            
                                            <span class="badge  badge-primary" wire:click="addItem_achat" style="cursor:pointer;" title="Ajouter" >
                                               
                                                <i class="icon-copy fa fa-check" ></i>
                                            </span> 
                                            &nbsp;&nbsp;
                                            <span class="badge badge-dark" wire:click="equilibrerJAchat" style="cursor:pointer;" title="Equilibrer" >
                                                <i class="icon-copy fa fa-location-arrow" ></i>
                                                
                                            </span>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">

                                    <div class="col-md-8 offset-md-2">
                      

                                        @error('MyArray_achat')
                                        <table border="0" class="table-striped table-sm" style="font-size:0.8em; width:100%;">
                                            <thead>
                                                <tr>
                                                    <td>compte</td>
                                                    <td >débit</td>
                                                    <td >crédit</td>
                                                   
                                                </tr>
                                            </thead>    
                                            <tbody>
                                                <tr>
                                                    <td colspan="3" align="center"  class="text-danger" >
                                                            {{ $message }}
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        @enderror
                                    </div>
        
                                </div>
                           
                                  
                         </div>
                         <div class="col-md-6">
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    
                                        <label for="">Numéro facture</label>
                                        <input type="text"  class="form-control form-control-sm" wire:model="NumFacture_achat" tabindex="3"  >
                                        @error('NumFacture_achat')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                            
                                </div>

                                <div class="col-md-6">
                                    
                                        <label for="">Devise <span style="color:red;">*</span></label>
                                        <select class="form-control form-control-sm" wire:model="devise_achat" tabindex="4">
                                           @foreach ( get_select_devise() as $devise )
                                               <option value="{{ $devise->devise }}">{{ $devise->devise}} - {{ $devise->intitule }}</option>
                                           @endforeach
                                        </select>
                                        @error('devise_achat')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    
                                </div>
                            </div>

                            <div class="row mx-1" style="border: 1px solid black; height: 220px; position:relative;">
                                <div style="width: 100%;">
                                    
                                    @empty($MyArray_achat)
                                         
                                    @else
                                        <table border="0" class="table-striped table-sm" style="font-size:0.8em; width:100%;">
                                        <thead>
                                            <tr style="font-weight: 600;">
                                                <td>compte</td>
                                                <td>intitulé de compte</td>
                                                <td align="right">débit</td>
                                                <td align="right">crédit</td>
                                                <td></td>
                                            </tr>
                                        </thead>    
                                        <tbody>
                                            @foreach ( $MyArray_achat as  $data )
                                            
                                                <tr>
                                                    <td>{{ $data['compte'] }}</td>
                                                    <td>{{ $data['intitule'] }}</td>
                                                    <td align="right"> @if($data['debit'] == 0) {{ '' }}  @else {{ get_format_montant($data['debit']) }} @endif </td>
                                                    <td align="right">@if($data['credit'] == 0) {{ '' }}  @else {{ get_format_montant($data['credit']) }} @endif </td>
                                                    <td align="center" ><span class="text-danger"  wire:click="removeItem_achat({{ $data['compte'] }})"  style="cursor:pointer;"><i class="fa fa-times"></i></span></td>
                                                </tr>
                                            @endforeach

                                            
                                        </tbody>
                                        </table>
                                    @endempty
                                </div>
                                
                                <div class="py-1" style="height:40px;border: 0px solid red; position:absolute;
                                bottom:0;width:100%; display:flex; justify-content:space-around;background-color:@if($isEgal_achat) #1D8348 @else #EAECEE @endif">
                                   <span style="font-size:0.8em;">
                                    Débit : <strong style="font-size:1.3em;font-weight:700;color:@if($isEgal_achat) white @else '' @endif;">{{ get_format_montant($total_debit) }}</strong></span>  
                                   <span class="py-1">|</span> 
                                   <span style="font-size:0.8em;">
                                    Crédit : <strong style="font-size:1.3em;font-weight:700;color:@if($isEgal_achat) white @else '' @endif;">{{ get_format_montant($total_credit) }}</strong></span> 
                                </div>
                            </div>

                         </div>
                        
                       </div>
                       <div class="row zone_btn">
                                <button type="button" wire:click="resetForm_achat" class="btn btn-light btn-sm">Annuler</button>
                                            
                                <button type="button" class="btn btn-primary btn-sm" wire:click="saveAchat" wire:loading.attr="disabled" style="width:15%;" @if(!$isEgal_achat) disabled @endif> 
                                        
                                        <div class="spinner-border spinner-border-sm"  role="status" wire:loading wire:target="saveAchat">
                                            <span class="visually-hidden"></span>
                                        </div>
                        
                                        <div wire:loading.remove wire:target="saveAchat">
                                            Enregistrer 
                                        </div>
                                    
                                </button>

                                <button type="button" wire:click="$dispatch('showFactureEnCours')" class="btn btn-success btn-sm">Factures en cours</button>
                                <button type="button" wire:click="$dispatch('NewTiers')" class="btn btn-outline-primary btn-sm">Ajouter Tiers</button>
                       </div>
                    </form>
                    </div>
                </div>
                <!-- Timeline Tab End -->
                <!-- Tasks Tab start -->
                <div class="tab-pane fade {{ $tab == 'vente' ? 'show active' : '' }}" id="tasks" role="tabpanel">
                   <div class="pd-20 profile-task-wrap">
                    <div class="row">
                        <div class="col-md-12">
                           <form  >
                               <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group"  wire:ignore>
                                        <label for="">Client <span style="color:red;">*</span></label>
                                      
                                        <select 
                                            class="form-control form-control-sm"
                                            style="width: 100%; height: 50px;"
                                            id="Select_tiers_vente"
                                                    >
                                                <option value="">select</option>
                                            @foreach(get_tiers('client') AS $info )
                                                    <option value="{{ $info->id }}">{{ $info->denomination}} </option>
                                            @endforeach
                                                        
                                        </select>
                                        
                                    </div>
                                </div>
                                   <div class="col-md-3">
                                       <div class="form-group">
                                           <label for="">N° Facture <span style="color:red;">*</span></label>
                                           <input type="text"  class="form-control form-control-sm" wire:model="NumFacture_vente"  >
                                           @error('NumFacture_vente')
                                                <small class="form-text text-danger">{{ $message }}</small>
                                           @enderror
                                       </div>
                                   </div>
                                   <div class="col-md-3">
                                       <div class="form-group">
                                           <label for="">Date <span style="color:red;">*</span></label>
                                           <input type="date"  class="form-control form-control-sm" wire:model="date_vente" >
                                           @error('date_vente')
                                                <small class="form-text text-danger">{{ $message }}</small>
                                           @enderror
                                       </div>
                                   </div>
                               </div>
                               <div class="form-group row">
                                <label class="col-sm-12 col-md-2 col-form-label">Objet <span style="color:red;">*</span></label>
                                <div class="col-sm-12 col-md-10">
                                    <input type="text"  class="form-control form-control-sm" wire:model="libelle_vente" />
                                    @error('libelle_vente')
                                        <small class="form-text text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                               <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group" >
                                        <label for="">Compte</label>
                                       
                                        <select 
                                                    class="form-control form-control-sm"
                                                    wire:model.live="compte_vente" 
                                                    id="Select_Compte_ventee"
                                                            >
                                                        <option value="">select</option>
                                                   
                                                    @if($ListCompte_vente)
                                                        @foreach($ListCompte_vente AS $compte )
                                                                <option value="{{ $compte->num_compte }}">{{ $compte->num_compte}} - {{ $compte->nom_compte }}</option>
                                                        @endforeach
                                                    @endif
                                                                
                                        </select>
                                        @error('compte_vente')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                        
                                    </div>
                                   
                                </div>
                                   <div class="col-md-2">
                                       <div class="form-group">
                                           <label for="">Débit</label>
                                           <input type="text"  class="form-control form-control-sm" wire:model="debit_vente" @if($readonly_debit_vente) readonly @endif>
                                           @error('debit_vente')
                                                <small class="form-text text-danger">{{ $message }}</small>
                                           @enderror
                                       </div>
                                   </div>
                                   <div class="col-md-2">
                                       <div class="form-group">
                                           <label for="">Crédit</label>
                                           <input type="text"  class="form-control form-control-sm" wire:model="credit_vente" @if($readonly_credit_vente) readonly @endif>
                                           @error('credit_vente')
                                                <small class="form-text text-danger">{{ $message }}</small>
                                           @enderror
                                       </div>
                                   </div>
                                   <div class="col-md-2 ">
                                    <div class="row " style="padding-top: 38px;">
                                        
                                        <span class="badge  badge-primary" wire:click="addItem_vente" style="cursor:pointer;" title="Ajouter" >
                                            <i class="icon-copy dw dw-right-arrow-4"> </i>
                                        </span> 
                                        &nbsp;&nbsp;
                                        <span class="badge badge-primary" wire:click="annulerItem_vente" style="cursor:pointer;" title="Annuler" ><i class="icon-copy dw dw-delete-1"></i></span>
                                    </div>
                                </div>
                               </div>
                               <div class="row">

                                <div class="col-md-8 offset-md-2">
                  
                                    @empty($MyArray_vente)
                                     
                                    @else
                                        <table border="0" class="table-striped table-sm" style="font-size:0.8em; width:100%;">
                                        <thead>
                                            <tr>
                                                <td>compte</td>
                                                <td align="right">débit</td>
                                                <td align="right">crédit</td>
                                                <td></td>
                                            </tr>
                                        </thead>    
                                        <tbody>
                                            @foreach ( $MyArray_vente as  $data )
                                            
                                                <tr>
                                                    <td>{{ $data['compte'] }}</td>
                                                    <td align="right">{{ get_format_montant($data['debit']) }}</td>
                                                    <td align="right">{{ get_format_montant($data['credit']) }}</td>
                                                    <td align="center" ><span class="text-danger"  wire:click="removeItem_achat({{ $data['compte'] }})"  style="cursor:pointer;"><i class="fa fa-times"></i></span></td>
                                                </tr>
                                            @endforeach

                                            
                                        </tbody>
                                        </table>
                                    @endempty

                                    @error('MyArray_vente')
                                    <table border="0" class="table-striped table-sm" style="font-size:0.8em; width:100%;">
                                        <thead>
                                            <tr>
                                                <td>compte</td>
                                                <td >débit</td>
                                                <td >crédit</td>
                                               
                                            </tr>
                                        </thead>    
                                        <tbody>
                                            <tr>
                                                <td colspan="3" align="center"  class="text-danger" >
                                                        {{ $message }}
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    @enderror
                                </div>
    
                            </div>
                               <div class="row">
                                   <div class="col-md-6">
                                       <div class="form-group">
                                           <label for="">Total <span style="color:red;">*</span></label>
                                           <input type="text"  class="form-control form-control-sm" wire:model="total_ttc_vente" readonly  >
                                           @error('total_ttc_vente')
                                                <small class="form-text text-danger">{{ $message }}</small>
                                           @enderror
                                       </div>
                                   </div>

                                   <div class="col-md-6">
                                       <div class="form-group">
                                           <label for="">Devise <span style="color:red;">*</span></label>
                                           <select class="form-control form-control-sm" wire:model="devise_vente">
                                              @foreach ( get_select_devise() as $devise )
                                                  <option value="{{ $devise->devise }}">{{ $devise->devise}} - {{ $devise->intitule }}</option>
                                              @endforeach
                                           </select>
                                           @error('devise_vente')
                                                <small class="form-text text-danger">{{ $message }}</small>
                                           @enderror
                                       </div>
                                   </div>
                               </div>
                               <button type="button" wire:click="resetForm_vente" class="btn btn-light">Annuler</button>
                                    
                               <button type="button" class="btn btn-primary" wire:click="saveVente" wire:loading.attr="disabled" style="width:15%;"> 
                                       
                                        <div class="spinner-border spinner-border-sm"  role="status" wire:loading wire:target="saveVente">
                                           <span class="visually-hidden"></span>
                                       </div>
                       
                                       <div wire:loading.remove wire:target="saveVente">
                                            Enregistrer 
                                       </div>
                                      
                               </button>

                               <button type="button" wire:click="$dispatch('showFactureEnCours')" class="btn btn-success">Factures en cours</button>
                           </form>
                        </div>
                        
                      </div>
                 
                   </div>
                </div>
                <!-- Tasks Tab End -->
                <!-- Tasks Tab OD -->
                   <div class="tab-pane fade {{ $tab == 'od' ? 'show active' : '' }}" id="od" role="tabpanel">
                    <div class="pd-20 profile-task-wrap">
                    <div class="row">
                        <div class="col-md-12">
                           <form enctype="multipart/form-data" >
                               <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group"  wire:ignore>
                                        <label for="">Tiers <span style="color:red;">*</span></label>
                                      
                                        <select 
                                            class="form-control form-control-sm"
                                            style="width: 100%; height: 50px;"
                                            id="Select_tiers_od"
                                                    >
                                                <option value="">select</option>
                                                <optgroup label="FOURNISSEUR">  
                                                    @foreach(get_tiers('fourn') AS $info )
                                                            <option value="{{ $info->id }}">{{ $info->denomination}} </option>
                                                    @endforeach
                                                </optgroup>
                                                <optgroup label="CLIENT">  
                                                    @foreach(get_tiers('client') AS $info )
                                                            <option value="{{ $info->id }}">{{ $info->denomination}} </option>
                                                    @endforeach
                                                </optgroup>
                                        </select>
                                    </div>
                                </div>
                                   <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="">Justification</label>
                                            <input type="text"  class="form-control form-control-sm" wire:model="piece_justif" >
                                            @error('piece_justif')
                                                <small class="form-text text-danger">{{ $message }}</small>
                                            @enderror
                                        </div>
                                    </div>
                                   <div class="col-md-3">
                                       <div class="form-group">
                                           <label for="">Date <span style="color:red;">*</span></label>
                                           <input type="date"  class="form-control form-control-sm" wire:model="date_od" >
                                           @error('date_od')
                                                <small class="form-text text-danger">{{ $message }}</small>
                                           @enderror
                                       </div>
                                   </div>
                               </div>
                               
                                <div class="form-group row">
                                    <label class="col-sm-12 col-md-2 col-form-label">Objet <span style="color:red;">*</span></label>
                                    <div class="col-sm-12 col-md-10">
                                        <input type="text"  class="form-control form-control-sm" wire:model="libelle_od" />
                                        @error('libelle_od')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                               
                               <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group" >
                                        <label for="">Compte</label>
                                       
                                        <select 
                                                    class="form-control form-control-sm"
                                                    wire:model="compte_od"
                                                    id="Select_Compte_odd"
                                                            >
                                                        <option value="">select</option>
                                                    @if($ListCompte_od)
                                                        @foreach($ListCompte_od AS $compte )
                                                                <option value="{{ $compte->num_compte }}">{{ $compte->num_compte}} - {{ $compte->nom_compte }}</option>
                                                        @endforeach
                                                    @endif
                                                                
                                        </select>
                                        @error('compte_od')
                                                <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                    
                                </div>
                                   <div class="col-md-2">
                                       <div class="form-group">
                                           <label for="">Débit</label>
                                           <input type="text"  class="form-control form-control-sm" wire:model="debit_od" >
                                           @error('debit_od')
                                                <small class="form-text text-danger">{{ $message }}</small>
                                           @enderror
                                       </div>
                                   </div>
                                   <div class="col-md-2">
                                       <div class="form-group">
                                           <label for="">Crédit</label>
                                           <input type="text"  class="form-control form-control-sm" wire:model="credit_od" >
                                           @error('credit_od')
                                                    <small class="form-text text-danger">{{ $message }}</small>
                                           @enderror
                                       </div>
                                   </div>
                                   <div class="col-md-2 ">
                                    <div class="row " style="padding-top: 38px;">
                                        
                                        <span class="badge  badge-primary" wire:click="addItem_od" style="cursor:pointer;" title="Ajouter" >
                                            <i class="icon-copy dw dw-right-arrow-4"> </i>
                                        </span> 
                                        &nbsp;&nbsp;
                                        <span class="badge badge-primary" wire:click="annulerItem_od" style="cursor:pointer;" title="Annuler" ><i class="icon-copy dw dw-delete-1"></i></span>
                                    </div>
                                </div>
                               </div>
                               <div class="row">

                                <div class="col-md-8 offset-md-2">
                  
                                    @empty($MyArray_od)
                                     
                                    @else
                                        <table border="0" class="table-striped table-sm" style="font-size:0.8em; width:100%;">
                                        <thead>
                                            <tr>
                                                <td>compte</td>
                                                <td align="right">débit</td>
                                                <td align="right">crédit</td>
                                                <td></td>
                                            </tr>
                                        </thead>    
                                        <tbody>
                                            @foreach ( $MyArray_od as  $data )
                                            
                                                <tr>
                                                    <td>{{ $data['compte'] }}</td>
                                                    <td align="right">{{ get_format_montant($data['debit']) }}</td>
                                                    <td align="right">{{ get_format_montant($data['credit']) }}</td>
                                                    <td align="center" ><span class="text-danger"  wire:click="removeItem_achat({{ $data['compte'] }})"  style="cursor:pointer;"><i class="fa fa-times"></i></span></td>
                                                </tr>
                                            @endforeach

                                            
                                        </tbody>
                                        </table>
                                    @endempty

                                    @error('MyArray_od')
                                    <table border="0" class="table-striped table-sm" style="font-size:0.8em; width:100%;">
                                        <thead>
                                            <tr>
                                                <td>compte</td>
                                                <td >débit</td>
                                                <td >crédit</td>
                                               
                                            </tr>
                                        </thead>    
                                        <tbody>
                                            <tr>
                                                <td colspan="3" align="center"  class="text-danger" >
                                                        {{ $message }}
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    @enderror
                                </div>
    
                            </div>
                               <div class="row">
                                   <div class="col-md-4">
                                       <div class="form-group">
                                           <label for="">Total <span style="color:red;">*</span></label>
                                           <input type="text"  class="form-control form-control-sm" wire:model="total_ttc_od" readonly>
                                           @error('total_ttc_od')
                                                 <small class="form-text text-danger">{{ $message }}</small>
                                           @enderror
                                       </div>
                                   </div>
                                   <div class="col-md-4">
                                       <div class="form-group">
                                           <label for="">Devise <span style="color:red;">*</span></label>
                                           <select class="form-control form-control-sm" wire:model="devise_od">
                                              @foreach ( get_select_devise() as $devise )
                                                  <option value="{{ $devise->devise }}">{{ $devise->devise}} - {{ $devise->intitule }}</option>
                                              @endforeach
                                           </select>
                                           @error('devise_od')
                                                <small class="form-text text-danger">{{ $message }}</small>
                                           @enderror
                                       </div>
                                   </div>
                                   <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="">Pièce justificative</label> <small class="text-muted">(.pdf)</small>
                                        <input type="file"  class="form-control form-control-sm" wire:model="file_piece_justif" accept=".pdf">
                                        @error('file_piece_justif')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                                
                               </div>
                               <button type="button" wire:click="resetForm_od" class="btn btn-light">Annuler</button>
                                    
                               <button type="button" class="btn btn-primary" wire:click="saveOD" wire:loading.attr="disabled" style="width:15%;"> 
                                       
                                        <div class="spinner-border spinner-border-sm"  role="status" wire:loading wire:target="saveOD">
                                           <span class="visually-hidden"></span>
                                       </div>
                       
                                       <div wire:loading.remove wire:target="saveOD">
                                            Enregistrer 
                                       </div>
                                      
                               </button>

                               <button type="button" wire:click="$dispatch('showFactureEnCours')" class="btn btn-success">voir Od Tiers</button>
                      
                           </form>
                        </div>
                       
                      </div>
                 
                   </div>
                  
                    </div>
                 </div>
              
        </div>
    </div>

</div>


@push('scripts')
<script>

$(document).ready(function(){

    // partie Achat **************

    window.addEventListener('resetSelect_Tiers_achat', event => {
                     $("#Select_tiers_achat").select2().val(event.detail.data).trigger('change');
				})
    $('#Select_tiers_achat').select2({
        placeholder: {
                            id: "", // the value of the option
                            text: 'Select Fournisseur'
                    },
        allowClear: true
    });
    $('#Select_tiers_achat').on('change',function(e){
        var data = $(this).select2('val');
        @this.set('idFournisseur_achat',data);
    });


    window.addEventListener('resetSelect_Compte_achat', event => {
                     $("#Select_Compte_achat").select2().val(event.detail.data).trigger('change');
				})
    $('#Select_Compte_achat').select2({
        placeholder: {
                            id: "", // the value of the option
                            text: 'Select Compte'
                    },
        allowClear: true
    });
    $('#Select_Compte_achat').on('change',function(e){
        var data = $(this).select2('val');
        @this.set('compte_achat',data);
    });



 

    // partie Vente **************
    
    window.addEventListener('resetSelect_Tiers_vente', event => {
                     $("#Select_tiers_vente").select2().val(event.detail.data).trigger('change');
				})
    $('#Select_tiers_vente').select2({
        placeholder: {
                            id: "", // the value of the option
                            text: 'Select Client'
                    },
        allowClear: true
    });
    $('#Select_tiers_vente').on('change',function(e){
        var data = $(this).select2('val');
        @this.set('idFournisseur_vente',data);
    });


    window.addEventListener('resetSelect_Compte_vente', event => {
                     $("#Select_Compte_vente").select2().val(event.detail.data).trigger('change');
				})
    $('#Select_Compte_vente').select2({
        placeholder: {
                            id: "", // the value of the option
                            text: 'Select Compte'
                    },
        allowClear: true
    });
    $('#Select_Compte_vente').on('change',function(e){
        var data = $(this).select2('val');
        @this.set('compte_vente',data);
    });



// partie OD **************
    
window.addEventListener('resetSelect_Tiers_od', event => {
                     $("#Select_tiers_od").select2().val(event.detail.data).trigger('change');
				})
    $('#Select_tiers_od').select2({
        placeholder: {
                            id: "", // the value of the option
                            text: 'Select Tiers'
                    },
        allowClear: true
    });
    $('#Select_tiers_od').on('change',function(e){
        var data = $(this).select2('val');
        @this.set('idFournisseur_od',data);
    });


    window.addEventListener('resetSelect_Compte_od', event => {
                     $("#Select_Compte_od").select2().val(event.detail.data).trigger('change');
				})
    $('#Select_Compte_od').select2({
        placeholder: {
                            id: "", // the value of the option
                            text: 'Select Compte'
                    },
        allowClear: true
    });
    $('#Select_Compte_od').on('change',function(e){
        var data = $(this).select2('val');
        @this.set('compte_od',data);
    });





});


document.addEventListener("loadSelectCompteAchat", function (event) {
    
        //window.livewire.on('loadSelectCompteAchat',()=>{
            $('#Select_Compte_achat').select2();
        //}); 
    });


</script>
    
@endpush
