<div class="pd-20 card-box">
    <form>
        <div class="row mb-2">

            <div class="col-md-4">

                <label for="">Type demande <span style="color:red;">*</span></label>
                <select class="form-control form-control-sm" wire:model.live="typeDemande" tabindex="1">
                    <option value="file"> Fichier</option>
                    <option value="number"> Numéro</option>
                </select>
                @error('typeDemande')
                <small class="form-text text-danger">{{ $message }}</small>
                @enderror

            </div>

            <div class="col-md-8">
                <label for="">{{ $labelObject }} <span style="color:red;">*</span></label>

                <input type="text" class="form-control form-control-sm" wire:model="object_number" tabindex="2" maxlength="250" @if($typeDemande==="file" ) hidden @endif>

                <input type="file" class="form-control form-control-sm" wire:model="object_file" accept=".pdf" tabindex="2" @if($typeDemande==="number" ) hidden @endif multiple>

                @error('object_number')
                <small class="form-text text-danger">{{ $message }}</small>
                @enderror

                @error('object_file')
                <small class="form-text text-danger">{{ $message }}</small>
                @enderror
            </div>
        </div>

        <div class="row mb-2">

            <div class="col-md-8">

                <label for="">Infraction <span style="color:red;">*</span></label>
                <input type="text" class="form-control form-control-sm" wire:model="infraction" tabindex="3" maxlength="200">
                @error('infraction')
                <small class="form-text text-danger">{{ $message }}</small>
                @enderror

            </div>

            <div class="col-md-4">

                <label for="">KYC cible</label>
                <input type="text" class="form-control form-control-sm" wire:model="kyc" tabindex="4" maxlength="50">
                @error('kyc')
                <small class="form-text text-danger">{{ $message }}</small>
                @enderror

            </div>
        </div>

        <div class="row mb-3">
            <div class="col-md-12">
                <label for="">Description <span style="color:red;">*</span></label>
                <textarea class="form-control form-control" wire:model="content" tabindex="7" rows="20"></textarea>
                @error('content')
                <small class="form-text text-danger">{{ $message }}</small>
                @enderror
            </div>
        </div>


        <div class="row col-md-12" style="display: flex; gap: 10px;">
            <button type="button" wire:click="resetForm_demande" class="btn btn-light btn-sm">Annuler</button>

            <button type="button" class="btn btn-success btn-sm" wire:click="saveRens" wire:loading.attr="disabled" style="width:15%;">

                <div class="spinner-border spinner-border-sm" role="status" wire:loading wire:target="saveRens">
                    <span class="visually-hidden"></span>
                </div>

                <div wire:loading.remove wire:target="saveRens">
                    Envoyer
                </div>

            </button>



        </div>
    </form>


</div>