<div wire:ignore.self
class="modal fade bs-example-modal-lg"
id="ModalTiers"
tabindex="-1"
role="dialog"
data-backdrop="static"
aria-labelledby="Modal_tiers"
aria-hidden="true"
>
<div class="modal-dialog modal-lg modal-dialog-top">
    <div class="modal-content">
        <div class="modal-header">
            <h6 class="modal-title" id="Modal_tiers">
                @if($isNewTiers) Ajouter @else Mise à jour @endif Tiers
            </h6>
            <button
                type="button"
                class="close"
                wire:click.prevent="CloseModalTiers"
                data-dismiss="modal"
                aria-hidden="true"
            >
                ×
            </button>
        </div>
        <div class="modal-body">

            <div wire:ignore.self class="tab" >
                <ul class="nav nav-pills" role="tablist">
                    <li class="nav-item">
                        <a 
                            wire:click.prevent="selectTab_t('identification')"
                            class="nav-link  text-blue {{ $tab_t == 'identification' ? 'active' : '' }}"
                            data-toggle="tab"
                            href="#identification"
                            role="tab"
                            aria-selected="true"
                            >Identification</a
                        >
                    </li>
                    <li class="nav-item">
                        <a  
                            wire:click.prevent="selectTab_t('compte')"
                            class="nav-link text-blue {{ $tab_t == 'compte' ? 'active' : '' }}"
                            data-toggle="tab"
                            href="#compte_t"
                            role="tab"
                            aria-selected="false"
                            >Compte tiers</a
                        >
                    </li>
                    
                </ul>
                <div class="tab-content">
                    <div
                        class="tab-pane fade {{ $tab_t == 'identification' ? 'show active' : '' }}"
                        id="identification"
                        role="tabpanel"
                    >
                        <div class="pd-20">
                            <div class="row">
                                <div class="col-md-12">
                                    <form >
                                        <div class="row mb-2">
                                         
                                            <div class="col-md-4">
                                                    <label for="">Désignation </label>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="Désignation" wire:model="designation_t" maxlength="50" @if(!$isNewTiers) readonly  @endif >
                                                    @error('designation_t')
                                                        <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                               
                                            </div>
                                            <div class="col-md-4">
                                                    <label for="">Nom Complet </label>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="Nom Complet" wire:model="nom_complet_t" maxlength="150">
                                                    @error('nom_complet_t')
                                                        <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                                
                                            </div>
                                            <div class="col-md-4">
                                                <label for="">Type tiers </label>
                                                    <select class="form-control form-control-sm" wire:model="type_t" @if(!$isNewTiers) readonly  @endif>
                                                        <option value="">Select type tiers</option>
                                                        <option value="client">Client</option>
                                                        <option value="fourn">Fournisseur</option>
                                                    </select>
                                                    @error('type_t')
                                                            <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col-md-4">
                                                    <label for="">Type tiers </label>
                                                    <select class="form-control form-control-sm" wire:model="forme_t">
                                                        <option value="">Select forme tiers</option>
                                                        <option value="particulier">Particulier</option>
                                                        <option value="entreprise">Entreprise</option>
                                                    </select>
                                                    @error('forme_t')
                                                            <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                                
                                            </div>
                                          
                                            <div class="col-md-4 ">
                                                    <label for="">Téléphone </label>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="Téléphone (Optionnel)" wire:model="phone_t"   maxlength="15">
                                                    @error('phone_t')
                                                            <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                                
                                            </div>
                
                                            <div class="col-md-4">
                                                <label for="">Email </label>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="Email (Optionnel)" wire:model="email_t"  maxlength="50"  >
                                                    @error('email_t')
                                                            <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                                
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-4">
                                                     <label for="">Adresse </label>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="Adresse (Optionnel)" wire:model="adresse_t" maxlength="120"   >
                                                    @error('adresse_t')
                                                            <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                                
                                            </div>
                                          
                                            <div class="col-md-4">
                                                    <label for="">Ville </label>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="Ville (Optionnel)" wire:model="ville_t" maxlength="50"  >
                                                    @error('ville_t')
                                                            <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                                
                                            </div>
                
                                            <div class="col-md-4">
                                                    <label for="">Pays </label>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="Pays (Optionnel)" wire:model="pays_t" maxlength="50"  >
                                                    @error('pays_t')
                                                            <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                                
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div> 
                        </div>
                    </div>
                    <div class="tab-pane fade {{ $tab_t == 'compte' ? 'show active' : '' }}" 
                        id="compte_t" role="tabpanel">
                        <div class="pd-20">
                            <div class="row">
                                <div class="col-md-12">
                                    <form >
                                        <div class="row mb-2">
                                         
                                            <div class="col-md-3">
                                                    <label for="">Compte de tiers </label>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="Compte de tiers" wire:model="compte_tiers" maxlength="8"  >
                                                    @error('compte_tiers')
                                                        <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                               
                                            </div>
                                            <div class="col-md-6">
                                                    <label for="">Intitulé de compte </label>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="Intitulé de compte" wire:model="intitule_compte" maxlength="100">
                                                    @error('intitule_compte')
                                                        <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                                
                                            </div>
                                            <div class="col-md-3">
                                              
                                                <label for="">Compte Général </label>
                                                    <select class="form-control form-control-sm" wire:model="compte_general">
                                                        <option value="">Select Compte Général</option>
                                                       
                                                        @foreach(get_compte_Client_or_Fourn($type_t) as $info)
                                                             <option value="{{ $info->num_compte }}">{{ $info->num_compte }} {{ $info->nom_compte }}</option>
                                                        @endforeach
                                                    </select>
                                                    @error('compte_general')
                                                            <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                            </div>
                                        </div>
                                        <div class="row mb-2 pl-10 al_r">
                                                <button type="button" class="btn btn-outline-primary btn-sm" wire:click="addItem">ajouter compte de tiers</button>
                                        </div>
                                        <div  class="list_compte" >
                                           
                                            @empty($dicoCompteTiers)
                                         
                                            @else
                                                <table border="0" class="table-striped table-sm" style="font-size:0.8em; width:100%;">
                                                <thead>
                                                    <tr>
                                                       
                                                        <td  style="width: 8px;">Compte tiers</td>
                                                        <td  style="width: 74px;" >Intitulé de Compte</td>
                                                        <td style="width: 8px;">Compte Général</td>
                                                        <td style="width: 10px;"></td>
                                                    </tr>
                                                </thead>    
                                                <tbody>
                                                    @foreach ( $dicoCompteTiers as  $data )
                                                    
                                                        <tr>
                                                            
                                                            <td>{{ $data['compte_tiers'] }}</td>
                                                            <td>{{ $data['intitule_compte'] }}</td>
                                                            <td>{{ $data['compte_general'] }}</td>
                                                            <td align="center" >@if($data['is_new'] === 1)<span class="text-danger"  wire:click="removeItem({{ $data['compte_tiers'] }})"  style="cursor:pointer;"><i class="fa fa-times"></i></span>@endif</td>
                                                        </tr>
                                                    @endforeach
    
                                                    
                                                </tbody>
                                                </table>
                                            @endempty

                                            @error('dicoCompteTiers')
                                            <small class="form-text text-danger">
                                                {{ 'ajoutez un compte de tiers' }}
                                            </small>
                                            @enderror
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                   
                </div>
            </div>

        </div>
        <div class="modal-footer">
            <button
                type="button"
                wire:click.prevent="CloseModalTiers"
                class="btn btn-secondary btn-sm"
                data-dismiss="modal"
               
            >
                Fermer
            </button>

            @if($isNewTiers && $tab_t === 'compte' && !$activeBtnSave )
                <button type="button" wire:click="selectTab_t('identification')"  class="btn btn-primary btn-sm" style="width:15%;">
                    Précédent
                </button>

            @elseif($isNewTiers && $tab_t === 'identification' && !$activeBtnSave)
                <button type="button" wire:click="selectTab_t('compte')"  class="btn btn-primary btn-sm" style="width:15%;">
                    Suivant
                </button>

            @elseif($isNewTiers && $activeBtnSave)
                    <button type="button" class="btn btn-info btn-sm" wire:click="saveAndCloseModalTiers"
                    wire:loading.attr="disabled" style="width:25%;"
                    >
                        <div class="spinner-border spinner-border-sm"  role="status" wire:loading wire:target="saveAndCloseModalTiers">
                            <span class="visually-hidden"></span>
                        </div>
        
                        <div wire:loading.remove wire:target="saveAndCloseModalTiers">
                            Enregistrer & Fermer
                        </div>
                    </button>
                    <button type="button" class="btn btn-primary btn-sm" wire:click="saveTiers"
                    wire:loading.attr="disabled" style="width:15%;"
                    >
                        <div class="spinner-border spinner-border-sm"  role="status" wire:loading wire:target="saveTiers">
                            <span class="visually-hidden"></span>
                        </div>
        
                        <div wire:loading.remove wire:target="saveTiers">
                            Enregistrer
                        </div>
                    </button>
            @elseif(!$isNewTiers)
                <button type="button" class="btn btn-success btn-sm" wire:click="saveAndCloseModalTiers"
                wire:loading.attr="disabled" style="width:15%;"
                >
                    <div class="spinner-border spinner-border-sm"  role="status" wire:loading wire:target="saveAndCloseModalTiers">
                        <span class="visually-hidden"></span>
                    </div>

                    <div wire:loading.remove wire:target="saveAndCloseModalTiers">
                        Enregistrer
                    </div>
                </button>
            @else

            @endif

            
            
        </div>
    </div>
</div>
</div>

@push('scripts')

<script>
    	window.addEventListener('hideModalTiers', event => {
					$('#ModalTiers').modal('hide');
				})

        window.addEventListener('showModalTiers', event => {
					$('#ModalTiers').modal('show');
				})
  
</script>
    
@endpush

