<div wire:ignore.self
class="modal fade "
id="ModalFichierComptable"
tabindex="-1"
role="dialog"
data-backdrop="static"
aria-labelledby="Modal_FC"
aria-hidden="true"
>
<div class="modal-dialog  modal-dialog-top">
    <div class="modal-content">
        <div class="modal-header">
            <h6 class="modal-title" id="Modal_FC">
                
            </h6>
            <button
                type="button"
                class="close"
                wire:click.prevent="CloseModalFichierCompta"
                data-dismiss="modal"
                aria-hidden="true"
            >
                ×
            </button>
        </div>
        <div class="modal-body">
            <div class="">
                <p class="mb-1">
                    <small>Indiquez les dates de debut et fin de votre exercice comptable</small>
                </p>
            </div>
            <form >
                <div class="row mb-3">
                 
                    <div class="col-md-6">
                            <label for="">Date début </label>
                            <input type="date"  class="form-control form-control-sm"  wire:model="date_start"   >
                            @error('date_start')
                                <small class="form-text text-danger">{{ $message }}</small>
                            @enderror
                       
                    </div>
                    <div class="col-md-6">
                            <label for="">Date fin </label>
                            <input type="date"  class="form-control form-control-sm"  wire:model="date_end" >
                            @error('date_end')
                                <small class="form-text text-danger">{{ $message }}</small>
                            @enderror
                        
                    </div>
                </div>
                
                <div class="row mb-2">
                 
                    <div class="col-md-12">
                            <label for="">Longueur d'un compte </label>
                            <select wire:model="numberDigit" class="form-control form-control-sm" >
                                <option value="3">3 caractères</option>
                                <option value="4">4 caractères</option>
                                <option value="5">5 caractères</option>
                                <option value="6">6 caractères</option>
                                <option value="7">7 caractères</option>
                                <option value="8">8 caractères</option>
                            </select>
                            @error('numberDigit')
                                <small class="form-text text-danger">{{ $message }}</small>
                            @enderror
                       
                    </div>
                </div>

            </form>
            <div class="pull-left">
                <p class="mb-1"><span class="text-danger"><small> Important ! </span>
                Aucune modification ne sera autorisée après validation</small></p>
            </div>


        </div>
        <div class="modal-footer">
            <button
                type="button"
                wire:click.prevent="CloseModalFichierCompta"
                class="btn btn-secondary btn-sm"
                data-dismiss="modal"
               
            >
                Fermer
            </button>

        
                <button type="button" class="btn btn-primary btn-sm" wire:click="valider"
                wire:loading.attr="disabled" style="width:25%;"
                >
                    <div class="spinner-border spinner-border-sm"  role="status" wire:loading wire:target="valider">
                        <span class="visually-hidden"></span>
                    </div>

                    <div wire:loading.remove wire:target="valider">
                        Valider
                    </div>
                </button>
            
        </div>
    </div>
</div>
</div>

@push('scripts')

<script>
    	window.addEventListener('hideModalFichierComptable', event => {
					$('#ModalFichierComptable').modal('hide');
				})

        window.addEventListener('showModalFichierComptable', event => {
					$('#ModalFichierComptable').modal('show');
				})
  
</script>
    
@endpush

