<div wire:ignore.self
class="modal fade bs-example-modal-lg"
id="ModalFactureEnCours"
tabindex="-1"
role="dialog"
data-backdrop="static"
aria-labelledby="Modal_Facture"
aria-hidden="true"
>
<div class="modal-dialog modal-lg modal-dialog-top">
    <div class="modal-content">
        <div class="modal-header">
            <h6 class="modal-title" id="Modal_Facture">
                 Facture en cours
            </h6>
            <button
                type="button"
                class="close"
                wire:click.prevent="CloseModalFacture"
                data-dismiss="modal"
                aria-hidden="true"
            >
                ×
            </button>
        </div>
        <div class="modal-body">

            
            <div class="row"> 
                    <div class="col-md-2">
                        <div class="input-group custom ">
                            <select wire:model.live="ligne"  class="form-control form-control-sm" >
                                <option value="5">5</option>
                                <option value="10">10</option>
                                <option value="15">15</option>
                                <option value="20">20</option>
                                <option value="25">25</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-5 offset-md-5">
                        <div class="input-group custom ">
                                <input
                                    type="text"
                                    class="form-control form-control-sm"
                                    placeholder="recherche"
                                    id="_filter"
                                    wire:model.live="search"
                                />
                                <div class="input-group-append custom">
                                    <span class="input-group-text"
                                        ><i class="icon-copy dw dw-search"></i
                                    ></span>
                                </div>
                        </div>
                    </div>
                   
            </div>

            <div  class="table-responsive">
                <table id="table" class="table-striped mb-2" border="1" style="width:100%; font-size:0.8rem;">
                    
                    <thead>
                        <tr>
                           
                            <td  class="pl-1" style="width: 10%;"><b>Date</b></td>
                            <td  class="pl-1" style="width: 10%;"><b>Référence</b></td>
                          
                            <td  class="pl-1" style="width:44%;"><b>Libellé</b></td>
                        <!-- <td  class="pl-1" style="width: 10%;"><b>Désignation</b></td> -->
                            <td  align="right" style="width: 15%;"><b>Montant</b></td>
                            <td  align="right" style="width: 15%;"><b>Solde</b></td>
                            <td align="center" style="width: 6%;"><b>Devise</b></td>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($list_data as $data )

                            <tr>
                                <td >{{ get_format_date($data->date_facture) }}</td>
                                <td class="pl-1">{{ $data->ref_facture }}</td>
                              
                                <td class="pl-1" >{{ $data->intitule }}</td>
                              <!--  <td ></td> -->
                                <td align="right">{{ get_format_montant($data->montant) }}</td>
                                <td align="right">{{ get_format_montant($data->solde) }}</td> 
                                <td align="center">{{ $data->devise }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="9" align="center">Aucune donnée trouvée</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
                {{ $list_data->links() }}
            </div>
        </div>
        <div class="modal-footer">
            <button
                type="button"
                wire:click.prevent="CloseModalFacture"
                class="btn btn-secondary btn-sm"
                data-dismiss="modal"
               
            >
                Fermer
            </button>
        </div>
    </div>
</div>
</div>

@push('scripts')

<script>
    	window.addEventListener('hideModalFacture', event => {
					$('#ModalFactureEnCours').modal('hide');
				})

        window.addEventListener('showModalFacture', event => {
					$('#ModalFactureEnCours').modal('show');
				})
  
</script>
    
@endpush

