<div  wire:ignore.self
class="modal fade bs-example-modal-lg"
id="DetailTransactionModal"
tabindex="-1"
role="dialog"
aria-labelledby="TransactionModal"
aria-hidden="true"
>
<div class="modal-dialog modal-lg modal-dialog-top">
    <div class="modal-content">
        <div class="modal-header">
            <h6 class="modal-title" id="TransactionModal">
                Détails
            </h6>
            <button
                type="button"
                class="close"
                data-dismiss="modal"
                aria-hidden="true"
            >
                ×
            </button>
        </div>
        <div class="modal-body">
            <div class="table-responsive">
                <table id="table" class="table-striped mb-2" border="1" style="width:100%; font-size:0.8rem;">
                    <thead>
                        <tr>
                            <th colspan="5" class="pl-1" style="font-size:0.9rem; background-color:beige;">{{ $this->title_detail }}</th>
                        </tr>
                       
                        @if($list_data_detail)
                            <tr>
                                <td class="pl-1"><b>Compte</b></td>
                                <td class="pl-1"><b>Intitulé</b></td>
                                <td  align="center"><b>Débit</b></td>
                                <td align="center"><b> Crédit</b></td>
                                <td  align="center"><b>Devise</b></td>
                            </tr>
                        @endif
                    </thead>
                    <tbody>
                       
                        @forelse($list_data_detail as $data )
                            <tr>
                                <td class="pl-1">{{ $data->compte }}</td>
                                <td class="pl-1">{{ $data->intitule }}</td>
                                <td align="right">{{ get_format_montant($data->debit) }}</td>
                                <td align="right">{{ get_format_montant($data->credit) }}</td> 
                                <td align="center">{{ $data->devise }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" align="center">Aucune donnée trouvée</td>
                            </tr>
                        @endforelse
                        
                        
                    </tbody>
                </table>
            </div>
        </div>
<div class="modal-footer">
<button
type="button"
class="btn btn-secondary btn-sm"
data-dismiss="modal"
>
Fermer
</button>
</div>
</div>
</div>
</div>


@push('scripts')
<script>
    	window.addEventListener('hideModalDetailTransaction', event => {
					$('#DetailTransactionModal').modal('hide');
				})

        window.addEventListener('showModalDetailTransaction', event => {
					$('#DetailTransactionModal').modal('show');
				})
  
</script>
@endpush