<div>
    <form >
        <div class="row">
            <div class="col-md-3">
                <div class="form-group">
                    <label for="">Document</label>
                    <select class="form-control form-control-sm" wire:model.live="journal">
                        <option value="GL">Grand-Livre</option>
                        <option value="balance">Balance</option>
                        <option value="resultat">Résultat</option>
                        <option value="bilan">Bilan</option>
                        <option value="amortissement">Amortissement</option>
                        <option value="test">TEST Bilan</option>
                        
                    </select>
                    @error('journal')
                        <small class="form-text text-danger">{{ $message }}</small>
                    @enderror
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    @if($is_Amort)
                        <label for="">Amortir sur  <small>Mois</small></label>
                        <input type="text"  class="form-control form-control-sm" wire:model="amort_sur" maxlength="4" >
                        @error('amort_sur')
                              <small class="form-text text-danger">{{ $message }}</small>
                        @enderror
                    @else
                        <label for="">Du </label>
                        <input type="date"  class="form-control form-control-sm" wire:model="date_start" >
                        @error('date_start')
                          <small class="form-text text-danger">{{ $message }}</small>
                        @enderror
                    @endif
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    @if($is_Amort)
                        <label for="">à la date du </label>
                        <input type="date"  class="form-control form-control-sm" wire:model="amort_date"  >
                        @error('amort_date')
                             <small class="form-text text-danger">{{ $message }}</small>
                        @enderror
                    @else
                        <label for="">Au </label>
                        <input type="date"  class="form-control form-control-sm" wire:model="date_end"  >
                        @error('date_end')
                              <small class="form-text text-danger">{{ $message }}</small>
                        @enderror
                    @endif
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label for="">Devise</label>
                    <select class="form-control form-control-sm" wire:model="devise">
                        @foreach ( get_select_devise() as $dev )
                            <option value="{{ $dev->devise }}">{{ $dev->devise}} - {{ $dev->intitule }}</option>
                        @endforeach
                     </select>
                     @error('devise')
                          <small class="form-text text-danger">{{ $message }}</small>
                     @enderror
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-9">
                <div class="form-group">
                    @if($is_Amort)
                        <label for="">Affichage</label>
                        <select class="form-control form-control-sm" wire:model="affiche_amort" >
                                <option value="detail">Détails</option>
                                <option value="general">Général</option>
                        </select>
                        @error('affiche_amort')
                             <small class="form-text text-danger">{{ $message }}</small>
                        @enderror
                    @else
                        <label for="">Compte</label>
                        <select class="form-control form-control-sm" wire:model="compte"  {{ $disabled }}>
                                <option value="-1">-- select --</option>
                        @foreach ( get_select_compte_comptable() as $comp )
                                <option value="{{ $comp->num_compte }}">{{ $comp->num_compte}} - {{ $comp->nom_compte }}</option>
                        @endforeach
                        </select>
                        @error('compte')
                             <small class="form-text text-danger">{{ $message }}</small>
                        @enderror
                    @endif
                </div>
            </div>
            
         
            <div class="col-md-3">
                <div class="form-group pt-4">
                    <button type="button" wire:click="goEtatFinance" wire:loading.attr="disabled" class="btn btn-primary btn-sm" style="width:100%; height:3%;"> 
                        <div class="spinner-border spinner-border-sm"  role="status" wire:loading wire:target="goEtatFinance">
                            <span class="visually-hidden"></span>
                        </div>
                        <div wire:loading.remove wire:target="goEtatFinance"> Afficher</div>
                    </button>
                </div>
            </div>
        </div>
    </form>

    <hr>
    @if($data)

        @if($journal == "GL")

        @php
            $debit_somme  = 0 ;
            $credit_somme = 0 ;  
           
            if($infoCompte->type_compte === 'credit')
            {
                if($soldeInitial < 0){
                    $soldeDebit = $soldeInitial ;
                    $soldeCredit = null ;
                }else{
                    $soldeDebit = null ;
                    $soldeCredit = $soldeInitial ;
                }
            }else{

                if($soldeInitial < 0){
                    $soldeDebit = null ;
                    $soldeCredit = $soldeInitial ;
                }else{
                    $soldeDebit = $soldeInitial ;
                    $soldeCredit = null ;
                }
            }

            if($soldeDebit){
                 $debit_somme += $soldeDebit ;
            }

            if($soldeCredit){
                 $credit_somme += $soldeCredit ;
            }

        @endphp

        <table style="width: 100%;" class="mb-3">
            <tr>
                <td colspan="1" align="left"><b>GRAND LIVRE</b></td>
                <td align="right">
                    <button type="button" wire:click="DownloadGrandLivrePdf()" wire:loading.attr="disabled" class="btn btn-info btn-sm" style="width:50%; height:3%;"> 
                        <div class="spinner-border spinner-border-sm"  role="status" wire:loading wire:target="DownloadGrandLivrePdf">
                            <span class="visually-hidden"></span>
                        </div>
                        <div wire:loading.remove wire:target="DownloadGrandLivrePdf"><i class="fa fa-file-pdf-o"></i>  Télécharger</div>
                    </button>
                    
                </td>
            </tr>
            <tr>
                <td colspan="2">Compte : {{ $compte }}  {{ $infoCompte->nom_compte }}</td>
            </tr>
            <tr>
                <td>Période : {{ get_format_date($date_start,'L') }} au {{ get_format_date($date_end,'L') }}</td>
                <td>Devise : {{ $devise }} - {{ get_libelle_devise($devise) }}</td>
            </tr>
        </table>
        

        <table class="" border="1" style="width: 100%;  font-size:13px;">
            <tr>
                <td class="pl-1" style="width: 10%;">Date</td>
                <td class="pl-1">Libellé</td>
                <td class="pl-1" style="width: 15%;">Débit</td>
                <td class="pl-1" style="width: 15%;">Crédit</td>
            </tr>
            <tr>
                <td></td>
                <td colspan="1" align="right" class="pr-1"><b>Solde initial :</b></td>
                <td align="right" class="pr-1"><b>{{ get_format_montant($soldeDebit) }}</b></td>
                <td align="right" class="pr-1"><b>{{ get_format_montant($soldeCredit) }}</b></td>
            </tr>
            @foreach($data AS $info)
                <tr>
                    <td class="pl-1">{{ get_format_date($info->date_valeur) }}</td>
                    <td class="pl-1">{{ $info->intitule }}</td>
                    <td class="pr-1" align="right">{{ get_format_montant($info->debit) }}</td>
                    <td class="pr-1" align="right">{{ get_format_montant($info->credit) }}</td>
                </tr>
                @php
                    $debit_somme += $info->debit ;
                    $credit_somme += $info->credit ;   
               @endphp
            @endforeach

                @php
                     if($infoCompte->type_compte === 'credit')
                      {
                        /*** solde = totCredit - TotDebit  */
                           $solde = $credit_somme - $debit_somme ;
                      }else{
                        /** solde = totDébit - TotCredit */
                            $solde = $debit_somme - $credit_somme ;
                      }
                @endphp
            <tr>
                <td colspan="2" align="right" class="pr-1">
                    <b>Totaux :</b>
                    </br>
                    <b>Solde :</b>
                </td>
                <td align="right" valign="top" class="pr-1">
                    <b>{{ get_format_montant($debit_somme) }}</b>
                    </br>
                    <b>
                    @if($debit_somme < $credit_somme)
                           {{ get_format_montant(abs($solde)) }} 
                    @endif
                    </b>
                </td>
                <td align="right" valign="top" class="pr-1">
                    <b>{{ get_format_montant($credit_somme) }}</b>
                    </br>
                    <b> 
                    @if($credit_somme < $debit_somme)
                        {{ get_format_montant(abs($solde)) }} 
                    @endif
                </b>
                </td>
            </tr>
        </table>
        @endif

        @if($journal == "balance")

        @php
            // substr('abcde', 0,1);
            //  $type = substr( $info->compte, 0,1);
            $somme_init_debit = 0 ;
            $somme_init_credit= 0 ;
            $somme_variation_debit = 0 ;
            $somme_variation_credit= 0 ;
            $somme_solde_debit = 0 ;
            $somme_solde_credit= 0 ;
        @endphp

        <table style="width: 100%;" class="mb-3">
            <tr>
                <td colspan="1" align="left"><b>BALANCE DES COMPTES</b></td>
                <td align="right">
                    <button type="button" wire:click="DownloadBalancePdf()" wire:loading.attr="disabled" class="btn btn-info btn-sm" style="width:50%; height:3%;"> 
                        <div class="spinner-border spinner-border-sm"  role="status" wire:loading wire:target="DownloadBalancePdf">
                            <span class="visually-hidden"></span>
                        </div>
                        <div wire:loading.remove wire:target="DownloadBalancePdf"><i class="fa fa-file-pdf-o"></i>  Télécharger</div>
                    </button>
                    
                </td>
            </tr>
            <tr>
                <td>Période : {{ get_format_date($date_start,'L') }} au {{ get_format_date($date_end,'L') }} </td>
                <td>Devise : {{ $devise }} - {{ get_libelle_devise($devise) }}</td>
            </tr>
        </table>

        <table class="" border="1" style="width: 100%; font-size:13px;">
            <tr>
                <td class="pl-1" style="width: 9%;"><b>COMPTE</b></td>
                <td class="pl-1" align="center"><b>INTITULE DE COMPTE</b></td>
                <td class="pl-1" style="width: 18%;" colspan="2" align="center"><b>SOLDE INITIAL</b></td>
                <td class="pl-1" style="width: 18%;" colspan="2" align="center"><b>VARIATIONS</b></td>
                <td class="pl-1" style="width: 18%;" colspan="2" align="center"><b>SOLDE</b></td>
            </tr>
            <tr>
                <td></td>
                <td></td>
                <td  class="pl-1" align="center">débit</td>
                <td  class="pl-1" align="center">crédit</td>
                <td  class="pl-1" align="center">débit</td>
                <td  class="pl-1" align="center">crédit</td>
                <td  class="pl-1" align="center">débit</td>
                <td  class="pl-1" align="center">crédit</td>
            </tr>
            @foreach($dico AS $info)
                   
                    @php
                        $bgColor = "";
                        $textColor = "";

                        if($info['compte'] <> '')
                        { 
                            $somme_init_debit += $info['soldeInitial']['debit_true'] ;
                            $somme_init_credit += $info['soldeInitial']['credit_true'] ;
                            $somme_variation_debit += $info['variations']['debit_true'] ;
                            $somme_variation_credit += $info['variations']['credit_true'] ;
                            $somme_solde_debit += $info['solde']['debit_true'] ;
                            $somme_solde_credit += $info['solde']['credit_true'] ;
                        }else{
                            $bgColor = "#e3eae9";
                            $textColor = "";
                        }
                    @endphp
                     <tr style="background-color: {{ $bgColor }};color: {{ $textColor }};">
                        <td class="pl-1">{{ $info['compte'] }}</td>
                        <td class="pl-1">{{ $info['intitule'] }}</td>
                        <td class="pr-1" align="right">{{ get_format_montant($info['soldeInitial']['debit']) }}</td>
                        <td class="pr-1" align="right">{{ get_format_montant($info['soldeInitial']['credit']) }}</td>
                        <td class="pr-1" align="right">{{ get_format_montant($info['variations']['debit']) }}</td>
                        <td class="pr-1" align="right">{{ get_format_montant($info['variations']['credit']) }}</td>
                        <td class="pr-1" align="right">{{ get_format_montant($info['solde']['debit']) }}</td>
                        <td class="pr-1" align="right">{{ get_format_montant($info['solde']['credit']) }}</td>
                    </tr>
            @endforeach
            <tr style="background-color: black;color: white;">
                        
                        <td class="pl-1" colspan="2" align="center">TOTAL GENERAL</td>
                        <td class="pr-1" align="right">{{ get_format_montant($somme_init_debit) }}</td>
                        <td class="pr-1" align="right">{{ get_format_montant($somme_init_credit) }}</td>
                        <td class="pr-1" align="right">{{ get_format_montant($somme_variation_debit) }}</td>
                        <td class="pr-1" align="right">{{ get_format_montant($somme_variation_credit) }}</td>
                        <td class="pr-1" align="right">{{ get_format_montant($somme_solde_debit) }}</td>
                        <td class="pr-1" align="right">{{ get_format_montant($somme_solde_credit) }}</td>
            </tr>
        </table>

        @endif

        @if($journal == "resultat")

        <table style="width: 80%;" class="mb-3">
            <tr>
                <td colspan="2" align="left"><b>COMPTE DE RESULTAT</b></td>
            </tr>
            <tr>
                <td>Période : </td>
                <td>Devise : {{ $devise }} - {{ get_libelle_devise($devise) }}</td>
            </tr>
        </table>


        <table class="" border="1" style="width: 100%; font-size:13px;">
            <tr>
                <td class="pl-1" style="width: 5%;" rowspan="2" align="center"><b>REF.</b></td>
                <td class="pl-1"  style="width: 45%;" rowspan="2" align="center"><b>LIBELLES</b></td>
                <td class="pl-1"  style="width: 5%;" rowspan="2" align="center"></td>
                <td class="pl-1"  rowspan="2" align="center"><b>NOTE</b></td>
                <td class="pl-1" style="width: 20%;"  align="center"><b>EXERCICE {{ getExercice() }} </b></td>
                <td class="pl-1" style="width: 20%;" align="center"><b>EXERCICE {{ getExercice_n_1() }}</b></td>
            </tr>
            <tr>
                <td class="pl-1" align="center" ><b>Net</b></td>
                <td class="pl-1" align="center"><b>Net</b></td>
            </tr>

            @foreach($dico AS $info)

                <tr
                >
                    <td class="pl-1" align="center" >{{ get_text_MAJ($info['poste']) }}</td>
                    <td class="pl-1" style="background-color: {{ $info['bgColor'] }};color: {{ $info['textColor'] }}">{{ $info['intitule'] }}</td>
                    <td class="pr-1" align="center" style="background-color: {{ $info['bgColor'] }};color: {{ $info['textColor'] }}">{{ $info['operation'] }}</td>
                    <td class="pr-1" align="center" style="background-color: {{ $info['bgColor'] }};color: {{ $info['textColor'] }}">{{ $info['note'] }}</td>
                    <td class="pr-1" align="right" style="background-color: {{ $info['bgColor'] }};color: {{ $info['textColor'] }}">{{ get_format_montant($info['exercice_n']) }}</td>
                    <td class="pr-1" align="right" style="background-color: {{ $info['bgColor'] }};color: {{ $info['textColor'] }}">{{ get_format_montant($info['exercice_n1']) }}</td>
                </tr>
            @endforeach


        </table>
        @endif

        @if($journal == "bilan")

            <table style="width: 100%;" class="mb-3">
                <tr>
                    <td  align="left"><b>BILAN</b></td>
                    <td align="right">
                        <button type="button" wire:click="DownloadBilanPdf()" wire:loading.attr="disabled" class="btn btn-info btn-sm" style="width:25%; height:3%;"> 
                            <div class="spinner-border spinner-border-sm"  role="status" wire:loading wire:target="DownloadBilanPdf">
                                <span class="visually-hidden"></span>
                            </div>
                            <div wire:loading.remove wire:target="DownloadBilanPdf"><i class="fa fa-file-pdf-o"></i>  Télécharger</div>
                        </button>
                        
                    </td>
                </tr>
                <tr>
                    <td>Période : </td>
                    <td>Devise : {{ $devise }} - {{ get_libelle_devise($devise) }}</td>
                </tr>
            </table>

            <table class="" border="1" style="width: 100%; font-size:13px;">
                <tr>
                    <td class="pl-1" style="width: 5%;" rowspan="2" align="center"><b>REF.</b></td>
                    <td class="pl-1"  rowspan="2" align="center"><b>ACTIF</b></td>
                    <td class="pl-1"  rowspan="2"  style="width: 5%;" align="center"><b>NOTE</b></td>
                    <td class="pl-1" style="width: 42%;"  align="center" colspan="3"><b>EXERCICE {{ getExercice() }}</b></td>
                    <td class="pl-1" style="width: 14%;" align="center"><b>EX. {{ getExercice_n_1() }}</b></td>
                </tr>
                <tr>
                    <td class="pl-1" style="width: 14%;" align="center" ><b>Brut</b></td>
                    <td class="pl-1" style="width: 14%;" align="center" ><b>Amort.</b></td>
                    <td class="pl-1" align="center" ><b>Net</b></td>
                    <td class="pl-1" align="center"><b>Net</b></td>
                </tr>
    
                @foreach($dico['actif'] AS $info)

                <tr>
                    <td class="pl-1" align="center">{{ get_text_MAJ($info['poste']) }}</td>
                    <td class="pl-1" style="background-color: {{ $info['bgColor'] }};color: {{ $info['textColor'] }}">{{ $info['intitule'] }}</td>
                    <td class="pr-1" align="center" style="background-color: {{ $info['bgColor'] }};color: {{ $info['textColor'] }}">{{ $info['note'] }}</td>
                    <td class="pr-1" align="right" style="background-color: {{ $info['bgColor'] }};color: {{ $info['textColor'] }}">{{ get_format_montant($info['exercice_n']['brut']) }}</td>
                    <td class="pr-1" align="right" style="background-color: {{ $info['bgColor'] }};color: {{ $info['textColor'] }}">{{ get_format_montant($info['exercice_n']['amort']) }}</td>
                    <td class="pr-1" align="right" style="background-color: {{ $info['bgColor'] }};color: {{ $info['textColor'] }}">{{ get_format_montant($info['exercice_n']['net']) }}</td>
                    <td class="pr-1" align="right" style="background-color: {{ $info['bgColor'] }};color: {{ $info['textColor'] }}">{{ get_format_montant($info['exercice_n1']) }}</td>
                </tr>
                @endforeach
            </table>

            <br><br>

            <table class="" border="1" style="width: 100%; font-size:13px;">
                <tr>
                    <td class="pl-1" style="width: 5%;" rowspan="2" align="center"><b>REF.</b></td>
                    <td class="pl-1"  style="width: 45%;" rowspan="2" align="center"><b>PASSIF</b></td>
                    <td class="pl-1"  rowspan="2" align="center"><b>NOTE</b></td>
                    <td class="pl-1" style="width: 20%;"  align="center"><b>EXERCICE {{ getExercice() }}</b></td>
                    <td class="pl-1" style="width: 20%;" align="center"><b>EX. {{ getExercice_n_1() }}</b></td>
                </tr>
                <tr>
                    <td class="pl-1" align="center" ><b>Net</b></td>
                    <td class="pl-1" align="center"><b>Net</b></td>
                </tr>
    
                @foreach($dico['passif'] AS $info)
                <tr>
                    <td class="pl-1" align="center">{{ get_text_MAJ($info['poste']) }}</td>
                    <td class="pl-1" style="background-color: {{ $info['bgColor'] }};color: {{ $info['textColor'] }}">{{ $info['intitule'] }}</td>
                    <td class="pr-1" align="center" style="background-color: {{ $info['bgColor'] }};color: {{ $info['textColor'] }}">{{ $info['note'] }}</td>
                    <td class="pr-1" align="right" style="background-color: {{ $info['bgColor'] }};color: {{ $info['textColor'] }}">{{ get_format_montant($info['exercice_n']) }}</td>
                    <td class="pr-1" align="right" style="background-color: {{ $info['bgColor'] }};color: {{ $info['textColor'] }}">{{ get_format_montant($info['exercice_n1']) }}</td>
                </tr>
                @endforeach
            </table>
        @endif

        @if($journal == "amortissement")
            @php   
            //$dico_immo = array();
            $grand_t_montant = 0;
            $grand_t_ant = 0;
            $grand_t_amort = 0;
            $grand_t_val_res = 0;
            $libTitle = ($affiche_amort == "detail")? 'détaillé' : 'général';
            $libColonne = ($affiche_amort == "detail")? 'date' : 'compte';

            @endphp

            <table style="width: 100%;" class="mb-3">
                <tr>
                    <td colspan="1" align="left"><b>Tableau {{ $libTitle }} des amortissements
                    </b></td>
                    <td align="right">
                        <button type="button" wire:click="DownloadTabImmoPdf()" wire:loading.attr="disabled" class="btn btn-info btn-sm" style="width:50%; height:3%;"> 
                            <div class="spinner-border spinner-border-sm"  role="status" wire:loading wire:target="DownloadTabImmoPdf">
                                <span class="visually-hidden"></span>
                            </div>
                            <div wire:loading.remove wire:target="DownloadTabImmoPdf"><i class="fa fa-file-pdf-o"></i>  Télécharger</div>
                        </button>
                        
                    </td>
                </tr>
                <tr>
                    <td>Amortissement limites sur {{ $amort_sur }} mois à la date du {{ get_format_date($amort_date,'L') }} </td>
                    <td>Devise : {{ $devise }} - {{ get_libelle_devise($devise) }}</td>
                </tr>
            </table>

            <table class="" border="1" style="width: 100%; font-size:13px;">
                <tr style="background-color: black; color:white;" >
                    <td class="pl-1" style="width: 10%;"  >{{ $libColonne }}</td>
                    <td class="pl-1" style="width: %;"  >libellé</td>
                    <td class="pr-1" style="width: 12%;" align="center" >montant</td>

                    @if($affiche_amort == "detail")
                        <td class="pl-1" style="width: 2%;" align="center">D</td>
                    @endif

                    <td class="pr-1" style="width: 12%;" align="center" >ant</td>
                    <td class="pr-1" style="width: 12%;" align="center">amort</td>
                    <td class="pr-1" style="width: 12%;" align="center">val.rés</td>
                </tr>
                @foreach($dico_immo AS $info)

                @if($affiche_amort == "detail")
                    <tr style="background-color:#e3eae9;font-size:12px;">
                        <td class="pl-1"  ><b>{{ $info['num_compte'] }}</b></td>
                        <td class="pl-1" ><b>{{ $info['nom_compte'] }}</b></td>
                        <td class="pr-1" align="right" ><b>{{ get_format_montant($info['t_montant']) }}</b></td>
                        <td  align="center"></td>
                        <td class="pr-1" align="right" ><b>{{ get_format_montant($info['t_ant']) }}</b></td>
                        <td class="pr-1" align="right"><b>{{ get_format_montant($info['t_amort']) }}</b></td>
                        <td class="pr-1" align="right"><b>{{ get_format_montant($info['t_val_res']) }}</b></td>
                    </tr>
                    
                    @foreach($info['detail'] AS $immo)
                        <tr style = "font-size:12px;">
                            <td class="pl-1"  >{{ get_format_date($immo['date_acq']) }}</td>
                            <td class="pl-1"  >{{ $immo['libelle'] }}</td>
                            <td class="pr-1" align="right" >{{ get_format_montant($immo['montant'] ) }}</td>
                            <td  align="center">{{ $immo['periode']  }}</td>
                            <td class="pr-1" align="right" >{{ get_format_montant($immo['ant']) }}</td>
                            <td class="pr-1" align="right">{{ get_format_montant($immo['amort']) }}</td>
                            <td class="pr-1" align="right">{{ get_format_montant($immo['val_res']) }}</td>
                        </tr>
                    @endforeach
                @else
                    <tr style="font-size:12px;">
                        <td class="pl-1"  >{{ $info['num_compte'] }}</td>
                        <td class="pl-1" >{{ $info['nom_compte'] }}</td>
                        <td class="pr-1" align="right" >{{ get_format_montant($info['t_montant']) }}</td>
                        <td class="pr-1" align="right" >{{ get_format_montant($info['t_ant']) }}</td>
                        <td class="pr-1" align="right">{{ get_format_montant($info['t_amort']) }}</td>
                        <td class="pr-1" align="right">{{ get_format_montant($info['t_val_res']) }}</td>
                    </tr>
                @endif

                    @php
                    $grand_t_montant += $info['t_montant'];
                    $grand_t_ant += $info['t_ant'];
                    $grand_t_amort += $info['t_amort'];
                    $grand_t_val_res += $info['t_val_res'];
                    @endphp
                @endforeach
                <tr style="">
                    <td class="pl-1" colspan="2" align="center" ><b>TOTAL GENERAL</b></td>
                    <td class="pr-1" align="right" ><b>{{ get_format_montant($grand_t_montant) }}</b></td>
                    
                    @if($affiche_amort == "detail")
                        <td  align="center"></td>
                    @endif

                    <td class="pr-1" align="right" ><b>{{ get_format_montant( $grand_t_ant) }}</b></td>
                    <td class="pr-1" align="right"><b>{{ get_format_montant($grand_t_amort) }}</b></td>
                    <td class="pr-1" align="right"><b>{{ get_format_montant($grand_t_val_res) }}</b></td>
                </tr>
            </table>

        @endif

        @if($journal == "test")
            
        @endif

    @endif
</div>