<div class="pd-20 card-box">
    <form>
        <div class="row mb-2">

            <div class="col-md-3">

                <label for="">Site <span style="color:red;">*</span></label>
                <select class="form-control form-control-sm" wire:model="site" tabindex="1">
                    @foreach ( $list_site as $data )
                    <option value="{{ $data->id }}">{{ $data->nom }} </option>
                    @endforeach
                </select>
                @error('site')
                <small class="form-text text-danger">{{ $message }}</small>
                @enderror

            </div>

            <div class="col-md-6">
                <label for="">Object<span style="color:red;">*</span></label>
                <input type="text" class="form-control form-control-sm" wire:model="object" tabindex="2" maxlength="250">
                @error('object')
                <small class="form-text text-danger">{{ $message }}</small>
                @enderror
            </div>

            <div class="col-md-3">
                <label for="">fichier</label>
                <input type="file" class="form-control form-control-sm" wire:model="lettre" tabindex="2" accept=".pdf" multiple>
                @error('lettre.*')
                <small class="form-text text-danger">{{ $message }}</small>
                @enderror
            </div>
        </div>

        <div class="row mb-2">

            <div class="col-md-3">

                <label for="">Date début<span style="color:red;">*</span></label>
                <input type="date" class="form-control form-control-sm" wire:model="date_start" tabindex="3" maxlength="8">
                @error('date_start')
                <small class="form-text text-danger">{{ $message }}</small>
                @enderror

            </div>

            <div class="col-md-3">

                <label for="">Heure début<span style="color:red;">*</span></label>
                <input type="time" class="form-control form-control-sm" wire:model="heure_start" tabindex="4" maxlength="5">
                @error('heure_start')
                <small class="form-text text-danger">{{ $message }}</small>
                @enderror

            </div>

            <div class="col-md-3">

                <label for="">Date fin<span style="color:red;">*</span></label>
                <input type="date" class="form-control form-control-sm" wire:model="date_end" tabindex="5" maxlength="8">
                @error('date_end')
                <small class="form-text text-danger">{{ $message }}</small>
                @enderror

            </div>

            <div class="col-md-3">

                <label for="">Heure fin<span style="color:red;">*</span></label>
                <input type="time" class="form-control form-control-sm" wire:model="heure_end" tabindex="6" maxlength="5">
                @error('heure_end')
                <small class="form-text text-danger">{{ $message }}</small>
                @enderror

            </div>
        </div>

        <div class="row mb-3">
            <div class="col-md-12">
                <label for="">Description<span style="color:red;">*</span></label>
                <textarea class="form-control form-control" wire:model="content" tabindex="7" rows="20"></textarea>
                @error('content')
                <small class="form-text text-danger">{{ $message }}</small>
                @enderror
            </div>
        </div>


        <div class="row col-md-12" style="display: flex; gap: 10px;">
            <button type="button" wire:click="resetForm_demande" class="btn btn-light btn-sm">Annuler</button>

            <button type="button" class="btn btn-success btn-sm" wire:click="saveDemande" wire:loading.attr="disabled" style="width:15%;">

                <div class="spinner-border spinner-border-sm" role="status" wire:loading wire:target="saveDemande">
                    <span class="visually-hidden"></span>
                </div>

                <div wire:loading.remove wire:target="saveDemande">
                    Envoyer
                </div>

            </button>

            <button type="button" class="btn btn-light btn-sm" wire:click="showModal">
                <small>+ Intervenants ({{ $nbrIntervenant }})</small>
            </button>
            @error('MyArray_intervenant')
            <div class="pt-1">
                <small class="form-text text-danger">{{ $message }}</small>
            </div>
            @enderror

        </div>
    </form>



    <div wire:ignore.self
        class="modal fade "
        id="ModalIntervenant"
        tabindex="-1"
        role="dialog"
        data-backdrop="static"
        aria-labelledby="Modal_FC"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-top">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title" id="Modal_FC">
                        Intervenants
                    </h6>
                    <button
                        type="button"
                        class="close"
                        wire:click.prevent="closeModal"
                        data-dismiss="modal"
                        aria-hidden="true">
                        ×
                    </button>
                </div>
                <div class="modal-body">

                    @empty($MyArray_intervenant)

                    @else
                    <table border="0" class="table-striped table-sm" style="font-size:0.8em; width:100%;">
                        <thead>
                            <tr style="font-weight: 600;">
                                <td>#</td>
                                <td>Noms</td>
                                <td>Téléphone</td>
                                <td>Email</td>
                                <td></td>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                            $n = 0 ;
                            @endphp
                            @foreach ($MyArray_intervenant as $data )

                            @php
                            $n++ ;
                            @endphp

                            <tr>
                                <td>{{ $n }}</td>
                                <td>{{ $data['noms'] }}</td>
                                <td>{{ $data['phone'] }}</td>
                                <td>{{ $data['email'] }}</td>
                                <td align="center"><span class="text-danger" wire:click="removeItem_intervenant({{ $data['noms'] }})" style="cursor:pointer;"><i class="fa fa-times"></i></span></td>
                            </tr>

                            @endforeach
                        </tbody>
                    </table>
                    @endempty

                </div>
                <div class="modal-footer">

                    <form>
                        <div class="row">

                            <div class="col-md-4">

                                <input type="text" class="form-control form-control-sm" wire:model="key_noms" maxlength="50" placeholder="Noms">
                                @error('key_noms')
                                <small class="form-text text-danger">{{ $message }}</small>
                                @enderror

                            </div>
                            <div class="col-md-3">

                                <input type="text" class="form-control form-control-sm" wire:model="key_phone" maxlength="12" placeholder="Téléphone">
                                @error('key_phone')
                                <small class="form-text text-danger">{{ $message }}</small>
                                @enderror

                            </div>
                            <div class="col-md-4">

                                <input type="email" class="form-control form-control-sm" wire:model="key_email" placeholder="Email">
                                @error('key_email')
                                <small class="form-text text-danger">{{ $message }}</small>
                                @enderror

                            </div>

                            <div class="col-md-1 ">
                                <div class="row " style="padding-top: 5px;">

                                    <span class="badge  badge-primary" wire:click="addItem_intervenant" style="cursor:pointer;" title="Ajouter">

                                        <i class="icon-copy fa fa-check"></i>
                                    </span>

                                </div>
                            </div>

                        </div>


                    </form>

                </div>
            </div>
        </div>
    </div>






</div>


@push('scripts')

<script>
    window.addEventListener('hideModalIntervenant', event => {
        $('#ModalIntervenant').modal('hide');
    })

    window.addEventListener('showModalIntervenant', event => {
        $('#ModalIntervenant').modal('show');
    })
</script>

@endpush