<div wire:ignore.self
class="modal fade bs-example-modal-lg"
id="ModalCustomer"
tabindex="-1"
role="dialog"
data-backdrop="static"
aria-labelledby="Modal_customer"
aria-hidden="true"
>
<div class="modal-dialog modal-lg modal-dialog-top">
    <div class="modal-content">
        <div class="modal-header">
            <h6 class="modal-title" id="Modal_customer">
                @if($isNewCustomer) Ajouter @else Mise à jour @endif Entreprise
            </h6>
            <button
                type="button"
                class="close"
                wire:click.prevent="CloseModalCustomer"
                data-dismiss="modal"
                aria-hidden="true"
            >
                ×
            </button>
        </div>
        <div class="modal-body">

            <div wire:ignore.self class="tab" >
                <ul class="nav nav-pills" role="tablist">
                    <li class="nav-item">
                        <a 
                            wire:click.prevent="selectTab_t('society')"
                            class="nav-link  text-blue {{ $tab_t == 'society' ? 'active' : '' }}"
                            data-toggle="tab"
                            href="#society"
                            role="tab"
                            aria-selected="true"
                            >Info Entreprise</a
                        >
                    </li>
                    <li class="nav-item">
                        <a  
                            wire:click.prevent="selectTab_t('user')"
                            class="nav-link text-blue {{ $tab_t == 'user' ? 'active' : '' }}"
                            data-toggle="tab"
                            href="#user_t"
                            role="tab"
                            aria-selected="false"
                            >Personne à contacter</a
                        >
                    </li>
                    
                </ul>
                <div class="tab-content">
                    <div
                        class="tab-pane fade {{ $tab_t == 'society' ? 'show active' : '' }}"
                        id="society"
                        role="tabpanel"
                    >
                        <div class="pd-20">
                            <div class="row">
                                <div class="col-md-12">
                                    <form >
                                        <div class="row mb-2">
                                         
                                            <div class="col-md-4">
                                                    <label for="">Raison Sociale <span style="color:red;">*</span></label>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="Raison sociale" wire:model="raison_sociale" maxlength="50" @if(!$isNewCustomer) readonly  @endif >
                                                    @error('raison_sociale')
                                                        <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                               
                                            </div>
                                            <div class="col-md-4">
                                                    <label for="">Forme Sociale <span style="color:red;">*</span></label>
                                                    <select class="form-control form-control-sm" wire:model="forme_sociale" @if(!$isNewCustomer) readonly  @endif>
                                                        <option value="">-- Select --</option>
                                                        @foreach(get_select_formeSociale() as $data)
                                                        <option value="{{ $data->id }}">{{ $data->name }}</option>
                                                        @endforeach
                                                    </select>
                                                     @error('forme_sociale')
                                                        <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                                
                                            </div>
                                            <div class="col-md-4">
                                                <label for="">Activité Principale </label>
                                                <input type="text"  class="form-control form-control-sm" placeholder="Activité Principale" wire:model="activite_principale" maxlength="150">
                                                    @error('activite_principale')
                                                            <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col-md-4">
                                                    <label for="">Sigle</label>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="Sigle" wire:model="sigle" maxlength="50">
                                                
                                                    @error('sigle')
                                                            <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                                
                                            </div>
                                          
                                            <div class="col-md-4 ">
                                                    <label for="">Téléphone </label>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="Téléphone (Optionnel)" wire:model="phone_"   maxlength="15">
                                                    @error('phone_')
                                                            <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                                
                                            </div>
                
                                            <div class="col-md-4">
                                                <label for="">Email </label>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="Email (Optionnel)" wire:model="email_"  maxlength="50"  >
                                                    @error('email_')
                                                            <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                                
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col-md-4">
                                                     <label for="">Adresse </label>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="Adresse (Optionnel)" wire:model="adresse_" maxlength="120"   >
                                                    @error('adresse_')
                                                            <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                                
                                            </div>
                                          
                                            <div class="col-md-4">
                                                    <label for="">Ville </label>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="Ville (Optionnel)" wire:model="ville_" maxlength="50"  >
                                                    @error('ville_')
                                                            <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                                
                                            </div>
                
                                            <div class="col-md-4">
                                                    <label for="">Pays </label>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="Pays (Optionnel)" wire:model="pays_" maxlength="50"  >
                                                    @error('pays_')
                                                            <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                                
                                            </div>
                                        </div>
                                        
                                        <div class="row mb-2">
                                            <div class="col-md-4">
                                                     <label for="">Identification Fiscale</label> <small>(Id. Nat)</small>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="Id. Nat (Optionnel)" wire:model="id_nat" maxlength="120"   >
                                                    @error('id_nat')
                                                            <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                                
                                            </div>
                                          
                                            <div class="col-md-4">
                                                    <label for="">N° R.C.C.M </label>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="RCCM (Optionnel)" wire:model="rccm" maxlength="50"  >
                                                    @error('rccm')
                                                            <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                                
                                            </div>
                
                                            <div class="col-md-4">
                                                    <label for="">N° Impôt </label>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="N° Impôt (Optionnel)" wire:model="num_impot" maxlength="50"  >
                                                    @error('num_impot')
                                                            <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                                
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div> 
                        </div>
                    </div>
                    <div class="tab-pane fade {{ $tab_t == 'user' ? 'show active' : '' }}" 
                        id="user_t" role="tabpanel">
                        <div class="pd-20">
                            <div class="row">
                                <div class="col-md-12">
                                    <form >
                                        <div class="row mb-2">
                                         
                                            <div class="col-md-4">
                                                    <label for="">Pseudo <span style="color:red;">*</span></label>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="Pseudo" wire:model="pseudo" maxlength="15"  @if(!$isNewCustomer) readonly  @endif>
                                                    @error('pseudo')
                                                        <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                               
                                            </div>
                                            <div class="col-md-4">
                                                    <label for="">Email <span style="color:red;">*</span></label>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="Email" wire:model="email" maxlength="80" >
                                                    @error('email')
                                                        <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                                
                                            </div>
                                            <div class="col-md-4">
                                              
                                                <label for="">Téléphone </label>
                                                <input type="text"  class="form-control form-control-sm" placeholder="Téléphone (Optionnel)" wire:model="phone" maxlength="15">
                                                    @error('phone')
                                                            <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                            </div>
                                        </div>
                                        
                                        <div class="row mb-2">
                                         
                                            <div class="col-md-4">
                                                    <label for="">Nom <span style="color:red;">*</span></label>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="Nom" wire:model="lastname" maxlength="20"  >
                                                    @error('lastname')
                                                        <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                               
                                            </div>
                                            <div class="col-md-4">
                                                    <label for="">Postnom </label>
                                                    <input type="text"  class="form-control form-control-sm" placeholder="Postnom" wire:model="postname" maxlength="20">
                                                    @error('postname')
                                                        <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                                
                                            </div>
                                            <div class="col-md-4">
                                              
                                                <label for="">Prénom <span style="color:red;">*</span></label>
                                                <input type="text"  class="form-control form-control-sm" placeholder="Prénom" wire:model="firstname" maxlength="20">
                                                    @error('firstname')
                                                            <small class="form-text text-danger">{{ $message }}</small>
                                                    @enderror
                                            </div>
                                        </div>
                                        
                                        @if(!$isNewCustomer)
                                        <div class="row mb-2">
                                            <div class="col-md-4 pt-4">
                                                <button type="button" class="btn btn-outline-primary btn-sm" wire:click="addItem">Regénérer un mot de passe</button>    
                                            </div>
                                        </div>
                                        @endif
                                        
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                   
                </div>
            </div>

        </div>
        <div class="modal-footer">
            <button
                type="button"
                wire:click.prevent="CloseModalCustomer"
                class="btn btn-secondary btn-sm"
                data-dismiss="modal"
               
            >
                Fermer
            </button>

       

            @if($tab_t === 'user')
                <button type="button" class="btn @if($isNewCustomer) btn-primary @else btn-success @endif btn-sm" wire:click="saveCustomer"
                wire:loading.attr="disabled" style="width:15%;"
                >
                    <div class="spinner-border spinner-border-sm"  role="status" wire:loading wire:target="saveCustomer">
                        <span class="visually-hidden"></span>
                    </div>

                    <div wire:loading.remove wire:target="saveCustomer">
                        Enregistrer
                    </div>
                </button>

            @else
                <button type="button" wire:click="selectTab_t('user')"  class="btn btn-primary btn-sm" style="width:15%;">
                    Suivant
                </button>
            @endif
        </div>
    </div>
</div>
</div>

@push('scripts')

<script>
    	window.addEventListener('hideModalCustomer', event => {
					$('#ModalCustomer').modal('hide');
				})

        window.addEventListener('showModalCustomer', event => {
					$('#ModalCustomer').modal('show');
				})
  
</script>
    
@endpush

