<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('traitment', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('fk_demande')->unique();
            $table->enum('statut', ['PENDING', 'REJECTED', 'ALLOWED', 'EXPIRED'])->default('PENDING');
            $table->date('date_debut')->nullable();
            $table->time('heure_debut')->nullable();
            $table->date('date_fin')->nullable();
            $table->time('heure_fin')->nullable();
            $table->date('date_traitment')->nullable();
            $table->string('link')->nullable();
            $table->string('user_crea');
            $table->timestamp('date_crea')->useCurrent();
            $table->string('user_mod')->nullable();
            $table->timestamp('date_mod')->nullable()->useCurrentOnUpdate();
            $table->foreign('fk_demande')->references('id')->on('demandes');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('traitment');
    }
};
