<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('demandes', function (Blueprint $table) {
            $table->id();
            $table->enum('type_demande', ['demande', 'rens']);
            $table->string('object');
            $table->text('description');
            $table->date('date_debut');
            $table->time('heure_debut');
            $table->date('date_fin');
            $table->time('heure_fin');
            $table->string('numero_cible')->nullable();
            $table->string('kyc_cible')->nullable();
            $table->unsignedBigInteger('fk_societe');
            $table->unsignedBigInteger('fk_site');
            $table->string('user_crea');
            $table->timestamp('date_soumission')->useCurrent();
            $table->foreign('fk_societe')->references('id')->on('cpt_tbl_society');
            $table->foreign('fk_site')->references('id')->on('sites');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('demandes');
    }
};
