<?php

use App\Models\Cloture;
use App\Models\CloturePeriode;
use App\Models\Comptable;
use App\Models\CompteComptable;
use App\Models\Devise;
use App\Models\Exercices;
use App\Models\Facture;
use App\Models\FormeSociale;
use App\Models\ParentDevise;
use App\Models\TauxChange;
use App\Models\Tiers;
use App\Models\Transaction;
use App\Models\WorkDay;
use App\Models\demande;
use App\Models\intervenant;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Query\JoinClause;
use Carbon\Carbon;

// use DivisionByZeroError;
//   $token = base64_encode(Str::random(65));

//echo 1;

//var_dump(get_Compte_by_poste('cj'));

/** GET GENERAL SETTINGS */

/*
if(!function_exists('get_settings')){

    function get_settings(){
        $result = null;
        $result_data = null;

        $setting = new \App\Models\Admin\GeneralSetting();
        $result_data = $setting->first();

        if($result_data)
        {
            $result = $result_data ;
        }else{

            $setting->insert([
                'titre' => 'Commune de la N\'sele',
                'email' => 'contact@communedelansele.cd',
                'phone_main' => '+243 810 000 000',
                'address' => '2709, Bvld Lumumba Q.Kinkole',
            ]);
            $new_setting_data = $setting->first();
            $result = $new_setting_data ;
        }

        return $result ;

    }
}
*/
/*
$array = array();
$array = [
            'compte'       => '22333',
            'libelle'      => 'Achat OImmo',
            'soldeInitial' => ['d' => 10 , 'c' => 0],
            'variation'    => ['d' => 0 , 'c' => 51],
            'solde'        => ['d' => 12 , 'c' => 0 ],
        ];

dd($array) ; */

if (!function_exists('get_current_taux_change')) {

    function get_current_taux_change($devise)
    {
        $result =  DB::table('sys_tbl_change')
            ->where([
                'devise_start' => $devise,
                'devise_end' => get_local_devise()->devise,
                'fk_idworkday' => get_current_idWorkDay()
            ])
            ->select('taux')
            ->first();

        return ($result) ? $result->taux : null;
    }
}





if (!function_exists('get_format_date')) {

    function get_format_date($date, $format = null)
    {

        if (is_null($date)) {
            return '';
        } else {
            if ($format === "L") {
                return Carbon::parse($date)->format('d M. Y');
            }
            return Carbon::parse($date)->format('d-m-Y');
        }
    }
}


if (!function_exists('get_format_montant')) {

    function get_format_montant($montant)
    {
        return (is_null($montant)) ? null : number_format($montant, 2, ".", " ");
    }
}

if (!function_exists('get_abs_or_not')) {

    function get_abs_or_not($montant, $signe)
    {
        return ($signe === "-") ? abs($montant) : $montant;
    }
}

if (!function_exists('get_text_MAJ')) {

    function get_text_MAJ($text)
    {
        return strtoupper(strtolower($text));
    }
}

if (!function_exists('get_type_compte')) {

    function get_type_compte($type)
    {

        if ($type === "debit") {
            return "Débit";
        }
        if ($type === "credit") {
            return "Crédit";
        }
        if ($type === "hybrid") {
            return "Hybride";
        }
    }
}

if (!function_exists('get_local_devise')) {

    function get_local_devise()
    {
        $result = null;
        $result_data = null;

        $result_data = DB::select('SELECT sys.`devise`,sys.`intitule` 
                            FROM `sys_tbl_devise` sys
                            INNER JOIN `cpt_tbl_devise` cpt ON sys.devise = cpt.devise 
                            WHERE sys.`is_devise_local`= 1 AND cpt.`fk_id_parent`= ? ', [get_Current_idParent_Devise()]);

        if ($result_data) {
            $result = collect($result_data)->first();
        }

        return $result;
    }
}


if (!function_exists('create_Devise')) {

    function create_Devise(array $array, string $is_main)
    {

        try {

            DB::beginTransaction();
            $req = WorkDay::where(['id_app' => get_id_app()])->first();

            if ($req) {
                create_Auto_Change($array);
                create_Parent_Devise($array, $is_main);
            } else {
                create_Parent_Devise($array, $is_main);
            }

            DB::commit();
            return true;
        } catch (Exception $e) {

            DB::rollBack();
            return false;
        }
    }
}

if (!function_exists('get_id_app')) {

    function get_id_app()
    {
        return Auth::user()->id_app;
    }
}

if (!function_exists('get_pseudo')) {

    function get_pseudo()
    {
        return Auth::user()->pseudo;
    }
}

if (!function_exists('setExercice')) {

    function setExercice($exercice)
    {
        if ($exercice) {
            session()->put('exercice', $exercice);
        }
    }
}

if (!function_exists('getExercice')) {

    function getExercice()
    {
        return  session()->get('exercice');
    }
}



if (!function_exists('get_compte_immo')) {

    function get_compte_immo()
    {
        return CompteComptable::where('id_app', get_id_app())
            ->where('num_compte', 'LIKE', '2%')  // '%'.$term.'%'
            ->select('num_compte', 'nom_compte')
            ->get();
    }
}

if (!function_exists('get_compte_banque')) {

    function get_compte_banque()
    {
        return CompteComptable::where('id_app', get_id_app())
            ->where('num_compte', 'LIKE', '52%')  // '%'.$term.'%'
            ->select('num_compte', 'nom_compte')
            ->get();
    }
}

if (!function_exists('get_compte_caisse')) {

    function get_compte_caisse()
    {
        return CompteComptable::where('id_app', get_id_app())
            ->where('num_compte', 'LIKE', '57%')  // '%'.$term.'%'
            ->select('num_compte', 'nom_compte')
            ->get();
    }
}

if (!function_exists('get_compte_Client_or_Fourn')) {

    function get_compte_Client_or_Fourn($type)
    {

        if ($type === 'client') {

            return CompteComptable::where('id_app', get_id_app())
                ->where('num_compte', 'LIKE', '41%')  // '%'.$term.'%'
                ->whereNull('id_tiers')
                ->select('num_compte', 'nom_compte')
                ->get();
        } elseif ($type === 'fourn') {

            return CompteComptable::where('id_app', get_id_app())
                ->whereNull('id_tiers')
                ->where('num_compte', 'LIKE', '40%')  // '%'.$term.'%'
                ->orwhere('num_compte', 'LIKE', '48%')
                ->select('num_compte', 'nom_compte')
                ->get();
        } else {
            return [];
        }
    }
}


if (!function_exists('get_compte_sj_achat')) {

    function get_compte_sj_achat($tiers_id)
    {

        $first =    DB::table('cpt_tbl_compte_tiers')
            ->where('id_app', get_id_app())
            ->where('id_tiers', $tiers_id)
            ->select('compte AS num_compte', 'intitule AS nom_compte');

        return      DB::table('cpt_tbl_compte_comptable')
            ->where('id_app', get_id_app())
            /*  ->where('num_compte' , 'LIKE' , '40%')  // '%'.$term.'%'
                        ->orwhere('num_compte' , 'LIKE' , '48%')  */
            ->where('num_compte', 'LIKE', '6%')
            ->orwhere('num_compte', 'LIKE', '445%')
            ->orwhere('num_compte', 'LIKE', '4098%')
            ->select('num_compte', 'nom_compte')
            ->union($first)
            ->orderBy('num_compte')
            ->get();
    }
}

if (!function_exists('get_compte_sj_vente')) {

    function get_compte_sj_vente($tiers_id)
    {

        /* return CompteComptable::where('id_app' , get_id_app())
                    ->where('num_compte' , 'LIKE' , '41%')  // '%'.$term.'%'
                    ->orwhere('num_compte' , 'LIKE' , '7%')  
                    ->select('num_compte','nom_compte')
                    ->orderBy('num_compte')
                    ->get(); */

        $first =    DB::table('cpt_tbl_compte_tiers')
            ->where('id_app', get_id_app())
            ->where('id_tiers', $tiers_id)
            ->select('compte AS num_compte', 'intitule AS nom_compte');

        return      DB::table('cpt_tbl_compte_comptable')
            ->where('id_app', get_id_app())
            ->where('num_compte', 'LIKE', '41%')
            ->orwhere('num_compte', 'LIKE', '7%')
            ->select('num_compte', 'nom_compte')
            ->union($first)
            ->orderBy('num_compte')
            ->get();
    }
}



if (!function_exists('get_compte_sj_od')) {

    function get_compte_sj_od($tiers_id)
    {

        $first =    DB::table('cpt_tbl_compte_tiers')
            ->where('id_app', get_id_app())
            ->where('id_tiers', $tiers_id)
            ->select('compte AS num_compte', 'intitule AS nom_compte');

        return      DB::table('cpt_tbl_compte_comptable')
            ->where('id_app', get_id_app())
            ->select('num_compte', 'nom_compte')
            ->union($first)
            ->orderBy('num_compte')
            ->get();
    }
}


if (!function_exists('get_compte_tiers')) {

    function get_compte_tiers($tiers_id)
    {

        return    DB::table('cpt_tbl_compte_comptable')
            ->where('id_app', get_id_app())
            ->where('id_tiers', $tiers_id)
            ->select('num_compte', 'nom_compte')
            ->get();
    }
}

if (!function_exists('get_compte_of_tiers')) {

    function get_compte_of_tiers($tiers_id)
    {

        return    DB::table('cpt_tbl_compte_comptable')
            ->where('id_app', get_id_app())
            ->where('id_tiers', $tiers_id)
            ->select('num_compte as compte_tiers', 'nom_compte as intitule_compte', 'compte_general')
            ->get();
    }
}


if (!function_exists('get_tiers')) {

    function get_tiers($type)
    {

        if (!empty($type)) {
            return Tiers::where('id_app', get_id_app())
                ->where('type_tiers', $type)
                ->orderBy('denomination', 'ASC')
                ->select('id', 'denomination')
                ->get();
        } else {
            return Tiers::where('id_app', get_id_app())
                ->orderBy('type_tiers', 'denomination')
                ->select('id', 'denomination', 'type_tiers')
                ->get();
        }
    }
}


if (!function_exists('get_intitule_compte')) {

    function get_intitule_compte($numCompte)
    {


        $compte = CompteComptable::where([
            'id_app' => get_id_app(),
            'is_active' => 1,
            'num_compte' => $numCompte
        ])
            ->select('nom_compte AS intitule')
            ->first();

        return ($compte) ? $compte->intitule : null;
    }
}


if (!function_exists('get_select_devise')) {

    function get_select_devise()
    {
        $result = null;
        $result_data = null;
        $Option = "";

        return DB::select('SELECT sys.devise , sys.intitule, cpt.is_main
                                    FROM `cpt_tbl_devise` cpt
                                    INNER JOIN `sys_tbl_devise` sys ON cpt.devise = sys.devise 
                                    WHERE cpt.fk_id_parent = ? ORDER BY sys.devise', [get_Current_idParent_Devise()]);
    }
}



if (!function_exists('grand_livre')) {

    function grand_livre($compte, $date_start, $date_end)
    {

        $db = DB::select(
            'SELECT t.`id`,t.`intitule`,t.`justification`,t.`observation`,t.`devise`,
                                t.`fk_idworkday`,c.debit, c.credit,t.date_valeur
                            FROM `cpt_tbl_transaction` t 
                            INNER JOIN `cpt_tbl_comptable` c ON t.id = c.fk_transaction_id 
                                AND t.id_app = :id_app AND c.id_app = :id_appp
                            WHERE c.fk_num_compte = :compte AND t.date_valeur 
                                BETWEEN :date_start AND :date_end',
            [
                'compte'     => $compte,
                'date_start' => $date_start,
                'date_end'   => $date_end,
                'id_app'     => get_id_app(),
                'id_appp'     => get_id_app()
            ]
        );

        if (!$db) {
            return DB::select(
                'SELECT t.`id`,t.`intitule`,t.`justification`,t.`observation`,t.`devise`,
                                t.`fk_idworkday`,c.debit, c.credit,t.date_valeur,cc.`num_compte`,
                                cc.`nom_compte`,cc.`type_compte`
                            FROM `cpt_tbl_transaction` t 
                            INNER JOIN `cpt_tbl_comptable` c ON t.id = c.fk_transaction_id
                                            AND t.id_app = :id_app1 AND c.id_app = :id_app2
                            INNER JOIN `cpt_tbl_compte_comptable` cc ON cc.num_compte = c.fk_num_compte 
                                            AND cc.id_app = :id_app3 AND c.id_app = :id_app4
                            WHERE cc.compte_general = :compte AND t.date_valeur 
                                BETWEEN :date_start AND :date_end',
                [
                    'compte'     => $compte,
                    'date_start' => $date_start,
                    'date_end'   => $date_end,
                    'id_app1'     => get_id_app(),
                    'id_app2'     => get_id_app(),
                    'id_app3'     => get_id_app(),
                    'id_app4'     => get_id_app()
                ]
            );
        }

        return $db;
    }
}




if (!function_exists('Balance')) {

    function Balance($date_start, $date_end)
    {

        return DB::select(
            'CALL GET_COMPTE_OF_BALANCE(:date_end,:id_app)',
            [
                'date_end'  => $date_end,
                'id_app' => get_id_app()
            ]
        );
    }
}


if (!function_exists('Resultat')) {

    function Resultat()
    {

        return DB::select(
            'SELECT  `poste_code` AS code_poste,`intitule`,`is_poste_gestion` AS is_gestion,`note`,`operation`
                            FROM `cpt_tbl_poste` 
                            WHERE `type`="resultat" ORDER BY `order_num`'
        );
    }
}

if (!function_exists('CalculResultatNet')) {

    function CalculResultatNet($date_end)
    {

        $dictionaire = array();

        foreach (Resultat() as $info):

            $amount = 0;

            if ($info->code_poste === 'xa') {
                $amount = $dictionaire['ta'] - abs($dictionaire['ra']) + $dictionaire['rb'];
            } elseif ($info->code_poste === 'xb') {
                $amount = $dictionaire['ta'] + $dictionaire['tb'] + $dictionaire['tc'] + $dictionaire['td'];
            } elseif ($info->code_poste === 'xc') {
                $amount = ($dictionaire['xb'] - $dictionaire['ra'] + $dictionaire['rb']) +
                    ($dictionaire['te'] + $dictionaire['tf'] + $dictionaire['tg'] + $dictionaire['th'] +
                        $dictionaire['ti'] - abs($dictionaire['rc']) + $dictionaire['rd'] - abs($dictionaire['re']) +
                        $dictionaire['rf'] - abs($dictionaire['rg']) - abs($dictionaire['rh']) - abs($dictionaire['ri']) -
                        abs($dictionaire['rj'])
                    );
            } elseif ($info->code_poste === 'xd') {
                $amount =  $dictionaire['xc'] - abs($dictionaire['rk']);
            } elseif ($info->code_poste === 'xe') {
                $amount =  $dictionaire['xd'] + $dictionaire['tj'] - abs($dictionaire['rl']);
            } elseif ($info->code_poste === 'xf') {
                $amount =  $dictionaire['tk'] + $dictionaire['tl'] + $dictionaire['tm'] -
                    abs($dictionaire['rm']) - abs($dictionaire['rn']);
            } elseif ($info->code_poste === 'xg') {
                $amount =  $dictionaire['xe'] + $dictionaire['xf'];
            } elseif ($info->code_poste === 'xh') {
                $amount =  $dictionaire['tn'] + $dictionaire['to'] -
                    abs($dictionaire['ro']) - abs($dictionaire['rp']);
            } elseif ($info->code_poste === 'xi') {
                $amount =  $dictionaire['xg'] + $dictionaire['xh'] -
                    abs($dictionaire['rq']) - abs($dictionaire['rs']);
            } else {

                $mounts = get_Compte_by_poste($info->code_poste);

                foreach ($mounts as $mount):
                    $amount += get_solde($mount->num_compte, $mount->type_compte, $date_end);
                endforeach;
            }

            $dictionaire[$info->code_poste] = $amount;



        endforeach;

        return $dictionaire['xi'];
    }
}


if (!function_exists('Bilan')) {

    function Bilan($Operation)
    {

        return DB::select(
            'SELECT  `poste_code` AS code_poste,`intitule`,`is_poste_gestion` AS is_gestion,`note`,`operation`
                            FROM `cpt_tbl_poste` 
                            WHERE `type`="bilan" AND `operation` = :operation  ORDER BY `order_num`',
            [
                ':operation' => $Operation
            ]
        );
    }
}


if (!function_exists('get_select_formeSociale')) {

    function get_select_formeSociale()
    {

        return FormeSociale::where('is_active', '1')->get();
    }
}


if (!function_exists('get_select_compte_comptable')) {

    function get_select_compte_comptable()
    {

        return CompteComptable::where([
            'id_app' => get_id_app(),
            'is_active' => 1
        ])
            ->orderBy('num_compte')->get();
    }
}



if (!function_exists('get_Current_idParent_Devise')) {
    function get_Current_idParent_Devise()
    {

        return DB::table('cpt_tbl_parent_devise AS pd')
            ->join('cpt_tbl_devise AS td', function (JoinClause $join) {
                $join->on('pd.idparent', '=', 'td.fk_id_parent')
                    ->where('pd.id_app', get_id_app());
            })
            ->max('idparent');
    }
}

if (!function_exists('get_main_devise')) {

    function get_main_devise()
    {
        $result = Devise::where([
            'is_main' => 1,
            'fk_id_parent' => get_Current_idParent_Devise()
        ])
            ->select('devise')
            ->first();
        return ($result) ? $result->devise : null;
    }
}


if (!function_exists('get_current_idWorkDay')) {

    function get_current_idWorkDay()
    {

        $exer = getCurrentExercice();
        if ($exer) {
            return  DB::table('sys_tbl_workday AS w')
                ->join('sys_tbl_change AS c', function (JoinClause $join) {
                    $join->on('w.idworkday', '=', 'c.fk_idworkday')
                        ->where('w.id_app', get_id_app());
                })
                ->where('w.valid_to', $exer->end_date)
                ->max('idworkday');
        }
        return null;
    }
}

if (!function_exists('get_idWorkDay_by_Date')) {

    function get_idWorkDay_by_Date($date)
    {
        //$result = null;
        //$result_data = null;

        /*return  DB::table('sys_tbl_workday AS w')
                            ->join('sys_tbl_change AS c', function (JoinClause $join) {
                                $join->on('w.idworkday', '=', 'c.fk_idworkday')
                                ->where('w.id_app',get_id_app()) ;
                            })
                            ->whereBetween($date,['valid_from','valid_to'])
                            ->max('idworkday') ;*/

        $result = DB::select(
            'SELECT max(`idworkday`) as id 
                                    FROM `sys_tbl_workday` w  
                                    INNER JOIN `sys_tbl_change` c ON w.idworkday = c.fk_idworkday
                                    WHERE `id_app` = :id 
                                    AND :Pdate BETWEEN w.`valid_from` AND w.`valid_to`',
            [':id' => get_id_app(), ':Pdate' => $date]
        );
        return ($result) ? collect($result)->first()->id : null;
    }
}

if (!function_exists('get_libelle_devise')) {

    function get_libelle_devise($devise)
    {
        $result = DB::table('sys_tbl_devise')
            ->where('devise', $devise)
            ->select('intitule')
            ->first();

        return ($result) ? $result->intitule : null;
    }
}

if (!function_exists('get_info_compte')) {

    function get_info_compte($num_compte)
    {

        return CompteComptable::where(['num_compte' => $num_compte, 'id_app' => get_id_app()])->first();
    }
}




if (!function_exists('get_Compte_by_poste')) {

    function get_Compte_by_poste($poste)
    {

        return DB::select(
            'SELECT DISTINCT cc.`num_compte` ,cc.`type_compte`,cc.`is_parent`
                                    FROM `cpt_tbl_compte_comptable` cc
                                    INNER JOIN `cpt_tbl_compte_generique` cg ON cc.fk_cg_code = cg.cg_code 
                                            AND cc.id_app = :app
                                    WHERE cg.fk_poste_code = :poste ',
            [':poste' => $poste, ':app' => get_id_app()]
        );
    }
}


if (!function_exists('get_Compte_by_poste_TEST')) {

    function get_Compte_by_poste_TEST($poste)
    {
        $text = "";
        $r = DB::select(
            'SELECT * FROM `cpt_tbl_poste` cpt
                        INNER JOIN `cpt_tbl_compte_generique` tbl ON cpt.poste_code = tbl.fk_poste_code
                        WHERE cpt.poste_code = :poste  ',
            [':poste' => $poste]
        );


        foreach ($r as $a):
            // $text .= $a->cg_code." " ;
            if ($a) {
                $text .= $a->cg_code . "; ";
            }
        endforeach;
        return $text;
    }
}



if (!function_exists('get_poste_Exception_TEST')) {

    function get_poste_Exception_TEST($poste)
    {
        $text = "";
        $r = DB::select(
            'SELECT `exceptions` FROM `cpt_tbl_compte_generique` WHERE `fk_poste_code` = :poste  ',
            [':poste' => $poste]
        );


        foreach ($r as $a):
            if (trim(!empty($a->exceptions))) {
                $text .= $a->exceptions . "; ";
            }
        endforeach;
        return $text;
    }
}


if (!function_exists('get_Compte_by_poste_Actif')) {

    function get_Compte_by_poste_Actif($poste, $nature)
    {
        return DB::select(
            'SELECT `num_compte` ,`type_compte`,`is_parent`
                                    FROM `cpt_tbl_compte_comptable` cc
                                    INNER JOIN `cpt_tbl_compte_generique` cg ON cc.fk_cg_code = cg.cg_code AND cc.id_app = :app
                                    WHERE cg.fk_poste_code = :poste AND cg.is_amortissable = :nature  ',
            [':poste' => $poste, ':nature' => $nature, ':app' => get_id_app()]
        );
    }
}


if (!function_exists('get_Compte_by_poste_Actif_TEST')) {

    function get_Compte_by_poste_Actif_TEST($poste, $nature)
    {
        $text = "";
        $r = DB::select(
            'SELECT * FROM `cpt_tbl_poste` cpt
                        INNER JOIN `cpt_tbl_compte_generique` tbl ON cpt.poste_code = tbl.fk_poste_code
                        WHERE cpt.poste_code = :poste AND tbl.is_amortissable = :nature  ',
            [':poste' => $poste, ':nature' => $nature]
        );
        foreach ($r as $a):
            //$text .= $a->cg_code." " ;
            if ($a) {
                $text .= $a->cg_code . "; ";
            }
        endforeach;
        return $text;
    }
}



if (!function_exists('save_demande')) {

    function save_demande($id_site, $type_demande, $date_start, $heure_start, $date_end, $heure_end, $object, $content, $numero_cible, $kyc_cible, array $Intervenants)
    {

        try {

            DB::beginTransaction();
            // ** add demande

            $demande = new demande();

            $demande->fill([
                'type_demande' => $type_demande,
                'object' => $object,
                'description' => $content,
                'date_debut' => $date_start,
                'heure_debut' => $heure_start,
                'date_fin' => $date_end,
                'heure_fin' => $heure_end,
                'numero_cible' => $numero_cible,
                'kyc_cible' => $kyc_cible,
                'fk_site' => $id_site,
                'user_crea' => get_pseudo(),
                'fk_societe'  => get_id_app()
            ]);

            $demande->save();
            $demande->id;

            //** add intervenant data */

            foreach ($Intervenants as $data):
                intervenant::create([
                    'noms' => $data['noms'],
                    'phone' => $data['phone'],
                    'email' => $data['email'],
                    'fk_societe' => get_id_app(),
                    'fk_demande' => $demande->id,
                    'user_crea' => get_pseudo()
                ]);
            endforeach;

            DB::commit();
            return $demande->id;
        } catch (Exception $e) {
            DB::rollBack();
            dd($e);
            return false;
        }
    }
}


if (!function_exists('get_list_demande')) {

    function get_list_demande($typeDemande)
    {

        if ($typeDemande === 'PENDING') {

            return DB::select("SELECT * FROM (SELECT d.id as id_demande, d.object as titre, CASE 
    WHEN DATE(date_soumission) = CURDATE() 
        THEN DATE_FORMAT(date_soumission, '%H:%i')
    ELSE 
        DATE_FORMAT(date_soumission, '%d %M')
END AS date_sm , 
                    s.nom as nom_site, ty.raison_sociale as nom_entite , d.type_demande as typo_d,
                    'NULL' as traitmnt
                    FROM demandes as d
                    INNER JOIN sites as s ON d.fk_site = s.id
                    INNER JOIN cpt_tbl_society as ty ON d.fk_societe = ty.id
                    WHERE d.id NOT IN (SELECT fk_demande FROM traitment)
                    
                    UNION
                    SELECT d.id as id_demande, d.object as titre, CASE 
    WHEN DATE(date_soumission) = CURDATE() 
        THEN DATE_FORMAT(date_soumission, '%H:%i')
    ELSE 
        DATE_FORMAT(date_soumission, '%d %M')
END AS date_sm , 
                            s.nom as nom_site, ty.raison_sociale as nom_entite, d.type_demande as typo_d,
                            t.id as traitmnt
                            FROM demandes as d
                            INNER JOIN sites as s ON d.fk_site = s.id
                            INNER JOIN cpt_tbl_society as ty ON d.fk_societe = ty.id
                            INNER JOIN traitment as t ON d.id = t.fk_demande
                            WHERE t.statut = 'PENDING' ) AS union_result
                        ORDER BY id_demande DESC
                    ");
        } else {

            return DB::select("SELECT d.id as id_demande, d.object as titre, CASE 
    WHEN DATE(date_soumission) = CURDATE() 
        THEN DATE_FORMAT(date_soumission, '%H:%i')
    ELSE 
        DATE_FORMAT(date_soumission, '%d %M')
END AS date_sm , 
                            s.nom as nom_site, ty.raison_sociale as nom_entite, d.type_demande as typo_d,
                            t.id as traitmnt
                            FROM demandes as d
                            INNER JOIN sites as s ON d.fk_site = s.id
                            INNER JOIN cpt_tbl_society as ty ON d.fk_societe = ty.id
                            INNER JOIN traitment as t ON d.id = t.fk_demande
                            WHERE t.statut = :statut
                            ORDER BY d.id DESC", [':statut' => $typeDemande]);
            /* return DB::table('cpt_tbl_transaction AS trans')
                    ->join('stk_tbl_facture AS fact', function (JoinClause $join) {
                        $join->on('trans.fk_facture_id', '=', 'fact.id')
                            ->where(['trans.id_app' => get_id_app(),
                                     'fact.id_app' => get_id_app()
                                ]);
                    })
                    ->join('stk_tbl_tiers AS tiers', function (JoinClause $join) {
                        $join->on('fact.fk_tiers_id', '=', 'tiers.id')
                            ->where(['fact.id_app' => get_id_app(),
                                     'tiers.id_app' => get_id_app()
                                ]);
                    })
                    ->where('fact.type_facture', $journal)
                    ->where('trans.type_transaction','av')
                    ->whereBetween('trans.date_valeur', [$date_start, $date_end])
                    ->select('trans.id', 'trans.montant', 'trans.devise', 'trans.intitule', 'trans.date_valeur', 'trans.justification', 'trans.observation','fact.ref_facture','fact.num_facture','tiers.denomination')
                    ->paginate($per_page);
                    // ->get(); */
        }
    }
}



if (!function_exists('get_group_demande')) {

    function get_group_demande()
    {
        $array = [];
        $array['PENDING'] =  0;
        $array['ALLOWED'] =  0;
        $array['EXPIRED'] =  0;
        $array['REJECTED'] = 0;

        $req01 = DB::select("SELECT count(d.id) as id_nbr
                            FROM demandes as d
                            WHERE d.id NOT IN (SELECT fk_demande FROM traitment )
                            ");
        $new = ($req01) ? $req01[0]->id_nbr : 0;

        $req = DB::select("SELECT count(d.id) as id_nbr,t.statut
                            FROM demandes as d
                            INNER JOIN traitment as t ON d.id = t.fk_demande
                            GROUP  BY t.statut
                            ");


        foreach ($req as $stat):
            switch ($stat->statut) {
                case 'PENDING':
                    $array['PENDING'] = $stat->id_nbr + $new;
                    break;
                case 'ALLOWED':
                    $array['ALLOWED'] = $stat->id_nbr;
                    break;
                case 'EXPIRED':
                    $array['EXPIRED'] = $stat->id_nbr;
                    break;
                case 'REJECTED':
                    $array['REJECTED'] = $stat->id_nbr;
                    break;
            }

        endforeach;

        return $array;
    }
}



if (!function_exists('list_demande')) {

    function list_demande()
    {
        return DB::table('demandes as d')
            ->join('sites as s', function (JoinClause $join) {
                $join->on('d.fk_site', '=', 's.id');
            })
            ->join('cpt_tbl_society as ty', function (JoinClause $join) {
                $join->on('d.fk_societe', '=', 'ty.id');
            })
            ->leftJoin('traitment as t', function (JoinClause $join) {
                $join->on('d.id', '=', 't.fk_demande');
            })
            ->where('d.fk_societe', get_id_app())
            ->orderBy('date_soumission', 'DESC')
            ->select(
                'd.id as id_demande',
                'd.object as titre',
                'd.description as contenue',
                DB::raw("DATE_FORMAT(d.date_debut, '%d-%m-%Y') as date_d"),
                DB::raw("DATE_FORMAT(d.date_fin, '%d-%m-%Y') as date_f"),
                'd.heure_debut as heure_d',
                'd.heure_fin as heure_f',
                'd.date_debut as date_dd',
                'd.date_fin as date_ff',
                DB::raw("DATE_FORMAT(d.date_soumission, '%d-%m-%Y à %H:%i') as date_sm"),
                's.nom as nom_site',
                't.statut as statut',
                't.statut as stat'
            )->get()
        ;
    }
}




if (!function_exists('get_demande')) {

    function get_demande($key)
    {

        /* return DB::select("SELECT  d.id as id_demande, d.object as titre, 
                                d.description as contenue,
                                date_format(d.date_debut,'%d-%m-%Y') as date_d,
                                date_format(d.date_fin,'%d-%m-%Y') as date_f,
                                d.heure_debut as heure_d ,
                                d.heure_fin as heure_f ,
                                date_format(date_soumission,'%d-%m-%Y à %H:%i') as date_sm , 
                                s.nom as nom_site, ty.raison_sociale as nom_entite,
                                ty.activite_principale as act_princ, 
                                ty.telephone as phone , 
                                ty.email as email_society , 
                                ty.adresse  as adress_society, 
                                ty.ville as city_society ,
                                ty.sigle as sigle_society
                            FROM demandes as d
                            INNER JOIN sites as s ON d.fk_site = s.id
                            INNER JOIN cpt_tbl_society as ty ON d.fk_societe = ty.id
                            LEFT JOIN traitment as t ON d.id = t.fk_demande
                            WHERE d.id = :id
                            ", [':id' => $key]); */

        return DB::table('demandes as d')
            ->join('sites as s', function (JoinClause $join) {
                $join->on('d.fk_site', '=', 's.id');
            })
            ->join('cpt_tbl_society as ty', function (JoinClause $join) {
                $join->on('d.fk_societe', '=', 'ty.id');
            })
            ->leftJoin('traitment as t', function (JoinClause $join) {
                $join->on('d.id', '=', 't.fk_demande');
            })
            ->leftJoin('t_links as l', function (JoinClause $join) {
                $join->on('d.id', '=', 'l.demande');
            })
            ->where('d.id', $key)
            ->select(
                'd.id as id_demande',
                'd.object as titre',
                'd.description as contenue',
                DB::raw("DATE_FORMAT(d.date_debut, '%d-%m-%Y') as date_d"),
                DB::raw("DATE_FORMAT(d.date_fin, '%d-%m-%Y') as date_f"),

                DB::raw("DATE_FORMAT(d.heure_debut, '%H:%i') as heure_d"),
                DB::raw("DATE_FORMAT(d.heure_fin, '%H:%i') as heure_f"),

                'd.date_debut as date_dd',
                'd.date_fin as date_ff',
                DB::raw("DATE_FORMAT(d.date_soumission, '%d-%m-%Y à %H:%i') as date_sm"),
                DB::raw("DATE_FORMAT(t.date_traitment, '%d-%m-%Y ') as dtraitment"),
                's.nom as nom_site',
                't.statut as statut',
                'ty.raison_sociale as nom_entite',
                'ty.activite_principale as act_princ',
                'ty.telephone as phone',
                'ty.email as email_society',
                'ty.adresse  as adress_society',
                'ty.ville as city_society',
                'ty.sigle as sigle_society',
                'l.token as code',
                'd.numero_cible as numero',
                'd.kyc_cible as kyc',
                'd.type_demande as typo_d'
            )
            ->first();
    }
}


if (!function_exists('get_intervenants')) {

    function get_intervenants($key)
    {
        return DB::select("SELECT noms as full_name, phone as telephone, email as address_mail
                            FROM intervenants
                            WHERE fk_demande = :id
                            ", [':id' => $key]);
    }
}

if (!function_exists('get_files')) {

    function get_files($key)
    {
        return DB::select("SELECT upload as full_name_file
                            FROM t_file_uploads
                            WHERE fk_demande = :id
                            ", [':id' => $key]);
    }
}


if (!function_exists('get_journal_comptable')) {

    function get_journal_comptable($journal, $date_start, $date_end, $per_page, $search = null)
    {

        if ($journal == 'achat' || $journal == 'vente') {
            /*return DB::select('SELECT trans.`id`,trans.`montant`,trans.`devise`,trans.`intitule`,trans.`date_valeur`,
                                    trans.`justification`,trans.`observation`,fact.`num_facture`, tiers.`denomination`
                                FROM `cpt_tbl_transaction` trans
                                INNER JOIN `stk_tbl_facture` fact ON trans.fk_facture_id = fact.id AND trans.id_app = :id_app
                                INNER JOIN `stk_tbl_tiers` tiers  ON fact.fk_tiers_id = tiers.id AND tiers.id_app = :id_appp
                                WHERE fact.type_facture = :type_fac AND trans.date_valeur BETWEEN :date_start AND :date_end', 
                                ['type_fac' => $journal 
                                ,'date_start' => $date_start 
                                , 'date_end' => $date_end
                                ,'id_app'    => get_id_app()
                                ,'id_appp'    => get_id_app()]
                            ); */

            if (is_null($search) || empty(trim($search))) {

                return DB::table('cpt_tbl_transaction AS trans')
                    ->join('stk_tbl_facture AS fact', function (JoinClause $join) {
                        $join->on('trans.fk_facture_id', '=', 'fact.id')
                            ->where([
                                'trans.id_app' => get_id_app(),
                                'fact.id_app' => get_id_app()
                            ]);
                    })
                    ->join('stk_tbl_tiers AS tiers', function (JoinClause $join) {
                        $join->on('fact.fk_tiers_id', '=', 'tiers.id')
                            ->where([
                                'fact.id_app' => get_id_app(),
                                'tiers.id_app' => get_id_app()
                            ]);
                    })
                    ->where('fact.type_facture', $journal)
                    ->where('trans.type_transaction', 'av')
                    ->whereBetween('trans.date_valeur', [$date_start, $date_end])
                    ->select('trans.id', 'trans.montant', 'trans.devise', 'trans.intitule', 'trans.date_valeur', 'trans.justification', 'trans.observation', 'fact.ref_facture', 'fact.num_facture', 'tiers.denomination')
                    ->paginate($per_page);
                // ->get();
            } else {

                return DB::table('cpt_tbl_transaction AS trans')
                    ->join('stk_tbl_facture AS fact', function (JoinClause $join) {
                        $join->on('trans.fk_facture_id', '=', 'fact.id')
                            ->where([
                                'trans.id_app' => get_id_app(),
                                'fact.id_app' => get_id_app()
                            ]);
                    })
                    ->join('stk_tbl_tiers AS tiers', function (JoinClause $join) {
                        $join->on('fact.fk_tiers_id', '=', 'tiers.id')
                            ->where([
                                'fact.id_app' => get_id_app(),
                                'tiers.id_app' => get_id_app()
                            ]);
                    })
                    ->where('fact.type_facture', $journal)
                    ->where('trans.type_transaction', 'av')
                    ->whereBetween('trans.date_valeur', [$date_start, $date_end])
                    ->where('trans.intitule', 'like', "%" . $search . "%")
                    ->select('trans.id', 'trans.montant', 'trans.devise', 'trans.intitule', 'trans.date_valeur', 'trans.justification', 'trans.observation', 'fact.num_facture', 'tiers.denomination')
                    ->paginate($per_page);
            }
        } else if ($journal === "od") {

            /*  return DB::select('SELECT trans.`id`,trans.`montant`,trans.`devise`,trans.`intitule`,trans.`date_valeur`,
                                    trans.`justification`,trans.`observation`
                                FROM `cpt_tbl_transaction` trans
                                WHERE trans.id_app= :id_app AND trans.type_transaction = "od" AND trans.date_valeur BETWEEN :date_start AND :date_end', 
                                [
                                'date_start' => $date_start 
                                , 'date_end' => $date_end
                                ,'id_app'    => get_id_app()
                                ]
                            ); */

            if (is_null($search) || empty(trim($search))) {

                return DB::table('cpt_tbl_transaction AS trans')
                    ->where('trans.id_app', '=', get_id_app())
                    ->where('trans.type_transaction', 'od')
                    ->whereBetween('trans.date_valeur', [$date_start, $date_end])
                    ->select(
                        'trans.id',
                        'trans.montant',
                        'trans.devise',
                        'trans.intitule',
                        'trans.date_valeur',
                        'trans.justification',
                        'trans.observation',
                        'trans.file_justif'
                    )
                    ->paginate($per_page);
            } else {

                return DB::table('cpt_tbl_transaction AS trans')
                    ->where('trans.id_app', '=', get_id_app())
                    ->where('trans.type_transaction', 'od')
                    ->whereBetween('trans.date_valeur', [$date_start, $date_end])
                    ->where('trans.intitule', 'like', "%" . $search . "%")
                    ->select(
                        'trans.id',
                        'trans.montant',
                        'trans.devise',
                        'trans.intitule',
                        'trans.date_valeur',
                        'trans.justification',
                        'trans.observation',
                        'trans.file_justif'
                    )
                    ->paginate($per_page);
            }
        } else if ($journal === "banque" || $journal === "caisse") {

            $compte = ($journal == "banque") ? 52 : 57;

            /* return DB::select('SELECT DISTINCT trans.`id`,trans.`montant`,trans.`devise`,trans.`intitule`,trans.`date_valeur`,
                                    trans.`justification`,trans.`observation`, tiers.`denomination`
                                FROM `cpt_tbl_transaction` trans
                                INNER JOIN `cpt_tbl_comptable` comp  ON comp.fk_transaction_id = trans.id AND trans.id_app = :id_app
                                INNER JOIN `stk_tbl_tiers` tiers  ON trans.fk_tiers_id = tiers.id AND tiers.id_app = :id_appp
                                WHERE comp.fk_num_compte like "52%" AND trans.date_valeur BETWEEN :date_start AND :date_end', 
                                [
                                'date_start' => $date_start 
                                , 'date_end' => $date_end
                                ,'id_app'    => get_id_app()
                                ,'id_appp'    => get_id_app()]
                            ); */


            if (is_null($search) || empty(trim($search))) {

                return DB::table('cpt_tbl_transaction AS trans')
                    ->join('cpt_tbl_comptable AS comp', function (JoinClause $join) {
                        $join->on('comp.fk_transaction_id', '=', 'trans.id')
                            ->where([
                                'comp.id_app' => get_id_app(),
                                'trans.id_app' => get_id_app()
                            ]);
                    })
                    /* ->join('stk_tbl_tiers AS tiers', function (JoinClause $join) {
                        $join->on('trans.fk_tiers_id', '=', 'tiers.id')
                            ->where(['trans.id_app' => get_id_app(),
                                'tiers.id_app' => get_id_app()
                            ]);
                    }) */
                    ->leftJoin('stk_tbl_tiers AS tiers', function (JoinClause $join) {
                        $join->on('trans.fk_tiers_id', '=', 'tiers.id')
                            ->where([
                                'trans.id_app' => get_id_app(),
                                'tiers.id_app' => get_id_app()
                            ]);
                    })
                    ->where('trans.type_transaction', 'tr')
                    ->whereBetween('trans.date_valeur', [$date_start, $date_end])
                    ->where('comp.fk_num_compte', 'like', $compte . "%")
                    ->distinct()
                    ->select(
                        'trans.id',
                        'trans.montant',
                        'trans.devise',
                        'trans.intitule',
                        'trans.date_valeur',
                        'trans.justification',
                        'trans.observation',
                        'tiers.denomination'
                    )
                    ->orderBy('date_valeur', 'DESC')
                    ->paginate($per_page);
            } else {

                return DB::table('cpt_tbl_transaction AS trans')
                    ->join('cpt_tbl_comptable AS comp', function (JoinClause $join) {
                        $join->on('comp.fk_transaction_id', '=', 'trans.id')
                            ->where([
                                'trans.id_app' => get_id_app(),
                                'comp.id_app' => get_id_app()
                            ]);
                    })
                    ->leftJoin('stk_tbl_tiers AS tiers', function (JoinClause $join) {
                        $join->on('trans.fk_tiers_id', '=', 'tiers.id')
                            ->where([
                                'trans.id_app' => get_id_app(),
                                'tiers.id_app' => get_id_app()
                            ]);
                    })
                    ->where('trans.type_transaction', 'tr')
                    ->whereBetween('trans.date_valeur', [$date_start, $date_end])
                    ->where('comp.fk_num_compte', 'like', $compte . "%")
                    ->where('trans.intitule', 'like', "%" . $search . "%")
                    ->distinct()
                    ->select(
                        'trans.id',
                        'trans.montant',
                        'trans.devise',
                        'trans.intitule',
                        'trans.date_valeur',
                        'trans.justification',
                        'trans.observation',
                        'tiers.denomination'
                    )
                    ->orderBy('date_valeur', 'DESC')
                    ->paginate($per_page);
            }
        } else if ($journal == 'od_av') {

            if (is_null($search) || empty(trim($search))) {

                return DB::table('cpt_tbl_transaction AS trans')
                    ->join('stk_tbl_tiers AS tiers', function (JoinClause $join) {
                        $join->on('trans.fk_tiers_id', '=', 'tiers.id')
                            ->where([
                                'trans.id_app' => get_id_app(),
                                'tiers.id_app' => get_id_app()
                            ]);
                    })
                    ->where('trans.type_transaction', 'od_av')
                    ->whereBetween('trans.date_valeur', [$date_start, $date_end])
                    ->select('trans.id', 'trans.montant', 'trans.devise', 'trans.intitule', 'trans.date_valeur', 'trans.justification', 'trans.observation', 'tiers.denomination', 'trans.file_justif')
                    ->orderBy('date_valeur', 'DESC')
                    ->paginate($per_page);
                // ->get();
            } else {

                return DB::table('cpt_tbl_transaction AS trans')
                    ->join('stk_tbl_tiers AS tiers', function (JoinClause $join) {
                        $join->on('trans.fk_tiers_id', '=', 'tiers.id')
                            ->where([
                                'trans.id_app' => get_id_app(),
                                'tiers.id_app' => get_id_app()
                            ]);
                    })
                    ->where('trans.type_transaction', 'od_av')
                    ->whereBetween('trans.date_valeur', [$date_start, $date_end])
                    ->where('trans.intitule', 'like', "%" . $search . "%")
                    ->select('trans.id', 'trans.montant', 'trans.devise', 'trans.intitule', 'trans.date_valeur', 'trans.justification', 'trans.observation', 'tiers.denomination', 'trans.file_justif')
                    ->orderBy('date_valeur', 'DESC')
                    ->paginate($per_page);
            }
        } else {
            return null;
        }
    }
}

if (!function_exists('get_solde_of_poste_by_exercice')) {

    function get_solde_of_poste_by_exercice($exercice, $poste)
    {

        $rep = DB::table('cpt_tbl_archive')
            ->where([
                'id_app' => get_id_app(),
                'exercice' => $exercice,
                'fk_poste_code' => $poste
            ])
            ->select('solde')
            ->first();

        return ($rep) ? $rep->solde : 0;
    }
}


if (!function_exists('get_list_tiers')) {

    function get_list_tiers($type_tiers, $per_page, $search = null)
    {

        if ($type_tiers === 'tous') {
            return  Tiers::where(['id_app' => get_id_app()])
                ->search($search)
                ->orderBy('denomination', 'ASC')
                ->paginate($per_page);
        } else {
            return  Tiers::where(['id_app' => get_id_app(), 'type_tiers' => $type_tiers])
                ->search($search)
                ->orderBy('denomination', 'ASC')
                ->paginate($per_page);
        }
    }
}

if (!function_exists('get_select_tiers')) {

    function get_select_tiers($type_tiers)
    {
        return  Tiers::where(['id_app' => get_id_app(), 'type_tiers' => $type_tiers])
            ->orderBy('denomination', 'ASC')
            ->select('id', 'denomination')
            ->get();
    }
}

function create_Parent_Devise(array $array, string $is_main)
{
    $Parent = new ParentDevise();
    $Parent->fill([
        'user_crea' => get_pseudo(),
        'id_app' => get_id_app()
    ]);
    $Parent->save();

    foreach ($array as $ar) {
        Devise::create([
            'fk_id_parent' => $Parent->id,
            'devise' => $ar,
            'is_main' => ($ar === $is_main) ? 1 : 0
        ]);
    }
}


function create_Auto_Change(array $array)
{

    $inputs = TauxChange::where(['fk_idworkday' => get_current_idWorkDay()])->get();

    $workDay = new WorkDay();
    $workDay->fill([
        'user_crea' => get_pseudo(),
        'id_app' => get_id_app(),
    ]);
    $workDay->save();

    foreach ($inputs as $input) :

        if (in_array($input->devise_start, $array)) {

            TauxChange::create([
                'fk_idworkday' => $workDay->id,
                'devise_start' => $input->devise_start,
                'taux' => $input->taux,
                'devise_end' =>  $input->devise_end
            ]);
        }

    endforeach;
}



if (!function_exists('save_Treso')) {

    function save_Treso(string $typeJournal, $idTiers, $Compte_Tiers, $CompteTreso, $ref_Facture, $date, string $libelle, $montant, string $devise, $piece_justif, $file, $IsEncaissement = false)
    {

        try {


            DB::beginTransaction();
            $workDay = get_current_idWorkDay();

            /** 
             ** Check if is Treso Facture OR Transaction Diverses 
             */

            if ($typeJournal === "TresoFacture") {

                if (is_null($idTiers) && is_null($Compte_Tiers)) {
                    /** 
                     ** Traitement Signulier
                     */
                    $facture      = Facture::getFactureByNumFac($ref_Facture);
                    $CompteTiers  = Facture::getCompteTiersFacture($facture->id);
                    //  $SoldeFacture = Facture::getSoldeFacture($facture->id);
                    $IdTiers      = $facture->fk_tiers_id;
                    $idfacture    = $facture->id;

                    /**
                     * ! If  solde facture est egal or inf. à 0: return Error
                     */
                    if ($facture->solde <= 0) {
                        DB::rollBack();
                        return "Facture déjà soldée";
                    }

                    /**
                     * ! If montant à payer est sup. au solde facture : return Error
                     */
                    if ($montant > $facture->solde) {
                        DB::rollBack();
                        return "montant sup. au solde de la facture";
                    }

                    /**
                     ** Update Solde Facture
                     */
                    if ($montant == $facture->solde) {
                        $facture->statut_facture = 'PAID';
                    }
                    $facture->solde -= $montant;
                    $facture->save();


                    /** 
                     ** Check if Compte Tiers is 40.Fournisseur or 41.Client 
                     */
                    $IsFournisseur = (substr($CompteTiers, 0, 2) == 40) ? true : false;

                    //dd($IsFournisseur);
                    $comptas = array(
                        [
                            'compte' => $CompteTreso,
                            'debit'  => ($IsFournisseur) ? 0 : $montant,
                            'credit' => ($IsFournisseur) ? $montant : 0
                        ],
                        [
                            'compte' => $CompteTiers,
                            'debit'  => ($IsFournisseur) ? $montant : 0,
                            'credit' => ($IsFournisseur) ? 0 : $montant
                        ]
                    );
                } else {

                    /** 
                     ** Traitement Global
                     */

                    $CompteTiers = $Compte_Tiers;
                    $IdTiers     = $idTiers;
                    $idfacture   = null;


                    $comptas = array(
                        [
                            'compte' =>  $CompteTreso,
                            'debit'  => ($IsEncaissement) ? $montant : 0,
                            'credit' => ($IsEncaissement) ? 0 : $montant
                        ],
                        [
                            'compte' => $CompteTiers,
                            'debit'  => ($IsEncaissement) ? 0 : $montant,
                            'credit' => ($IsEncaissement) ? $montant : 0
                        ]
                    );
                }
            } else if ($typeJournal === "TresoTD") {

                /** 
                 ** Traitement Transaction Diverses
                 */

                $CompteTiers = $Compte_Tiers;
                $IdTiers     = null;
                $idfacture   = null;


                $comptas = array(
                    [
                        'compte' => $CompteTreso,
                        'debit'  => ($IsEncaissement) ? $montant : 0,
                        'credit' => ($IsEncaissement) ? 0 : $montant
                    ],
                    [
                        'compte' => $CompteTiers,
                        'debit'  => ($IsEncaissement) ? 0 : $montant,
                        'credit' => ($IsEncaissement) ? $montant : 0
                    ]
                );
            } else {

                /**
                 * ! if TypeJournal is not TresoFacture OR not TresoTD : return Error
                 */
                DB::rollBack();
                return "Error Parametres";
            }



            // ** add Transaction

            $transaction = new Transaction();
            $transaction->fill([
                'type_transaction' => 'tr',
                'fk_facture_id'    => $idfacture,
                'fk_tiers_id'      => $IdTiers,
                'montant'          => $montant,
                'devise'           => $devise,
                'fk_idworkday'     => $workDay,
                'intitule'         => $libelle,
                'date_valeur'      => $date,
                'justification'    => $piece_justif,
                'observation'      => null,
                'file_justif'      => $file,
                'user_crea'        => get_pseudo(),
                'id_app'           => get_id_app()
            ]);

            $transaction->save();

            //** add compta data */

            foreach ($comptas as $compta):
                Comptable::create([
                    'fk_transaction_id' => $transaction->id,
                    'fk_num_compte' => $compta['compte'],
                    'debit' => $compta['debit'],
                    'credit' => $compta['credit'],
                    'devise' => $devise,
                    'fk_idworkday' => $workDay,
                    'id_app' => get_id_app()
                ]);
            endforeach;

            DB::commit();
            return 1;
        } catch (Exception $e) {

            DB::rollBack();
            return "Une erreur est survenue";
        }
    }
}

if (!function_exists('get_soldeInitial')) {

    function get_soldeInitial($compte, $date)
    {

        $exercice = getExercice_n_1();
        /*$queryDate = DB::select('SELECT GET_DATE_OF_LAST_CLOTURE(:P_DATE,:P_ID_APP) AS date_last', 
                        ['P_DATE' => $date , 'P_ID_APP' => get_id_app()]);

        if($queryDate)
        {
            $date_last = collect($queryDate)->first()->date_last;
        } */



        $init = Cloture::where([
            'id_app' => get_id_app(),
            'exercice' => $exercice,
            'fk_num_compte' => $compte
        ])
            ->select('solde')
            ->first();


        /*  $querySoldeInitial = DB::select('SELECT c.solde AS solde 
                        FROM `cpt_tbl_exercice` e
                        INNER JOIN `cpt_tbl_cloture` c ON e.exercice = c.exercice 
                        AND c.id_app = :P_ID_APPP AND e.id_app = :P_ID_APP
                        WHERE c.fk_num_compte = :COMPTE  AND e.end_date =  :date_last', 
                        ['COMPTE' => $compte , 'date_last' => '2022-12-31' 
                        , 'P_ID_APP' => get_id_app(), 'P_ID_APPP' => get_id_app()]); */


        return ($init) ? $init->solde : 0;
    }
}

if (!function_exists('get_solde')) {

    function get_solde($compte, $typeCompte, $date)
    {
        $solde = 0;

        try {
            $querySolde = DB::select(
                'SELECT GET_SOLDE_OF_COMPTE(:COMPTE,:typeCompte,:date_end,:id_app) AS solde',
                ['COMPTE' => $compte, 'typeCompte' => $typeCompte, 'date_end' => $date, 'id_app' => get_id_app()]
            );
        } catch (\Throwable $th) {
            //throw $th;
            dd($compte);
        }

        if ($querySolde) {
            $solde = collect($querySolde)->first()->solde;
        }
        return $solde;
    }
}


if (!function_exists('get_soldes')) {

    function get_soldes($compte, $typeCompte, $date)
    {
        $solde = 0;

        $compteSups = DB::table('cpt_tbl_compte_comptable')
            ->where('id_app', get_id_app())
            ->where('compte_general', $compte)
            ->select('num_compte AS compte')
            ->get();

        foreach ($compteSups as $compteSup) :
            $querySolde = DB::select(
                'SELECT GET_SOLDE_OF_COMPTE(:COMPTE,:typeCompte,:date_end,:id_app) AS solde',
                ['COMPTE' => $compteSup->compte, 'typeCompte' => $typeCompte, 'date_end' => $date, 'id_app' => get_id_app()]
            );
            if ($querySolde) {
                $solde += collect($querySolde)->first()->solde;
            }
        endforeach;


        return $solde;
    }
}

if (!function_exists('showSolde')) {

    function showSolde($montant, $type)
    {

        $return = array();

        if ($type === 'credit') {
            if ($montant < 0) {
                $soldeDebit = $montant;
                $soldeCredit = null;
            } else {
                $soldeDebit = null;
                $soldeCredit = $montant;
            }
        } else {

            if ($montant < 0) {
                $soldeDebit = null;
                $soldeCredit = $montant;
            } else {
                $soldeDebit = $montant;
                $soldeCredit = null;
            }
        }

        return array(
            'soldeDebit' => (is_null($soldeDebit)) ? null : abs($soldeDebit),
            'soldeCredit' => (is_null($soldeCredit)) ? null : abs($soldeCredit)
        );
    }
}



if (!function_exists('get_variations_of_compte')) {

    function get_variations_of_compte($compte, $date_start, $date_end)
    {
        $result = null;
        $result_data = null;


        if (CheckIf($compte)) {

            $array =  array(
                'compte' => $compte,
                'date_start' => $date_start,
                'date_end' => $date_end,
                'id_app' => get_id_app(),
                'id_app2' => get_id_app(),
                'id_app3' => get_id_app(),
                'id_app4' => get_id_app()
            );

            $result_data = DB::select(
                'SELECT IFNULL(SUM(c.debit),0) AS debit ,IFNULL(SUM(c.credit),0)  AS credit
            FROM `cpt_tbl_transaction` t
            INNER JOIN `cpt_tbl_comptable` c ON t.id = c.fk_transaction_id 
                AND t.id_app = :id_app AND c.id_app = :id_app2
            INNER JOIN `cpt_tbl_compte_comptable` ct ON ct.num_compte = c.fk_num_compte
                AND ct.id_app = :id_app3 AND c.id_app = :id_app4
            WHERE ct.compte_general = :compte AND t.date_valeur BETWEEN :date_start AND :date_end ',
                $array
            );
        } else {

            $array =  array(
                'compte' => $compte,
                'date_start' => $date_start,
                'date_end' => $date_end,
                'id_app' => get_id_app(),
                'id_appp' => get_id_app()
            );

            $result_data = DB::select(
                'SELECT IFNULL(SUM(c.debit),0) AS debit ,IFNULL(SUM(c.credit),0)  AS credit
            FROM `cpt_tbl_transaction` t
            INNER JOIN `cpt_tbl_comptable` c ON t.id = c.fk_transaction_id 
            AND c.id_app = :id_app AND t.id_app = :id_appp
            WHERE c.fk_num_compte = :compte AND t.date_valeur BETWEEN :date_start AND :date_end ',
                $array
            );
        }

        $result = collect($result_data)->first();

        return $result;
    }
}

if (!function_exists('get_historique_tauxChange')) {
    function get_historique_tauxChange()
    {

        return   DB::table('sys_tbl_change  AS c')
            ->join('sys_tbl_workday AS w', function (JoinClause $join) {
                $join->on('c.fk_idworkday', '=', 'w.idworkday')
                    ->where('w.id_app', get_id_app());
            })
            ->whereBetween('valid_from', [
                getCurrentExercice()->start_date,
                getCurrentExercice()->end_date
            ])
            ->select('w.idworkday', 'c.devise_start', 'c.taux', 'c.devise_end', 'w.valid_from', 'w.valid_to')
            ->orderBy('idworkday', 'DESC')
            ->get();
    }
}

if (!function_exists('get_historique_exercice')) {
    function get_historique_exercice()
    {

        return Exercices::where('id_app', get_id_app())
            ->where('is_auto', 0)
            ->select('exercice', 'date_crea', 'date_closed')
            ->orderBy('exercice', 'DESC')
            ->get();
    }
}

if (!function_exists('get_historique_cloture_periode')) {
    function get_historique_cloture_periode()
    {

        return CloturePeriode::where('id_app', get_id_app())
            /* ->where('is_auto',0) */
            ->where('exercice', getExercice())
            ->select('exercice', 'date_valeur')
            ->orderBy('id', 'DESC')
            ->get();
    }
}



/**
 *! Partie Amortissement
 */

if (!function_exists('amort_journalier')) {
    function amort_journalier($montant, $periode)
    {
        $periode = intval($periode) * 365;
        try {
            return round(floatval($montant) / $periode, 2);
        } catch (Exception $e) {
            return 0;
        }
    }
}

if (!function_exists('amort_nbre_jour_ant')) {
    function amort_nbre_jour_ant($date_acq, $date_amort, $mois)
    {
        $date0 = Carbon::parse($date_acq);
        $date1 = Carbon::parse($date_amort)->subMonth($mois);
        return ($date0 <= $date1) ? $date0->diffInDays($date1) : 0;
    }
}


if (!function_exists('amort_nbre_jour_amort')) {
    function amort_nbre_jour_amort($date_amort, $mois)
    {
        $date0 = Carbon::parse($date_amort)->subMonth($mois);
        $date1 = Carbon::parse($date_amort);
        return ($date0 <= $date1) ? $date0->diffInDays($date1) : 0;
    }
}



if (!function_exists('tab_compte_immo')) {

    function tab_compte_immo()
    {
        return  DB::table('cpt_tbl_immobilisation AS immo')
            ->join('cpt_tbl_compte_comptable AS compt', function (JoinClause $join) {
                $join->on('immo.fk_num_compte', '=', 'compt.num_compte')
                    ->where([
                        'immo.id_app' => get_id_app(),
                        'compt.id_app' => get_id_app()
                    ]);
            })
            ->select('compt.num_compte', 'compt.nom_compte')
            ->distinct()
            ->orderBy('num_compte')
            ->get();
    }
}

if (!function_exists('tab_immo')) {

    function tab_immo($compte)
    {
        return  DB::table('cpt_tbl_immobilisation AS immo')
            ->where('immo.id_app', '=', get_id_app())
            ->where('immo.fk_num_compte', $compte)
            ->orderBy('immo.date_acquisition')
            ->select('immo.intitule', 'immo.date_acquisition', 'immo.montant', 'immo.devise', 'immo.fk_idworkday', 'immo.periode')
            ->get();
    }
}


if (!function_exists('generate_dico_immo')) {

    function generate_dico_immo($amort_date, $amort_sur, $data)
    {

        $dico_immo = array();


        foreach ($data as $info):
            $data1 = array();
            $dico_detail = array();

            $total_montant = 0;
            $total_ant = 0;
            $total_amort = 0;
            $total_val_res = 0;
            $data1['num_compte']   = $info->num_compte;
            $data1['nom_compte']   = $info->nom_compte;

            $immos = tab_immo($info->num_compte);

            foreach ($immos as $immo) :
                $data2 = array();
                $montant = floatval($immo->montant);

                $an = amort_nbre_jour_ant($immo->date_acquisition, $amort_date, $amort_sur) * amort_journalier($immo->montant, $immo->periode);
                if ($an >= $montant) {
                    $ant = $montant;
                } else if ($an < 0) {
                    $ant = 0;
                } else {
                    $ant = $an;
                }

                $amr = amort_nbre_jour_amort($amort_date, $amort_sur) * amort_journalier($immo->montant, $immo->periode);
                if ($ant > $montant) {
                    $amort = $montant;
                } else if (($montant - $ant) < $amr) {
                    $amort = ($montant - $ant);
                } else if ($amr < 0) {
                    $amort = 0;
                } else {
                    $amort = $amr;
                }

                $v_r = $montant - $ant - $amort;
                $val_res = ($montant >= $v_r) ? $v_r : 0;

                $data2['date_acq'] = $immo->date_acquisition;
                $data2['libelle']  = $immo->intitule;
                $data2['montant']  = round(floatval($immo->montant), 2);
                $data2['ant']      = $ant;
                $data2['amort']    = $amort;
                $data2['val_res']  = $val_res;
                $data2['periode']    = $immo->periode;

                $total_montant += round(floatval($immo->montant), 2);
                $total_ant     += $ant;
                $total_amort   += $amort;
                $total_val_res += $val_res;

                array_push($dico_detail, $data2);
            endforeach;

            $data1['t_montant'] = $total_montant;
            $data1['t_ant']     = $total_ant;
            $data1['t_amort']   = $total_amort;
            $data1['t_val_res'] = $total_val_res;
            $data1['detail']  = $dico_detail;

            array_push($dico_immo, $data1);
        endforeach;

        return $dico_immo;
    }
}

if (!function_exists('CheckIf')) {

    function CheckIf($compte)
    {
        return  DB::table('cpt_tbl_compte_comptable')
            ->where('id_app', get_id_app())
            ->where('num_compte', $compte)
            ->where('is_parent', 1)
            ->select('id')
            ->first();
    }
}


if (!function_exists('getCurrentExercice')) {
    function getCurrentExercice()
    {
        return Exercices::where('id_app', get_id_app())
            ->where('exercice', getExercice())
            ->select('id', 'exercice', 'start_date', 'end_date', 'is_closed')
            ->first();
    }
}

if (!function_exists('getLastOpenExercice')) {
    function getLastOpenExercice()
    {
        $id = Exercices::where('id_app', get_id_app())
            ->where('is_closed', 0)
            ->max('id');
        if ($id) {
            return Exercices::where('id_app', get_id_app())
                ->where('id', $id)
                ->select('exercice')
                ->first()->exercice;
        }

        return null;
    }
}

if (!function_exists('getCompteComptable')) {
    function getCompteComptable()
    {
        return CompteComptable::where('id_app', get_id_app())
            ->select('num_compte')
            ->first();
    }
}

if (!function_exists('getExercice_n_1')) {
    function getExercice_n_1()
    {
        return intval(getExercice()) - 1;
    }
}


/**
 *! Partie Dictionnaire Etat Financier
 */

if (!function_exists('Balance_dico')) {
    function Balance_dico($data, $date_start, $date_end, $toPrint = false)
    {

        /**
         * toPrint is true for Etat financier UI and PDF
         * toPrint is false when Cloture Exercice
         */

        $dico = array();
        $classe1 = array();
        $classe2 = array();
        $classe3 = array();
        $classe4 = array();
        $classe5 = array();
        $classe6 = array();
        $classe7 = array();
        $classe8 = array();
        $tours = array();

        $Cl1 = [
            'compte'   => '',
            'intitule' => 'CLASSE 1',
            'soldeInitial' => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ],
            'variations' => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ],
            'solde'  => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ]
        ];
        $Cl2 = [
            'compte'   => '',
            'intitule' => 'CLASSE 2',
            'soldeInitial' => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ],
            'variations' => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ],
            'solde'  => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ]
        ];
        $Cl3 = [
            'compte'   => '',
            'intitule' => 'CLASSE 3',
            'soldeInitial' => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ],
            'variations' => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ],
            'solde'  => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ]
        ];
        $Cl4 = [
            'compte'   => '',
            'intitule' => 'CLASSE 4',
            'soldeInitial' => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ],
            'variations' => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ],
            'solde'  => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ]
        ];
        $Cl5 = [
            'compte'   => '',
            'intitule' => 'CLASSE 5',
            'soldeInitial' => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ],
            'variations' => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ],
            'solde'  => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ]
        ];
        $Cl6 = [
            'compte'   => '',
            'intitule' => 'CLASSE 6',
            'soldeInitial' => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ],
            'variations' => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ],
            'solde'  => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ]
        ];
        $Cl7 = [
            'compte'   => '',
            'intitule' => 'CLASSE 7',
            'soldeInitial' => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ],
            'variations' => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ],
            'solde'  => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ]
        ];
        $Cl8 = [
            'compte'   => '',
            'intitule' => 'CLASSE 8',
            'soldeInitial' => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ],
            'variations' => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ],
            'solde'  => [
                'debit'  => 0,
                'credit' => 0,
                'debit_true' => 0,
                'credit_true' => 0,
            ]
        ];


        foreach ($data as $info) :

            //$array = array();
            $init_debit = 0;
            $init_credit = 0;
            $variation_debit = 0;
            $variation_credit = 0;
            $solde_debit = 0;
            $solde_credit = 0;

            /**
             * Colonne Solde Initial
             */
            $soldeInitial = get_soldeInitial($info->compte, $date_end);
            $showSoldeInitial = showSolde($soldeInitial, $info->type_compte);


            if ($showSoldeInitial['soldeDebit']) {
                $init_debit = $soldeInitial;
            }

            if ($showSoldeInitial['soldeCredit']) {
                $init_credit = $soldeInitial;
            }


            /**
             * Colonne Variations
             */
            $variations = get_variations_of_compte($info->compte, $date_start, $date_end);
            $variation_debit = $variations->debit;
            $variation_credit = $variations->credit;


            /**
             * Colonne Solde
             */

            if ($info->is_parent == 1) {
                $solde = get_soldes($info->compte, $info->type_compte, $date_end);
            } else {
                $solde = get_solde($info->compte, $info->type_compte, $date_end);
            }

            $showSolde = showSolde(($solde), $info->type_compte);

            if ($showSolde['soldeDebit']) {
                $solde_debit = abs($solde);
            }

            if ($showSolde['soldeCredit']) {
                $solde_credit = abs($solde);
            }

            $Classe = substr($info->compte, 0, 1);
            array_push($tours, $Classe);

            $array = [
                'compte'   => $info->compte,
                'intitule' => $info->nom_compte,
                'soldeInitial' => [
                    'debit'  => $showSoldeInitial['soldeDebit'],
                    'credit' => $showSoldeInitial['soldeCredit'],
                    'debit_true' => $init_debit,
                    'credit_true' => $init_credit,
                ],
                'variations' => [
                    'debit'  => $variations->debit,
                    'credit' => $variations->credit,
                    'debit_true' => $variation_debit,
                    'credit_true' => $variation_credit,
                ],
                'solde'  => [
                    'debit'  => $showSolde['soldeDebit'],
                    'credit' => $showSolde['soldeCredit'],
                    'debit_true' => $solde_debit,
                    'credit_true' => $solde_credit,
                ]
            ];
            /**
             * Traitement des Tableaux par Classe
             */
            if ($toPrint) {
                switch ($Classe) {
                    case '1':
                        array_push($classe1, $array);
                        $Cl1['soldeInitial']['debit'] += intval($init_debit);
                        $Cl1['soldeInitial']['credit'] += intval($solde_credit);
                        $Cl1['variations']['debit'] += $variations->debit;
                        $Cl1['variations']['credit'] += $variations->credit;
                        $Cl1['solde']['debit']  += intval($solde_debit);
                        $Cl1['solde']['credit']  += intval($solde_credit);

                        break;
                    case '2':
                        array_push($classe2, $array);
                        $Cl2['soldeInitial']['debit'] += intval($init_debit);
                        $Cl2['soldeInitial']['credit'] += intval($solde_credit);
                        $Cl2['variations']['debit'] += $variations->debit;
                        $Cl2['variations']['credit'] += $variations->credit;
                        $Cl2['solde']['debit']  += intval($solde_debit);
                        $Cl2['solde']['credit']  += intval($solde_credit);
                        break;
                    case '3':
                        array_push($classe3, $array);
                        $Cl3['soldeInitial']['debit'] += intval($init_debit);
                        $Cl3['soldeInitial']['credit'] += intval($solde_credit);
                        $Cl3['variations']['debit'] += $variations->debit;
                        $Cl3['variations']['credit'] += $variations->credit;
                        $Cl3['solde']['debit']  += intval($solde_debit);
                        $Cl3['solde']['credit']  += intval($solde_credit);
                        break;
                    case '4':
                        array_push($classe4, $array);
                        $Cl4['soldeInitial']['debit'] += intval($init_debit);
                        $Cl4['soldeInitial']['credit'] += intval($solde_credit);
                        $Cl4['variations']['debit'] += $variations->debit;
                        $Cl4['variations']['credit'] += $variations->credit;
                        $Cl4['solde']['debit']  += intval($solde_debit);
                        $Cl4['solde']['credit']  += intval($solde_credit);
                        break;
                    case '5':
                        array_push($classe5, $array);
                        $Cl5['soldeInitial']['debit'] += intval($init_debit);
                        $Cl5['soldeInitial']['credit'] += intval($solde_credit);
                        $Cl5['variations']['debit'] += $variations->debit;
                        $Cl5['variations']['credit'] += $variations->credit;
                        $Cl5['solde']['debit']  += intval($solde_debit);
                        $Cl5['solde']['credit']  += intval($solde_credit);
                        break;
                    case '6':
                        array_push($classe6, $array);
                        $Cl6['soldeInitial']['debit'] += intval($init_debit);
                        $Cl6['soldeInitial']['credit'] += intval($solde_credit);
                        $Cl6['variations']['debit'] += $variations->debit;
                        $Cl6['variations']['credit'] += $variations->credit;
                        $Cl6['solde']['debit']  += intval($solde_debit);
                        $Cl6['solde']['credit']  += intval($solde_credit);
                        break;
                    case '7':
                        array_push($classe7, $array);
                        $Cl7['soldeInitial']['debit'] += intval($init_debit);
                        $Cl7['soldeInitial']['credit'] += intval($solde_credit);
                        $Cl7['variations']['debit'] += $variations->debit;
                        $Cl7['variations']['credit'] += $variations->credit;
                        $Cl7['solde']['debit']  += intval($solde_debit);
                        $Cl7['solde']['credit']  += intval($solde_credit);
                        break;
                    case '8':
                        array_push($classe8, $array);
                        $Cl8['soldeInitial']['debit'] += intval($init_debit);
                        $Cl8['soldeInitial']['credit'] += intval($solde_credit);
                        $Cl8['variations']['debit'] += $variations->debit;
                        $Cl8['variations']['credit'] += $variations->credit;
                        $Cl8['solde']['debit']  += intval($solde_debit);
                        $Cl8['solde']['credit']  += intval($solde_credit);
                        break;
                    default:
                        # code...
                        break;
                }
            }
            array_push($dico, $array);
        endforeach;


        if ($toPrint) {
            $tour = array_unique($tours);
            //for ($i = 1; $i <= 8; $i++) {
            foreach ($tour as $i):
                // insert element at beginning of array
                array_unshift(${"classe" . $i}, ${"Cl" . $i});
            endforeach;
            //}

            $return = array_merge(
                $classe1,
                $classe2,
                $classe3,
                $classe4,
                $classe5,
                $classe6,
                $classe7,
                $classe8
            );

            return $return;
        }

        return $dico;
    }
}

if (!function_exists('Resultat_dico')) {
    function Resultat_dico($data, $date_start, $date_end)
    {

        $dico = array();
        $dictionaire = array();

        foreach ($data as $info) :

            $amount = 0;

            if ($info->code_poste === 'xa') {
                $amount = abs($dictionaire['ta']) - abs($dictionaire['ra']) + $dictionaire['rb'];
            } elseif ($info->code_poste === 'xb') {
                $amount = abs($dictionaire['ta']) + abs($dictionaire['tb']) + abs($dictionaire['tc']) + abs($dictionaire['td']);
            } elseif ($info->code_poste === 'xc') {
                $amount = ($dictionaire['xb'] - abs($dictionaire['ra']) + $dictionaire['rb']) +
                    ($dictionaire['te'] + abs($dictionaire['tf']) + abs($dictionaire['tg']) + abs($dictionaire['th']) +
                        abs($dictionaire['ti']) - abs($dictionaire['rc']) + $dictionaire['rd'] - abs($dictionaire['re']) +
                        $dictionaire['rf'] - abs($dictionaire['rg']) - abs($dictionaire['rh']) - abs($dictionaire['ri']) -
                        abs($dictionaire['rj'])
                    );
            } elseif ($info->code_poste === 'xd') {
                $amount =  $dictionaire['xc'] - abs($dictionaire['rk']);
            } elseif ($info->code_poste === 'xe') {
                $amount =  $dictionaire['xd'] + abs($dictionaire['tj']) - abs($dictionaire['rl']);
            } elseif ($info->code_poste === 'xf') {
                $amount =  abs($dictionaire['tk']) + abs($dictionaire['tl']) + abs($dictionaire['tm']) -
                    abs($dictionaire['rm']) - abs($dictionaire['rn']);
            } elseif ($info->code_poste === 'xg') {
                $amount =  $dictionaire['xe'] + $dictionaire['xf'];
            } elseif ($info->code_poste === 'xh') {
                $amount =  abs($dictionaire['tn']) + abs($dictionaire['to']) -
                    abs($dictionaire['ro']) - abs($dictionaire['rp']);
            } elseif ($info->code_poste === 'xi') {
                $amount =  $dictionaire['xg'] + $dictionaire['xh'] -
                    abs($dictionaire['rq']) - abs($dictionaire['rs']);
            } else {

                $mounts = get_Compte_by_poste($info->code_poste);

                foreach ($mounts as $mount):
                    $amount += get_solde($mount->num_compte, $mount->type_compte, $date_end);
                endforeach;
            }

            $dictionaire[$info->code_poste] = $amount;

            if ($info->is_gestion == 1) {
                $bgColor = "#e3eae9";
                $textColor = "";
            } elseif ($info->is_gestion == 2) {
                $bgColor = "black";
                $textColor = "white";
            } else {
                $bgColor = "";
                $textColor = "";
            }

            $array = [
                'poste'      => $info->code_poste,
                'intitule'   => $info->intitule,
                'operation'      => $info->operation,
                'note'       => $info->note,
                'exercice_n' => $amount,
                'exercice_n1' => get_solde_of_poste_by_exercice(
                    getExercice_n_1(),
                    $info->code_poste
                ),
                'bgColor'   => $bgColor,
                'textColor' => $textColor
            ];

            array_push($dico, $array);
        endforeach;

        return $dico;
    }
}


if (!function_exists('Bilan_dico')) {
    function Bilan_dico($data, $date_start, $date_end)
    {

        $dico = array();
        $dict_a = array();
        $dict_p = array();
        $dictionaire_actif = array();
        $dictionaire_passif = array();

        /**
         * Partie Actif
         */

        $array_ad = array();
        $array_ai = array();
        $array_aq = array();
        $array_ap = array();
        $array_az = array();
        $array_ba_bb = array();
        $array_bk = array();
        $array_bg = array();
        $array_bt = array();

        $poste_AD = [
            'poste'   => '',
            'intitule' => '',
            'note' => '',
            'exercice_n' => [
                'brut'  => 0,
                'amort' => 0,
                'net' => 0,
            ],
            'exercice_n1' => 0,
            'bgColor'   => '',
            'textColor' => '',
        ];
        $poste_AI = [
            'poste'   => '',
            'intitule' => '',
            'note' => '',
            'exercice_n' => [
                'brut'  => 0,
                'amort' => 0,
                'net' => 0,
            ],
            'exercice_n1' => 0,
            'bgColor'   => '',
            'textColor' => '',
        ];
        $poste_AP = [
            'poste'   => '',
            'intitule' => '',
            'note' => '',
            'exercice_n' => [
                'brut'  => 0,
                'amort' => 0,
                'net' => 0,
            ],
            'exercice_n1' => 0,
            'bgColor'   => '',
            'textColor' => '',
        ];

        $poste_AQ = [
            'poste'   => '',
            'intitule' => '',
            'note' => '',
            'exercice_n' => [
                'brut'  => 0,
                'amort' => 0,
                'net' => 0,
            ],
            'exercice_n1' => 0,
            'bgColor'   => '',
            'textColor' => '',
        ];
        $poste_AZ = [
            'poste'   => '',
            'intitule' => '',
            'note' => '',
            'exercice_n' => [
                'brut'  => 0,
                'amort' => 0,
                'net' => 0,
            ],
            'exercice_n1' => 0,
            'bgColor'   => '',
            'textColor' => '',
        ];

        $poste_BG = [
            'poste'   => '',
            'intitule' => '',
            'note' => '',
            'exercice_n' => [
                'brut'  => 0,
                'amort' => 0,
                'net' => 0,
            ],
            'exercice_n1' => 0,
            'bgColor'   => '',
            'textColor' => '',
        ];

        $poste_BT = [
            'poste'   => '',
            'intitule' => '',
            'note' => '',
            'exercice_n' => [
                'brut'  => 0,
                'amort' => 0,
                'net' => 0,
            ],
            'exercice_n1' => 0,
            'bgColor'   => '',
            'textColor' => '',
        ];
        $poste_BU = [
            'poste'   => '',
            'intitule' => '',
            'note' => '',
            'exercice_n' => [
                'brut'  => 0,
                'amort' => 0,
                'net' => 0,
            ],
            'exercice_n1' => 0,
            'bgColor'   => '',
            'textColor' => '',
        ];





        foreach ($data as $info) :

            $amount_brut  = 0;
            $amount_amort = 0;
            $amount_net   = 0;

            if ($info->is_gestion == 1) {
                $bgColor = "#e3eae9";
                $textColor = "";
            } elseif ($info->is_gestion == 2) {
                $bgColor = "black";
                $textColor = "white";
            } else {
                $bgColor = "";
                $textColor = "";
            }

            if (
                $info->code_poste <> 'ad' && $info->code_poste <> 'ai' && $info->code_poste <> 'aq' &&
                $info->code_poste <> 'az' &&  $info->code_poste <> 'bg' && $info->code_poste <>  'bk' && $info->code_poste <> 'bt' &&
                $info->code_poste <> 'bz'
            ) {
                /** 
                 * get Amount Brut 
                 * **/

                $mounts_brut = get_Compte_by_poste_Actif($info->code_poste, 0);

                foreach ($mounts_brut as $mount):
                    $amount_brut += get_solde($mount->num_compte, $mount->type_compte, $date_end);
                endforeach;
                /** 
                 * get Amount Amortissment 
                 * **/
                $mounts_amort = get_Compte_by_poste_Actif($info->code_poste, 1);

                foreach ($mounts_amort as $mount):
                    $amount_amort += get_solde($mount->num_compte, $mount->type_compte, $date_end);
                endforeach;

                /** 
                 * get Amount Net 
                 * **/
                $amount_net = $amount_brut - $amount_amort;


                $array = [
                    'poste'      => $info->code_poste,
                    'intitule'   => $info->intitule,
                    'note'       => $info->note,
                    'exercice_n' => [
                        'brut'  => $amount_brut,
                        'amort' => $amount_amort,
                        'net'   => $amount_net,
                    ],
                    'exercice_n1' => get_solde_of_poste_by_exercice(
                        getExercice_n_1(),
                        $info->code_poste
                    ),
                    'bgColor'   => $bgColor,
                    'textColor' => $textColor
                ];
            }



            if ($info->code_poste === 'ad') {

                $poste_AD['poste'] = $info->code_poste;
                $poste_AD['intitule'] = $info->intitule;
                $poste_AD['note'] = $info->note;
                $poste_AD['exercice_n1'] = get_solde_of_poste_by_exercice(
                    getExercice_n_1(),
                    $info->code_poste
                );
                $poste_AD['bgColor'] = $bgColor;
                $poste_AD['textColor'] = $textColor;
            } elseif (
                $info->code_poste === 'ae' || $info->code_poste === 'af' ||
                $info->code_poste === 'ag' || $info->code_poste === 'ah'
            ) {

                $poste_AD['exercice_n']['brut']  += $amount_brut;
                $poste_AD['exercice_n']['amort'] += $amount_amort;
                $poste_AD['exercice_n']['net']   += $amount_net;
                array_push($array_ad, $array);
            } elseif ($info->code_poste === 'ai') {

                $poste_AI['poste'] = $info->code_poste;
                $poste_AI['intitule'] = $info->intitule;
                $poste_AI['note'] = $info->note;
                $poste_AI['exercice_n1'] = get_solde_of_poste_by_exercice(
                    getExercice_n_1(),
                    $info->code_poste
                );
                $poste_AI['bgColor'] = $bgColor;
                $poste_AI['textColor'] = $textColor;
            } elseif (
                $info->code_poste === 'aj' || $info->code_poste === 'ak' ||
                $info->code_poste === 'al' || $info->code_poste === 'am' ||
                $info->code_poste === 'an'
            ) {

                $poste_AI['exercice_n']['brut']  += $amount_brut;
                $poste_AI['exercice_n']['amort'] += $amount_amort;
                $poste_AI['exercice_n']['net']   += $amount_net;
                array_push($array_ai, $array);
            } elseif ($info->code_poste === 'ap') {

                $poste_AP['poste'] = $info->code_poste;
                $poste_AP['intitule'] = $info->intitule;
                $poste_AP['note'] = $info->note;
                $poste_AP['exercice_n']['brut']  += $amount_brut;
                $poste_AP['exercice_n']['amort'] += $amount_amort;
                $poste_AP['exercice_n']['net']   += $amount_net;
                $poste_AP['exercice_n1'] = get_solde_of_poste_by_exercice(
                    getExercice_n_1(),
                    $info->code_poste
                );
                $poste_AP['bgColor'] = $bgColor;
                $poste_AP['textColor'] = $textColor;

                array_push($array_ap, $array);
            } elseif ($info->code_poste === 'aq') {

                $poste_AQ['poste'] = $info->code_poste;
                $poste_AQ['intitule'] = $info->intitule;
                $poste_AQ['note'] = $info->note;
                $poste_AQ['exercice_n1'] = get_solde_of_poste_by_exercice(
                    getExercice_n_1(),
                    $info->code_poste
                );
                $poste_AQ['bgColor'] = $bgColor;
                $poste_AQ['textColor'] = $textColor;
            } elseif ($info->code_poste === 'ar' || $info->code_poste === 'as') {

                $poste_AQ['exercice_n']['brut']  += $amount_brut;
                $poste_AQ['exercice_n']['amort'] += $amount_amort;
                $poste_AQ['exercice_n']['net']   += $amount_net;
                array_push($array_aq, $array);
            } elseif ($info->code_poste === 'az') {

                //  dd($poste_AD);

                $poste_AZ['poste'] = $info->code_poste;
                $poste_AZ['intitule'] = $info->intitule;
                $poste_AZ['note'] = $info->note;
                $poste_AZ['exercice_n1'] = get_solde_of_poste_by_exercice(
                    getExercice_n_1(),
                    $info->code_poste
                );
                $poste_AZ['bgColor'] = $bgColor;
                $poste_AZ['textColor'] = $textColor;

                $poste_AZ['exercice_n']['brut']  += $poste_AD['exercice_n']['brut'] + $poste_AI['exercice_n']['brut'] +
                    $poste_AP['exercice_n']['brut'] + $poste_AQ['exercice_n']['brut'];
                $poste_AZ['exercice_n']['amort'] += $poste_AD['exercice_n']['amort'] + $poste_AI['exercice_n']['amort'] +
                    $poste_AP['exercice_n']['amort'] + $poste_AQ['exercice_n']['amort'];
                $poste_AZ['exercice_n']['net']   += $poste_AD['exercice_n']['net'] + $poste_AI['exercice_n']['net'] +
                    $poste_AP['exercice_n']['net'] + $poste_AQ['exercice_n']['net'];
                array_push($array_az, $poste_AZ);
            } elseif ($info->code_poste === 'ba' || $info->code_poste === 'bb') {
                array_push($array_ba_bb, $array);
            } elseif ($info->code_poste === 'bg') {

                // dd($dictionaire_actif);

                $poste_BG['poste'] = $info->code_poste;
                $poste_BG['intitule'] = $info->intitule;
                $poste_BG['note'] = $info->note;
                $poste_BG['exercice_n1'] = get_solde_of_poste_by_exercice(
                    getExercice_n_1(),
                    $info->code_poste
                );
                $poste_BG['bgColor'] = $bgColor;
                $poste_BG['textColor'] = $textColor;
                //array_push($array_bg , $poste_BG);

            } elseif (
                $info->code_poste === 'bh' || $info->code_poste === 'bi' ||
                $info->code_poste === 'bj'
            ) {

                $poste_BG['exercice_n']['brut']  += $amount_brut;
                $poste_BG['exercice_n']['amort'] += $amount_amort;
                $poste_BG['exercice_n']['net']   += $amount_net;

                array_push($array_bg, $array);
            } elseif ($info->code_poste === 'bk') {

                $array = [
                    'poste'      => $info->code_poste,
                    'intitule'   => $info->intitule,
                    'note'       => $info->note,
                    'exercice_n' => [
                        'brut'  => $array_ba_bb[0]['exercice_n']['brut'] +
                            $array_ba_bb[1]['exercice_n']['brut'] + $poste_BG['exercice_n']['brut'],

                        'amort' => $array_ba_bb[0]['exercice_n']['amort'] +
                            $array_ba_bb[1]['exercice_n']['amort'] + $poste_BG['exercice_n']['amort'],

                        'net'   => $array_ba_bb[0]['exercice_n']['net'] +
                            $array_ba_bb[1]['exercice_n']['net'] + $poste_BG['exercice_n']['net'],
                    ],
                    'exercice_n1' => get_solde_of_poste_by_exercice(
                        getExercice_n_1(),
                        $info->code_poste
                    ),
                    'bgColor'   => $bgColor,
                    'textColor' => $textColor
                ];

                array_push($array_bk, $array);
            } elseif (
                $info->code_poste === 'bq' || $info->code_poste === 'br' ||
                $info->code_poste === 'bs'
            ) {

                $poste_BT['exercice_n']['brut']  += $amount_brut;
                $poste_BT['exercice_n']['amort'] += $amount_amort;
                $poste_BT['exercice_n']['net']   += $amount_net;

                array_push($array_bt, $array);
            } elseif ($info->code_poste === 'bt') {

                $poste_BT['poste'] = $info->code_poste;
                $poste_BT['intitule'] = $info->intitule;
                $poste_BT['note'] = $info->note;

                $poste_BT['exercice_n1'] = get_solde_of_poste_by_exercice(
                    getExercice_n_1(),
                    $info->code_poste
                );
                $poste_BT['bgColor'] = $bgColor;
                $poste_BT['textColor'] = $textColor;

                array_push($array_bt, $poste_BT);
            } elseif ($info->code_poste === 'bu') {

                $poste_BU['poste'] = $info->code_poste;
                $poste_BU['intitule'] = $info->intitule;
                $poste_BU['note'] = $info->note;
                $poste_BU['exercice_n']['brut'] = $amount_brut;
                $poste_BU['exercice_n']['amort'] = $amount_amort;
                $poste_BU['exercice_n']['net'] = $amount_net;
                $poste_BU['exercice_n1'] = get_solde_of_poste_by_exercice(
                    getExercice_n_1(),
                    $info->code_poste
                );
                $poste_BU['bgColor'] = $bgColor;
                $poste_BU['textColor'] = $textColor;

                array_push($dictionaire_actif, $poste_BU);
            } elseif ($info->code_poste === 'bz') {

                $array = [
                    'poste'      => $info->code_poste,
                    'intitule'   => $info->intitule,
                    'note'       => $info->note,
                    'exercice_n' => [
                        'brut'  => $poste_AZ['exercice_n']['brut'] + $array_bk[0]['exercice_n']['brut'] +
                            $poste_BT['exercice_n']['brut'] + $poste_BU['exercice_n']['brut'],
                        'amort' => $poste_AZ['exercice_n']['amort'] + $array_bk[0]['exercice_n']['amort'] +
                            $poste_BT['exercice_n']['amort'] + $poste_BU['exercice_n']['amort'],
                        'net'   => $poste_AZ['exercice_n']['net'] + $array_bk[0]['exercice_n']['net'] +
                            $poste_BT['exercice_n']['net'] + $poste_BU['exercice_n']['net'],
                    ],
                    'exercice_n1' => get_solde_of_poste_by_exercice(
                        getExercice_n_1(),
                        $info->code_poste
                    ),
                    'bgColor'   => $bgColor,
                    'textColor' => $textColor
                ];
                array_push($dictionaire_actif, $array);
            } else {

                // dd($info->code_poste);
                array_push($dictionaire_actif, $array);
            }


        endforeach;


        array_unshift($array_ad, $poste_AD);
        array_unshift($array_ai, $poste_AI);
        array_unshift($array_aq, $poste_AQ);
        array_unshift($array_bg, $poste_BG);

        // dd($dictionaire_actif);
        $dict_a = array_merge(
            $array_ad,
            $array_ai,
            $array_ap,
            $array_aq,
            $array_az,
            $array_ba_bb,
            $array_bg,
            $array_bk,
            $array_bt,
            $dictionaire_actif


        );

        //return $return;

        //  dd($return);

        /**
         * Partie Passif
         */
        foreach (Bilan('passif') as $info) :

            $amount = 0;

            if ($info->code_poste === 'cp') {
                $amount  =  $dictionaire_passif['ca'] + $dictionaire_passif['cb'] + $dictionaire_passif['cd'] +
                    $dictionaire_passif['ce'] + $dictionaire_passif['cf'] + $dictionaire_passif['cg'] -
                    $dictionaire_passif['ch'] + $dictionaire_passif['cj'] + $dictionaire_passif['cl'] +
                    $dictionaire_passif['cm'];
            } elseif ($info->code_poste === 'dd') {
                $amount  =  $dictionaire_passif['da'] + $dictionaire_passif['db'] + $dictionaire_passif['dc'];
            } elseif ($info->code_poste === 'df') {
                $amount  =  $dictionaire_passif['cp'] + $dictionaire_passif['dd'];
            } elseif ($info->code_poste === 'dp') {
                $amount  =  $dictionaire_passif['dh'] + $dictionaire_passif['di'] + $dictionaire_passif['dj'] +
                    $dictionaire_passif['dk'] + $dictionaire_passif['dm'] + $dictionaire_passif['dn'];
            } elseif ($info->code_poste === 'dt') {
                $amount  =  $dictionaire_passif['dq'] + $dictionaire_passif['dr'];
            } elseif ($info->code_poste === 'dz') {
                $amount  =  $dictionaire_passif['df'] + $dictionaire_passif['dp'] +
                    $dictionaire_passif['dt'] + $dictionaire_passif['dv'];
            } else {

                $mounts = get_Compte_by_poste($info->code_poste);
                //$array = array();

                foreach ($mounts as $mount):
                    //$p = 0 ;
                    if ($mount->is_parent == 1) {
                        $amount += get_soldes($mount->num_compte, $mount->type_compte, $date_end);
                    } else {
                        if ($info->code_poste === 'dk' && $mount->type_compte === 'debit') {
                            $amount += 0;
                        } elseif ($info->code_poste === 'dr' && $mount->type_compte === 'debit') {
                            $amount += 0;
                        } else {
                            $amount += get_solde($mount->num_compte, $mount->type_compte, $date_end);
                        }
                        /*$a = array('compte' => $mount->num_compte , 'solde' => $p,'type' => $mount->type_compte);
                            array_push($array , $a);*/
                    }

                endforeach;
            }

            /**
             * Traitement de poste cj - resultat Net
             */
            if ($info->code_poste === 'cj') {
                if ($amount == 0) {
                    $amount = CalculResultatNet($date_end);
                }
            }
            $dictionaire_passif[$info->code_poste] = $amount;

            if ($info->is_gestion == 1) {
                $bgColor = "#e3eae9";
                $textColor = "";
            } elseif ($info->is_gestion == 2) {
                $bgColor = "black";
                $textColor = "white";
            } else {
                $bgColor = "";
                $textColor = "";
            }


            $array = [
                'poste'      => $info->code_poste,
                'intitule'   => $info->intitule,
                'note'       => $info->note,
                'exercice_n' => $amount,
                'exercice_n1' => get_solde_of_poste_by_exercice(
                    getExercice_n_1(),
                    $info->code_poste
                ),
                'bgColor'   => $bgColor,
                'textColor' => $textColor
            ];

            array_push($dict_p, $array);
        endforeach;

        $dico['actif']  = $dict_a;
        $dico['passif'] = $dict_p;
        return $dico;
    }
}

if (!function_exists('get_poste_bilan_for_test')) {
    function get_poste_bilan_for_test()
    {
        $array = array();

        $p_actif = 'ad';
        $p_passif = 'ca';
        $r1 = [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];

        $p_actif = 'ae';
        $p_passif = 'cb';
        $r2 =  [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];


        $p_actif = 'ah';
        $p_passif = 'cf';
        $r3 = [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];

        $p_actif = 'ai';
        $p_passif = 'cg';
        $r4 =  [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];
        $p_actif = 'aj';
        $p_passif = 'ch';
        $r5 = [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];

        $p_actif = 'ak';
        $p_passif = 'cj';
        $r6 =  [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];
        $p_actif = 'al';
        $p_passif = 'cl';
        $r7 = [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];

        $p_actif = 'am';
        $p_passif = 'cm';
        $r8 =  [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];
        $p_actif = 'an';
        $p_passif = 'cp';
        $r9 = [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];

        $p_actif = 'ap';
        $p_passif = 'da';
        $r10 =  [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];
        $p_actif = 'aq';
        $p_passif = 'db';
        $r11 = [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];

        $p_actif = 'ar';
        $p_passif = 'dc';
        $r12 =  [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];
        $p_actif = 'as';
        $p_passif = 'dd';
        $r13 = [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];

        $p_actif = 'az';
        $p_passif = 'df';
        $r14 =  [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];
        $p_actif = 'ba';
        $p_passif = 'dh';
        $r15 = [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];

        $p_actif = 'bb';
        $p_passif = 'di';
        $r16 =  [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];
        $p_actif = 'bg';
        $p_passif = 'dj';
        $r17 = [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];

        $p_actif = 'bh';
        $p_passif = 'dk';
        $r18 =  [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];
        $p_actif = 'bi';
        $p_passif = 'dm';
        $r19 = [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];

        $p_actif = 'bj';
        $p_passif = 'dn';
        $r20 =  [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];
        $p_actif = 'bk';
        $p_passif = 'dp';
        $r21 = [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];

        $p_actif = 'bq';
        $p_passif = '';
        $r22 =  [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];


        $p_actif = 'br';
        $p_passif = 'dq';
        $r23 =  [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];
        $p_actif = 'bs';
        $p_passif = 'dr';
        $r24 = [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];

        $p_actif = 'bt';
        $p_passif = 'dt';
        $r25 =  [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];
        $p_actif = 'bu';
        $p_passif = 'dv';
        $r26 = [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];

        $p_actif = 'bz';
        $p_passif = 'dz';
        $r27 =  [[
            'poste_actif' => $p_actif,
            'brut' => get_Compte_by_poste_Actif_TEST($p_actif, 0),
            'amort' => get_Compte_by_poste_Actif_TEST($p_actif, 1),
            'Execep_actif' => get_poste_Exception_TEST($p_actif),
            'poste_passif' => $p_passif,
            'compt_passif' => get_Compte_by_poste_TEST($p_passif),
            'Execep_passif' => get_poste_Exception_TEST($p_passif)
        ]];



        $dict_a = array_merge(
            $r1,
            $r2,
            $r3,
            $r4,
            $r5,
            $r6,
            $r7,
            $r8,
            $r9,
            $r10,
            $r11,
            $r12,
            $r13,
            $r14,
            $r15,
            $r16,
            $r17,
            $r18,
            $r19,
            $r20,
            $r21,
            $r22,
            $r23,
            $r24,
            $r25,
            $r26,
            $r27
        );

        return $dict_a;
    }
}
