<?php

namespace App\Rules;

use App\Models\Society;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class MaxCompte implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {   
        $number = Society::find(get_id_app())->number_digit_compte ;
        $q = (strlen(trim($value)) <> $number )? true : false ;
        
        if($q){
            $fail($number.' caractères attendus');
        }
    }
}
