<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Support\Facades\DB;

class DateBetweenExercice implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $q = DB::select('SELECT `id` FROM `cpt_tbl_exercice` 
                        WHERE `is_closed` = 0 AND `exercice` = :exercice AND `id_app` = :id_app  AND :date_ BETWEEN `start_date` AND `end_date` ', 
                        [
                        'date_' => $value ,
                        'exercice' => getExercice(),
                        'id_app'    => get_id_app()
                        ]
                );
        if(!$q)
        {
            $fail('date hors Exercice'); 
        }
        
    }
}
