<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class CheckExerciceYear implements ValidationRule
{   
    public $dateStart ;

    public function __construct($dateStart)
    {
        $this->dateStart = $dateStart;
    }
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $d_debut = \Carbon\Carbon::parse($this->dateStart)->format('Y') ;
        $d_fin = \Carbon\Carbon::parse($value)->format('Y') ;

        if($d_debut <> $d_fin)
        {
            $fail('L\'exercice doit être une année');
        }
    }
}
