<?php

namespace App\Rules;


use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Support\Facades\DB;

class CheckCompteTiersExist implements ValidationRule
{   

    public $tiers_id;

    public function __construct($id)
    {
        $this->tiers_id = $id;
    }


    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $string = mb_substr(trim($value),0,2) ; 
        $q = DB::table('cpt_tbl_compte_tiers')
            ->where(['id_app' => get_id_app() ,'id_tiers' => $this->tiers_id ])
            ->where('compte','like', $string.'%')
            ->select('id')
            ->first() ;

        if($q){
            $fail('Compte '.$string.'xxxxxx existe déjà');
        }
    }
}
