<?php

namespace App\Rules;

use App\Models\CloturePeriode;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class CheckCloturePeriode implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $q = CloturePeriode::where([
                    'id_app'   => get_id_app(),
                    'exercice' => getExercice(),
                    ])
                    ->where('date_valeur','>=',$value)
                    ->select('id','date_valeur')
                    ->first();  
        if($q){
          $fail('Clôture pér. '. $q->date_valeur);
        }
    }
}
