<?php

namespace App\Rules;

use App\Models\Exercices;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class CheckClotureExercice implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $q = Exercices::where([
            'id_app'   => get_id_app(),
            'exercice' => getExercice(),
            'is_closed' => 1
            ])
            ->select('id')
            ->first();  
        if($q){
        $fail('Exercice clôturé');
        }
    }
}
