<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Rens extends Model
{
    use HasFactory;

    protected $table = "t_rens";

    protected $fillable = [
        'type_rens',
        'numero_cible',
        'kyc_cible',
        'upload',
        'infraction',
        'description',
        'is_active',
        'user_crea'
    ];

    public function scopeSearch($query, $value)
    {
        $query->where('infraction', 'like', '%' . trim($value) . '%')
            ->orWhere('kyc_cible', 'like', '%' . trim($value) . '%')
            ->orWhere('numero_cible', 'like', '%' . trim($value) . '%')
            /* ->orWhere('adresse','like','%'.trim($value).'%')*/
            /* ->orWhere('ville','like','%'.trim($value).'%') */
            /* ->orWhere('pays','like','%'.trim($value).'%') */;
    }
}
