<?php

namespace App\Models\PlanComptable;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;


class ComptePrincipal extends Model
{
    use HasFactory;

    protected $table = "cpt_plan_2_compte_principal";
    public $timestamps = false ; 


    protected $fillable = [
        'code',
        'intitule',
        'type',
        'classe_id'
    ] ;


    public function classe(): BelongsTo
    {
        return $this->belongsTo(Classe::class);
    }

    public function compteDivisionnaires(): HasMany
    {
        return $this->hasMany(CompteDivisionnaire::class);
    }
}
