<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Link extends Model
{
    use HasFactory;
    protected $table = "t_links";

    protected $fillable = ['token', 'url', 'demande', 'expires_at'];

    protected $dates = ['expires_at'];

    public function isExpired()
    {
        return $this->expires_at->isPast();
    }
}
