<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Immobilisation extends Model
{
    use HasFactory;

    protected $table = "cpt_tbl_immobilisation";
    public $timestamps = false;

    protected $fillable = [
        'fk_num_compte',
        'intitule',
        'dependant_de',
        'date_acquisition',
        'montant',
        'devise',
        'fk_idworkday',
        'periode',
        'user_crea',
        'id_app'
    ];

    public function scopeSearch($query,$value){
        $query->where('intitule','like','%'.trim($value).'%')
            ->orWhere('fk_num_compte','like','%'.trim($value).'%') 
            ->orWhere('date_acquisition','like','%'.trim($value).'%')
            ->orWhere('montant','like','%'.trim($value).'%')
            ->orWhere('devise','like','%'.trim($value).'%')  ;
    }
}
