<?php

namespace App\Livewire;

use App\Rules\CompteExist;
use App\Rules\NumFactureExist;
use Livewire\Component;

class TresorerieCaisse extends Component
{   
    public $tab = null;
    public $tabname = "facture" ;
    protected $queryString = ['tab'] ;
    public $inputs ,$is_singulier , $reglement ;
   // private $regEx = "([0-9])";

    //**** Block Facture */
    public $idFacture , $idTiers ,$CompteCaisse_facture , $libelle_facture, $montant_facture, $devise_facture, $date_facture, $justification_facture , $CompteTiers;

    //**** Block Transactions Diverses  */
    public $CompteCaisse_td , $libelle_td, $montant_td, $devise_td, $date_td, $justification_td , $CompteTiers_td;

    // General Block *************************/
    public function selectTab($tab)
    {
        $this->tab = $tab ;
    }

    public function mount(){
        $this->tab = request()->tab ? request()->tab : $this->tabname ;
        $this->reglement    = "singulier" ;
        $this->is_singulier = true ;
        $this->devise_facture = get_main_devise();
        $this->devise_td = get_main_devise();

       
    }

    public function updatedReglement()
    {
        $this->is_singulier = !$this->is_singulier ;
    }

    public function saveTresoCaisseFactureSingulier()
    {
        //$this->validate([]);

       
            $this->validate([
                'idFacture' => ['required',new NumFactureExist],
                'CompteCaisse_facture' => ['required','string',new CompteExist],
                'libelle_facture' => ['required','string','min:3','max:100'],
                'montant_facture'=> ['required'],
                'devise_facture' => ['required','string'],
                'date_facture' => ['required','date','date_format:Y-m-d','before:tomorrow','after:2000-01-01'],
            ]) ;

            $resp =  save_Treso('TresoFacture',null,null,$this->CompteCaisse_facture,$this->idFacture,$this->date_facture,$this->libelle_facture,
            $this->montant_facture,$this->devise_facture,null,null);


        if($resp === 1)
        {   
            $this->resetForm_Facture();
            $this->showToastr('success|Enregistrement effectué avec succès');
        }else{
            $this->showToastr('failed|'.$resp); 
        }

    }
    
    public function saveTresoCaisseFactureGlobal($isEncaissement = false)
    {
            //
            $this->validate([
                'idTiers' => ['required','int'],
                'CompteTiers' => ['required','string',new CompteExist],
                'CompteCaisse_facture' => ['required','string',new CompteExist],
                'libelle_facture' => ['required','string','min:3','max:100'],
                'montant_facture'=> ['required'],
                'devise_facture' => ['required','string'],
                'date_facture' => ['required','date','date_format:Y-m-d','before:tomorrow','after:2000-01-01'],
            ]) ;

            $resp = save_Treso('TresoFacture',$this->idTiers,$this->CompteTiers,$this->CompteCaisse_facture,null,$this->date_facture,$this->libelle_facture,
            $this->montant_facture,$this->devise_facture,null,$isEncaissement);

            if($resp === 1)
            {   
                $this->resetForm_Facture();
                $this->showToastr('success|Enregistrement effectué avec succès');
            }else{
                $this->showToastr('failed|'.$resp); 
            }
    }


    public function saveTresoCaisseTD($isEncaissement = false)
    {
            //
            $this->validate([
                'CompteTiers_td' => ['required','string',new CompteExist],
                'CompteCaisse_td' => ['required','string',new CompteExist],
                'libelle_td' => ['required','string','min:3','max:100'],
                'montant_td'=> ['required'],
                'devise_td' => ['required','string'],
                'date_td' => ['required','date','date_format:Y-m-d','before:tomorrow','after:2000-01-01'],
            ]) ;

            $resp = save_Treso('TresoTD',null,$this->CompteTiers_td,$this->CompteCaisse_td,null,$this->date_td,$this->libelle_td,
            $this->montant_td,$this->devise_td,null,$isEncaissement);
            
            if($resp === 1)
            {   
                $this->resetForm_TD();
                $this->showToastr('success|Enregistrement effectué avec succès');
            }else{
                $this->showToastr('failed|'.$resp); 
            }
        
    }

    public function resetForm_Facture(){
        $this->idTiers =
        $this->idFacture =
        $this->CompteTiers  =
        $this->CompteCaisse_facture =
        $this->libelle_facture =  
        $this->montant_facture = 
        $this->date_facture = null;
       
        $this->devise_facture = get_main_devise();
    }

    public function resetForm_TD(){
        $this->CompteTiers_td  =
        $this->CompteCaisse_td =
        $this->libelle_td =  
        $this->montant_td = 
        $this->date_td = null;
       
        $this->devise_td = get_main_devise();
    }


    public function showToastr($message){
        return $this->dispatch('showToast',
           message : $message
        );
    }

 
    public function render()
    {   
       
        return view('livewire.tresorerie-caisse');
    }
}
