<?php

namespace App\Livewire;

use App\Rules\CheckTauxChangeByDate;
use App\Rules\CompteExist;
use App\Rules\NumFactureExist;
use Livewire\Component;

class TresorerieBanque extends Component
{   
    public $tab = null;
    public $tabname = "facture" ;
    protected $queryString = ['tab'] ;
    public $inputs ,$is_singulier , $reglement , $ListCompte_tiers ;
   // private $regEx = "([0-9])";

    //**** Block Facture */
    public $idFacture , $idTiers ,$CompteBanque_facture , $libelle_facture, $montant_facture, $devise_facture, $date_facture, $justification_facture , $CompteTiers;

    //**** Block Transactions Diverses  */
    public $CompteBanque_td , $libelle_td, $montant_td, $devise_td, $date_td, $justification_td , $CompteTiers_td;

    // General Block *************************/
    public function selectTab($tab)
    {
        $this->tab = $tab ;
    }

    public function mount(){
        $this->tab = request()->tab ? request()->tab : $this->tabname ;
        $this->reglement    = "singulier" ;
        $this->is_singulier = true ;
        $this->devise_facture = get_main_devise();
        $this->devise_td = get_main_devise();
    }

    public function updatedReglement()
    {
        $this->is_singulier = !$this->is_singulier ;
        $this->resetValidation() ;
    }

    public function saveTresoBanqueFactureSingulier()
    {
        //$this->validate([]);

       
            $this->validate([
                'idFacture' => ['required',new NumFactureExist],
                'CompteBanque_facture' => ['required',new CompteExist],
                'libelle_facture' => ['required','min:3','max:100'],
                'montant_facture'=> ['required','numeric','min:0','max:9999999999999.99'],
                'devise_facture' => ['required'],
                'date_facture' => ['required','date','date_format:Y-m-d','before:tomorrow','after:2000-12-31',new CheckTauxChangeByDate],
            ], [
                'idFacture.required' => 'Facture  obligatoire',
                'CompteBanque_facture.required' => 'Compte de Banque obligatoire',
                'libelle_facture.required' => 'libellé obligatoire',
                'libelle_facture.string' => "libellé erroné",
                'libelle_facture.min' => "libellé trop court",
                'libelle_facture.max' => "libellé max:100",
                'montant_facture.required' => "montant obligatoire",
                'montant_facture.numeric' => "montant invalide",
                'montant_facture.min' => "montant invalide",
                'montant_facture.max' => "montant trop grand",
                'devise_facture.required' => 'devise  obligatoire',
                'date_facture.required' => "date obligatoire",
                'date_facture.date' => "date format invalide",
                'date_facture.before' => "date erronée",
                'date_facture.after' => "date min. 01-01-2001",

            ]) ;

            $resp =  save_Treso('TresoFacture',null,null,$this->CompteBanque_facture,$this->idFacture,$this->date_facture,$this->libelle_facture,
            $this->montant_facture,$this->devise_facture,null,null);


        if($resp === 1)
        {   
            $this->resetForm_Facture();
            $this->showToastr('success|Enregistrement effectué avec succès');
        }else{
            $this->showToastr('failed|'.$resp); 
        }

    }

    public function updatedIdTiers($value)
    {   
        //$this->compte_achat = null ;
        $this->ListCompte_tiers = get_compte_tiers($value) ;
        //dd($this->ListCompte_tiers);
        // dd($this->ListCompte_achat);
        // dd($this->ListCompte_achat);
        //$this->dispatch('loadSelectCompteAchat');
    }
    
    public function saveTresoBanqueFactureGlobal($isEncaissement = false)
    {
            //
            $this->validate([
                'idTiers' => ['required','int'],
                'CompteTiers' => ['required',new CompteExist],
                'CompteBanque_facture' => ['required',new CompteExist],
                'libelle_facture' => ['required','string','min:3','max:100'],
                'montant_facture'=> ['required','numeric','min:0','max:9999999999999.99'],
                'devise_facture' => ['required'],
                'date_facture' => ['required','date','date_format:Y-m-d','before:tomorrow','after:2000-12-31',new CheckTauxChangeByDate],
            ], [
                'idTiers.required' => 'Tiers  obligatoire',
                'CompteTiers.required' => 'Compte de Tiers obligatoire',
                'CompteBanque_facture.required' => 'Compte de Banque obligatoire',
                'libelle_facture.required' => 'Libellé obligatoire',
                'libelle_facture.string' => "libellé erroné",
                'libelle_facture.min' => "libellé trop court",
                'libelle_facture.max' => "libellé max:100",
                'montant_facture.required' => "montant obligatoire",
                'montant_facture.numeric' => "montant invalide",
                'montant_facture.min' => "montant invalide",
                'montant_facture.max' => "montant trop grand",
                'devise_facture.required' => 'devise  obligatoire',
                'date_facture.required' => "date obligatoire",
                'date_facture.date' => "date format invalide",
                'date_facture.before' => "date erronée",
                'date_facture.after' => "date min. 01-01-2001",

            ]) ;

            $resp = save_Treso('TresoFacture',$this->idTiers,$this->CompteTiers,$this->CompteBanque_facture,null,$this->date_facture,$this->libelle_facture,
            $this->montant_facture,$this->devise_facture,null,$isEncaissement);

            if($resp === 1)
            {   
                $this->resetForm_Facture();
                $this->showToastr('success|Enregistrement effectué avec succès');
            }else{
                $this->showToastr('failed|'.$resp); 
            }
    }


    public function saveTresoBanqueTD($isEncaissement = false)
    {
            $this->validate([
                'CompteTiers_td' => ['required',new CompteExist],
                'CompteBanque_td' => ['required',new CompteExist],
                'libelle_td' => ['required','string','min:3','max:100'],
                'montant_td'=> ['required','numeric','min:0','max:9999999999999.99'],
                'devise_td' => ['required','string'],
                'date_td' => ['required','date','date_format:Y-m-d','before:tomorrow','after:2000-12-31',new CheckTauxChangeByDate],
            ], [
               
                'CompteTiers_td.required' => 'Compte de Tiers obligatoire',
                'CompteBanque_td.required' => 'Compte de Banque obligatoire',
                'libelle_td.required' => 'Libellé obligatoire',
                'libelle_td.string' => "libellé erroné",
                'libelle_td.min' => "libellé trop court",
                'libelle_td.max' => "libellé max:100",
                'montant_td.required' => "montant obligatoire",
                'montant_td.numeric' => "montant invalide",
                'montant_td.min' => "montant invalide",
                'montant_td.max' => "montant trop grand",
                'devise_td.required' => 'devise  obligatoire',
                'date_td.required' => "date obligatoire",
                'date_td.date' => "date format invalide",
                'date_td.before' => "date erronée",
                'date_td.after' => "date min. 01-01-2001",

            ]) ;

            $resp = save_Treso('TresoTD',null,$this->CompteTiers_td,$this->CompteBanque_td,null,$this->date_td,$this->libelle_td,
            $this->montant_td,$this->devise_td,null,$isEncaissement);
            
            if($resp === 1)
            {   
                $this->resetForm_TD();
                $this->showToastr('success|Enregistrement effectué avec succès');
            }else{
                $this->showToastr('failed|'.$resp); 
            }
        
    }

    public function resetForm_Facture(){
        $this->idTiers =
        $this->idFacture =
        $this->CompteTiers  =
        $this->CompteBanque_facture =
        $this->libelle_facture =  
        $this->montant_facture = 
        $this->date_facture = null;
        $this->resetValidation();
        $this->devise_facture = get_main_devise();
    }

    public function resetForm_TD(){
        $this->CompteTiers_td  =
        $this->CompteBanque_td =
        $this->libelle_td =  
        $this->montant_td = 
        $this->date_td = null;
        $this->resetValidation() ;
        $this->devise_td = get_main_devise();
    }


    public function showToastr($message){
        return $this->dispatch('showToast',
           message : $message
        );
    }

 
    public function render()
    {   
        return view('livewire.tresorerie-banque');
    }
}
