<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\WithPagination;

class TiersTable extends Component
{  
    use WithPagination;  
    public $type_tiers , $ligne = 10 , $search ;
    protected $listeners = ['loadTiersTable' => 'doSync'];


    private function doQuery(){
 
        return get_list_tiers($this->type_tiers,$this->ligne,$this->search);
    }

    public function mount(){
        $this->type_tiers = 'client';
    }

    
    public function doSync($data){
        //$this->search = $data['search'] ;
        $this->type_tiers = $data['type_tiers'] ; 
    }

    public function edit_tiers($id){
        $this->dispatch('editTiers',$id) ;
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function render()
    {
        return view('livewire.tiers-table', [
            'list_tiers' => $this->doQuery()
        ]);
    }
}
