<?php

namespace App\Livewire;

use Exception;
use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Tiers AS Tierss ;
use App\Rules\CompteExist;
use Illuminate\Support\Facades\DB;


class Tiers extends Component
{   
    use WithPagination;  
    public $tab = null;
    public $tabname = "tous" ;
    public $type_tiers , $ligne = 10 , $search ;
    protected $queryString = ['tab'] ;
    protected $listeners = ['refreshTiers' => '$refresh'];
   
   

    // General Block *************************/
    public function selectTab($tab){
        $this->tab = $tab ;
        $this->search = null;
        $this->resetPage();
        $this->type_tiers = $tab ;
       
    }

  

    /*public function loadTiersList(){
        $data = array('type_tiers' => $this->tab);
        $this->dispatch('loadTiersTable', $data);
    }*/

    public function mount(){
        $this->tab = request()->tab ? request()->tab : $this->tabname ;
        $this->type_tiers = $this->tab ;
    }

    public function edit_tiers($id){
        $this->dispatch('editTiers',$id) ;
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

  
    private function doQuery(){
 
        return get_list_tiers($this->type_tiers,$this->ligne,$this->search);
    }



    public function render()
    {
        return view('livewire.tiers', [
            'list_tiers' => $this->doQuery()
        ]);
    }
}
