<?php

namespace App\Livewire;

use App\Models\Rens;
use App\Models\UpFile;
use Exception;
use Livewire\Component;
use Livewire\WithFileUploads;
use Illuminate\Support\Facades\DB;

class RensNew extends Component
{

    use WithFileUploads;
    public $typeDemande, $labelObject, $object_file = [], $object_number, $infraction, $kyc, $content;

    // public $file;


    public function mount()
    {
        $this->typeDemande = 'file';
        $this->labelObject = 'Numéro cible';
    }

    public function saveRens()
    {


        if ($this->typeDemande === 'number') {
            $validator = $this->validate(
                [
                    'typeDemande' => ['required', 'string', 'max:6'],
                    'object_number' => ['required', 'string', 'min:9', 'max:12'],
                    'infraction' => ['required', 'string', 'max:200'],
                    'kyc' => ['nullable', 'string'],
                    'content' => ['required', 'string', 'max:200']

                ],
                [
                    'typeDemande.required' => 'obligatoire',
                    'typeDemande.max' => 'incorrect value',
                    'object_number.required' => 'obligatoire',
                    'object_number.min' => 'incorrect',
                    'object_number.max' => 'incorrect',
                    'infraction.required' => 'obligatoire',
                    'infraction.max' => 'limit caractere 200',
                    'kyc.string' => 'chaine de caractere',
                    'content.required' => 'obligatoire',
                    'content.max' => 'limit caractere 200'
                ]
            );
        } else {
            // upload file
            $validator = $this->validate(
                [
                    'typeDemande' => ['required', 'string', 'max:6'],
                    'object_file.*' => ['required', 'file', 'mimes:pdf', 'max:102400'],
                    'infraction' => ['required', 'string', 'max:200'],
                    'kyc' => ['nullable', 'string'],
                    'content' => ['required', 'string', 'max:200']

                ],
                [
                    'typeDemande.required' => 'obligatoire',
                    'typeDemande.max' => 'incorrect value',
                    'object_file.required' => 'obligatoire',
                    'object_file.file' => 'fichier incorrect',
                    'object_file.mines' => 'format incorrect',
                    'object_file.max' => 'taille max 100M',
                    'infraction.required' => 'obligatoire',
                    'infraction.max' => 'limit caractere 200',
                    'kyc.string' => 'chaine de caractere',
                    'content.required' => 'obligatoire',
                    'content.max' => 'limit caractere 200'
                ]
            );
        }



        try {

            DB::beginTransaction();

            $object_ = ($this->typeDemande === 'number') ? $this->object_number : null;

            $resp = save_demande(1, 'rens', '2025-01-01', '00:00:00', '2025-01-01', '00:00:00', $validator['infraction'], $validator['content'], $object_, $validator['kyc'], []);

            /* $rens = Rens::create([
                'type_rens' => $validator['typeDemande'],
                'numero_cible' => $object_,
                'kyc_cible' => $validator['kyc'],
                'upload' => $file,
                'infraction' => $validator['infraction'],
                'description' => $validator['content'],
                'user_crea' => get_pseudo()
            ]);*/


            if ($resp) {

                if ($validator['typeDemande'] === 'file' && !is_null($this->object_file)) {
                    foreach ($this->object_file as $photo) {
                        //  $photo->store('photos');
                        $file = $photo->store('doc_rens/' . get_id_app(), 'public');
                        UpFile::create([
                            'fk_demande' => $resp,
                            'upload' => $file
                        ]);
                    }
                }
                DB::commit();
                $this->resetForm_demande();
                $msg = "success|Demande envoyée";
            } else {
                DB::rollBack();
                $msg = "failed|une erreur est survenue " . $resp;
            }
        } catch (Exception $e) {

            $msg = "failed|une erreur est survenue " . $e;
        }

        $this->showToastr($msg);
    }


    public function resetForm_demande()
    {
        //$this->resetValidation();
        $this->object_number  =
            $this->object_file =
            $this->kyc =
            $this->infraction =
            $this->content = null;
    }


    public function updatedTypeDemande()
    {
        $this->labelObject = ($this->typeDemande === 'number') ? 'Numéro cible' : 'Upload fichier';
        $this->object_number = $this->object_file  = null;
    }

    public function showToastr($message)
    {
        return $this->dispatch(
            'showToast',
            message: $message
        );
    }

    public function render()
    {
        return view('livewire.rens-new');
    }
}
