<?php

namespace App\Livewire;

use App\Models\User;
use Livewire\Component;
use App\Mail\ResetPassword;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;

class ProfileTabs extends Component
{   

    public $tab = null;
    public $tabname = "info_perso" ;
    protected $queryString = ['tab'] ;
    public $lastname,$firstname,$postname,$phone, $email , $pseudo, $user_id;
    public $current_password, $new_password, $new_password_confirmation ;
    
    public function selectTab($tab){
        $this->tab = $tab ;
    }

    public function mount(){
        $this->tab = request()->tab ? request()->tab : $this->tabname ;

       // if(Auth::guard('User')->check()){
            $User = User::findOrFail(auth()->id());
            $this->user_id   = $User->id;
            $this->lastname  = $User->lastname;
            $this->firstname = $User->firstname;
            $this->postname  = $User->postname;
            $this->phone    = $User->phone ;
            $this->email     = $User->email;
            $this->pseudo    = $User->pseudo ;
       // }
    }

    public function updatePersonnalInfo(){

        $this->validate([
            'firstname' => ['required','string','min:3','max:30'],
            'lastname'  => ['required','string','min:3','max:30'],
            'postname'   => ['nullable','string','min:3','max:30'],
            'phone'     => ['nullable','string','min:3','max:15'],
           /* 'email' => ['required','email','unique:Users,email,'.$this->user_id],
            'pseudo' => ['required','min:3','unique:Users,pseudo,'.$this->user_id]*/
        ],[
            'firstname.required' => 'obligatoire',
            'firstname.string' => 'une chaine',
            'firstname.min' => 'pas moins de 3 carac.',
            'firstname.max' => 'max carac. 30',
            'lastname.required' => 'obligatoire',
            'lastname.string' => 'une chaine',
            'lastname.min' => 'pas moins de 3 carac.',
            'lastname.max' => 'max carac. 30',
            'postname.required' => 'obligatoire',
            'postname.string' => 'une chaine',
            'postname.min' => 'pas moins de 3 carac.',
            'postname.max' => 'max carac. 30',
            'phone.required' => 'obligatoire',
            'phone.string' => 'une chaine',
            'phone.min' => 'pas moins de 3 carac.',
            'phone.max' => 'max carac. 30',
        ]);

        User::find($this->user_id)
                ->update([
                    'firstname' => $this->firstname,
                    'lastname' => $this->lastname,
                    'postname' => $this->postname,
                    'phone'    => $this->phone,
                   /* 'email'    => $this->email,
                    'pseudo'   => $this->pseudo*/
                ]);
       // $this->emit('updateUserSellerHeader');
      /*  $this->dispatchBrowserEvent('updateUserInfo',[
            'pseudo' => $this->name,
            'UserEmail' => $this->email
        ]);*/
        $this->showToastr('success|changement effectué avec success');
    }

    public function updatePassword()
    {
        $this->validate([
            'current_password' => ['required',function($attribute,$value,$fail){
                if(!Hash::check($value,User::find(auth()->id())->password)){
                    return $fail(_('The current  password is incorrect'));
                }
            }],
            'new_password' => ['required',
                                'string',
                                'min:8','regex:/[A-Z]/','regex:/[a-z]/'
                                ,'regex:/[0-9]/','regex:/[_!@#$%^&*()<>?,;]/','confirmed']
        ],
                                [
                                   'new_password.regex' => 'Le Password doit contenir Minuscules,Majuscules, Chiffres et Catectères : _!@#$%^&*()<>?,;' 
                                ]
    );

        $user = User::findOrFail(auth()->id()) ;
        $query = $user->update([
            'password' => Hash::make($this->new_password)
        ]);

        if($query)
        {   
            $this->current_password = $this->new_password = $this->new_password_confirmation = null ;
            $this->showToastr('success|changement effectué avec success');
            Mail::to($user->email)
            ->later(now()->addMinutes(5), new ResetPassword('Changement Password',$user));
           
        }else{
            
            $this->showToastr('error|changement not effectué ');
        }
    }

    public function showToastr($message){
        return $this->dispatch('showToast',
           message : $message
        );
    }

    public function render()
    {
        return view('livewire.profile-tabs');
    }
}
