<?php

namespace App\Livewire;

use App\Models\Society;
use Livewire\Component;

class ModalNumberDigitCompte extends Component
{   
    public $numberDigit ;

    public function closeModal()
    {   
        $this->numberDigit = null ;
        $this->dispatch('hideModalModalNumberDigitCompte');
    }

    public function saveNumberDigit()
    {
        $this->validate([
            'numberDigit' => ['required','numeric'],
        ],
        ['numberDigit.required' => 'obligé',
         'numberDigit.numeric' => 'numeric' ]) ;

        $society = Society::find(get_id_app());
        $society->number_digit_compte = $this->numberDigit ;
        $society->save();

        $this->dispatch('hideModalModalNumberDigitCompte') ;
        $this->dispatch('getComptePlanOhada') ;
    }

  
    
    
    public function render()
    {
        return view('livewire.modal-number-digit-compte');
    }
}
