<?php

namespace App\Livewire;

use App\Models\Exercices;
use App\Models\Society;
use App\Rules\CheckExerciceYear;
use App\Rules\DateEnd;
use App\Rules\DateStart;
use Exception;
use Livewire\Component;
use Illuminate\Support\Facades\DB;

class ModalFichierComptable extends Component
{   
    public $date_start, $date_end, $numberDigit = 3 ;

    public function CloseModalFichierCompta()
    {   
        $this->resetValidation();
        $this->dispatch('hideModalFichierComptable');
    }


    public function valider()
    {
        $this->validate([
            'date_start' => ['required','date','date_format:Y-m-d','after:2000-01-01', new DateStart],
            'date_end' => ['required','date','date_format:Y-m-d','after:date_start', new DateEnd , new CheckExerciceYear($this->date_start)],
            'numberDigit' => ['required','numeric']
        ],
        ['numberDigit.required' => 'obligatoire',
           'numberDigit.numeric' => 'numeric',
           'date_start.required' => 'obligatoire',
           'date_start.date' => 'format invalid',
           'date_start.date_format' => 'format invalid',
           'date_start.after' => 'date non inf. à 2000',
           'date_end.required' => 'obligatoire',
           'date_end.date' => 'format invalid',
           'date_end.date_format' => 'format invalid',
           'date_end.after' => 'date fin doit être inf. à date début',

        ]);

        $d_debut = \Carbon\Carbon::parse($this->date_start)->format('Y') ;
        $d_fin = \Carbon\Carbon::parse($this->date_end)->format('Y') ;

        if($d_debut <> $d_fin)
        {
            $this->showToastr('failed|L\'exercice doit être une année');  
        }else{


            try
            {
                DB::beginTransaction();
                Exercices::create([
                    'exercice' => $d_debut ,
                    'start_date' => $this->date_start,
                    'end_date' => $this->date_end,
                    'id_app' => get_id_app(),
                    'user_crea' => get_pseudo(),
                ]);

                $society = Society::find(get_id_app());
                $society->number_digit_compte = $this->numberDigit ;
                $society->save();

                DB::commit();
                setExercice(getLastOpenExercice());
                $this->showToastr('success|Fichier comptable crée');  
                $this->dispatch('hideModalFichierComptable');
                $this->dispatch('refreshHomePage');
            }catch(Exception $e){

                DB::rollBack();
                $this->showToastr('failed|une erreur est survenue');  
            }
        }


    }

    public function showToastr($message)
    {
        return $this->dispatch('showToast',
           message : $message
        );
    }

    public function render()
    {
        return view('livewire.modal-fichier-comptable');
    }
}
