<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Facture;
use Livewire\WithPagination;

class ModalFactureCliquable extends Component
{
    use WithPagination;  
    protected $listeners = ['OpenModalFactureCliquable'];
    public $ligne = 5 , $search , $journal ;



    public function OpenModalFactureCliquable($journal)
    {  
       // $this->list_data = Facture::getFactureEnCours($journal);
       $this->journal = $journal ;
        $this->dispatch('showModalFactureCliquable');
    }

    public function CloseModalFactureCliquable()
    {   
        $this->ligne = 5 ;
        $this->resetPage();
        $this->dispatch('hideModalFactureCliquable');
    }

    public function getRefFacture(string $ref)
    {
        $this->dispatch('hideModalFactureCliquable'); 
        if ( $this->journal == 'banque') {
            $this->dispatch('getRefFactureBanque',$ref);
         
        }else{
            $this->dispatch('getRefFactureCaisse',$ref);
        }
    }

    public function updatingLigne()
    {
        $this->resetPage();
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function render()
    {
        return view('livewire.modal-facture-cliquable',[
            'list_data' => Facture::where(['id_app' => get_id_app()])
                                    ->search($this->search)
                                    ->select('id','ref_facture','num_facture',
                                            'date_facture','intitule','montant',
                                            'solde','devise')
                                    ->paginate($this->ligne) 
            
        ]);
    }
}
