<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Transaction;
use Illuminate\Support\Facades\DB;
use Livewire\WithPagination;

class ModalApercuJournal extends Component
{ 
    use WithPagination; 
    protected $listeners = ['ApercuJournal'];
    //public $list_data = [];
    public $list_data_detail = [];
    public $title , $group  ;
    public $title_detail , $ligne = 10  ;
    public $date_start , $date_end , $journal;

    public function mount(){
        //$this->journal = "achat" ;
        $this->date_start = '2024-01-01';
        $this->date_end = '2024-04-18' ;
    }

    public function updatingLigne()
    {
        $this->resetPage();
    }

    public function searchJC()
    {   
        $this->validate([
            'date_start' => ['required','date','date_format:Y-m-d','before:tomorrow','after:2000-12-31',],
            'date_end' => ['required','date','date_format:Y-m-d','before:tomorrow','after_or_equal:date_start',],
        ],[
            'date_start.required'=> 'obligatoire' ,
            'date_start.date' => 'format invalide' ,
            'date_start.date_format' => 'format invalide',
        ]);
       
    }

    public function ApercuJournal($journal)
    {   
        //$this->doQuery();
        $this->dispatch('showModalApercuJournal');
    }

    public function doQuery()
    {
        $this->title  = $this->group = null ;
        $this->get_Title_Search($this->journal,$this->date_start,$this->date_end);
        return get_journal_comptable($this->journal,$this->date_start,$this->date_end, $this->ligne);
    }

    public function showDetail(Transaction $transaction)
    {
        $this->title_detail = $transaction->intitule ;
        $this->list_data_detail = DB::select('SELECT  DISTINCT ct.`fk_num_compte`,cpt.`nom_compte`,ct.`debit`,ct.`credit`,ct.`devise` 
                                    FROM `cpt_tbl_comptable` ct 
                                INNER JOIN `cpt_tbl_compte_comptable` cpt ON ct.fk_num_compte = cpt.num_compte 
                                                                        AND cpt.`id_app` = :id_app
                                WHERE ct.fk_transaction_id =  :id',[':id' => $transaction->id , ':id_app' => get_id_app()]) ;

        $this->dispatch('showDetailTransactionModal');  
    }


    public function get_Title_Search($journal,$date_start,$date_end)
    {
        switch ($journal){
            case 'achat' :
                $this->group = 'av' ;
                $this->title = "Journal des achats du ".get_format_date($date_start,'L')." au ".get_format_date($date_end,'L') ;
                break;
            case 'vente':
                $this->group = 'av';
                $this->title = "Journal des ventes du ".get_format_date($date_start,'L')." au ".get_format_date($date_end,'L') ;
                break;
            case 'banque' :
                $this->group = 'bc';
                $this->title = "Journal des banques du ".get_format_date($date_start,'L')." au ".get_format_date($date_end,'L') ;
                break;
            case 'caisse':
                $this->group = 'bc';
                $this->title = "Journal des caisses du ".get_format_date($date_start,'L')." au ".get_format_date($date_end,'L') ;
                break;
            default :
                $this->group = 'od';
                $this->title = "Journal des Operations diverses du ".get_format_date($date_start,'L')." au ".get_format_date($date_end,'L') ;
        }
    }

    public function CloseModalApJournal()
    {
        $this->dispatch('hideModalApercuJournal');
    }

    public function render()
    {
        return view('livewire.modal-apercu-journal',[
            'list_data' =>  $this->doQuery()
        ]);
    }
}
