<?php

namespace App\Livewire;

use App\Models\Exercices;
use Livewire\Component;

class ListExercice extends Component
{   
    protected $listeners = ['refreshListExercice' => '$refresh'] ;
    public $ExChange = false ;

    public function mount()
    {

    }

    public function changeExercice($exercice)
    {
        setExercice($exercice);
        $this->dispatch('refreshInfoAdministration') ;
        $this->dispatch('refreshAdministration') ;
    }

    public function render()
    {
        return view('livewire.list-exercice',[
            'lists' => Exercices::where(['id_app' => get_id_app(),
                                        /*'is_closed' => 0, */
                                        'is_auto' => 0])
                                ->where('exercice','<>',getExercice())
                                ->select('exercice')
                                ->orderBy('exercice','DESC')
                                ->get(),
        ]);
    }
}
