<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Comptable;
use App\Models\Transaction;
use Illuminate\Support\Facades\DB;
use Livewire\WithPagination;
use Illuminate\Support\Carbon;

class JournauxComptableTable extends Component
{   
    use WithPagination; 
    protected $listeners = ['searchJC'];
   // public $list_data = [];
    public $list_data_detail = [];
    public $title , $group ;
    public $title_detail , $ligne = 10  ;
    public $journal , $date_start , $date_end ;


    public function mount()
    {
        $this->date_start = Carbon::now()->format('Y-m-d');
        $this->date_end   = Carbon::now()->format('Y-m-d');
        $this->journal = "achat" ;
    }

    public function searchJC($journal,$date_start,$date_end)
    {   
        $this->title  = $this->group = null ;
        $this->journal = $journal ;
        $this->date_start = $date_start ;
        $this->date_end = $date_end ;
        //$this->list_data = get_journal_comptable($journal,$date_start,$date_end, $this->line);
        $this->get_Title_Search($journal,$date_start,$date_end);
    }

    public function showDetail(Transaction $transaction)
    {
        $this->title_detail = $transaction->intitule ;
        $this->list_data_detail = DB::select('SELECT  DISTINCT ct.`fk_num_compte`,cpt.`nom_compte`,ct.`debit`,ct.`credit`,ct.`devise` 
                                    FROM `cpt_tbl_comptable` ct 
                                INNER JOIN `cpt_tbl_compte_comptable` cpt ON ct.fk_num_compte = cpt.num_compte 
                                                                        AND cpt.`id_app` = :id_app
                                WHERE ct.fk_transaction_id =  :id',[':id' => $transaction->id , ':id_app' => get_id_app()]) ;

        $this->dispatch('showDetailTransactionModal');  
    }


    public function get_Title_Search($journal,$date_start,$date_end)
    {
        switch ($journal){
            case 'achat' :
                $this->group = 'av' ;
                $this->title = "Journal des achats du ".get_format_date($date_start,'L')." au ".get_format_date($date_end,'L') ;
                break;
            case 'vente':
                $this->group = 'av';
                $this->title = "Journal des ventes du ".get_format_date($date_start,'L')." au ".get_format_date($date_end,'L') ;
                break;
            case 'banque' :
                $this->group = 'bc';
                $this->title = "Journal des banques du ".get_format_date($date_start,'L')." au ".get_format_date($date_end,'L') ;
                break;
            case 'caisse':
                $this->group = 'bc';
                $this->title = "Journal des caisses du ".get_format_date($date_start,'L')." au ".get_format_date($date_end,'L') ;
                break;
            default :
                $this->group = 'od';
                $this->title = "Journal des Operations diverses du ".get_format_date($date_start,'L')." au ".get_format_date($date_end,'L') ;
        }
    }

    public function render()
    {   
        $this->get_Title_Search($this->journal,$this->date_start,$this->date_end);
        return view('livewire.journaux-comptable-table',[
            'list_data' => get_journal_comptable($this->journal,$this->date_start,$this->date_end, $this->ligne) 
        ]);
    }
}
