<?php

namespace App\Livewire;

use Livewire\WithPagination;
use Livewire\Component;
use App\Models\Immobilisation;

class ImmobilisationTable extends Component
{   
    use WithPagination; 
    protected $listeners = ['loadImmoTable' => '$refresh'];
    public $ListImmo, $ligne = "" , $search ;

    public function mount()
    {
        $this->ligne = 10 ;
    }

    public function editImmo($id){
        $this->dispatch('editImmobilisation',$id) ;
    }

    /*
    public function getImmoList()
    {
        if(is_null($this->search)){
             
            $this->ListImmo = Immobilisation::where(['id_app' => get_id_app()])->paginate($this->ligne) ;
        }else{

       
        $this->ListImmo = Immobilisation::where(['id_app' => get_id_app()])
                                        ->orWhere('fk_num_compte','like','%'.trim($this->search).'%')
                                        ->orWhere('intitule','like','%'.trim($this->search).'%')
                                        ->orWhere('date_acquisition','like','%'.trim($this->search).'%')
                                        ->orWhere('montant','like','%'.trim($this->search).'%')
                                        ->orWhere('devise','like','%'.trim($this->search).'%')
                                        ->paginate($this->ligne);
        }
    }
    */

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function render()
    {   
       
        return view('livewire.immobilisation-table', [
            'ListImm' =>  Immobilisation::where(['id_app' => get_id_app()])
                        ->search($this->search)
                        ->orderBy('id', 'DESC')
                        ->paginate($this->ligne) ,
        ]);
    }


   
}
