<?php

namespace App\Livewire;

use App\Rules\DateBetweenExercice;
use Livewire\Component;
use Illuminate\Support\Carbon;
use Barryvdh\DomPDF\Facade\Pdf;


class EtatFinancier extends Component
{   
    public $devise, $date_start,$date_end,$journal, $compte ,  $disabled, $data = null;
    public $amort_date , $amort_sur ,$affiche_amort = "detail", $is_Amort = false ;
    public $datas = [] , $dico = [] , $dico_immo , $soldeInitial , $infoCompte ;

    public function mount(){
        $this->devise = get_main_devise();
        $exercice = getCurrentExercice() ;
        $this->date_start = isset($exercice->start_date)? $exercice->start_date : null ;
        $this->date_end   = isset($exercice->end_date)? $exercice->end_date : null ;
        $this->journal = "GL" ;
        $this->disabled = "";
    }

    public function updatedJournal($value){

        $this->compte = "-1" ; //($value <> "GL")? "" : $this->compte;
        $this->disabled = ($value <> "GL")? 'disabled' : "";  
        $this->is_Amort = ($value == "amortissement")? true : false; 
        $this->data = null ;  
        $this->dico = null ;
    }

    public function gdatass(array $array)
    {
        $this->datas = $array ;

        dd($this->datas);
    }

    public function goEtatFinance()
    {
        if($this->journal == "GL"){

            $this->validate([
                'compte'     => ['required','string'],
                'date_start' => ['required','date',new DateBetweenExercice],
                'date_end'   => ['required','date',new DateBetweenExercice],
                'devise'     => ['required']
            ],
        [
            'compte.required' => 'obligatoire',
            'compte.string' => 'une chaine de carac.',
            'date_start.required' => 'date obligatoire',
            'date_start.date' => 'date invalide',
            'date_end.required' => 'date obligatoire',
            'date_end.date' => 'date invalide',
        ]);

            $this->data = grand_livre($this->compte,$this->date_start,$this->date_end);
           // dd($this->data);
            $this->soldeInitial = get_soldeInitial($this->compte,$this->date_end); 
            $this->infoCompte   = get_info_compte($this->compte);


        }

        if($this->journal === "balance"){

            $this->validate([
                'date_start' => ['required','date',new DateBetweenExercice],
                'date_end'   => ['required','date',new DateBetweenExercice],
                'devise'     => ['required']
            ],
            [
                'date_start.required' => 'date obligatoire',
                'date_start.date' => 'date invalide',
                'date_end.required' => 'date obligatoire',
                'date_end.date' => 'date invalide',
            ]);

            $this->data = Balance($this->date_start,$this->date_end);
            $this->dico = Balance_dico($this->data,$this->date_start,$this->date_end,true);
           
        }

        if($this->journal === "resultat"){

            $this->validate([
                'date_start' => ['required','date',new DateBetweenExercice],
                'date_end'   => ['required','date',new DateBetweenExercice],
                'devise'     => ['required']
            ],
            [
                'date_start.required' => 'date obligatoire',
                'date_start.date' => 'date invalide',
                'date_end.required' => 'date obligatoire',
                'date_end.date' => 'date invalide',
            ]);

            $this->data = Resultat();
            $this->dico = Resultat_dico($this->data,$this->date_start,$this->date_end);
        }

        if($this->journal === "bilan"){

            $this->validate([
                'date_start' => ['required','date',new DateBetweenExercice],
                'date_end'   => ['required','date',new DateBetweenExercice],
                'devise'     => ['required']
            ],
            [
                'date_start.required' => 'date obligatoire',
                'date_start.date' => 'date invalide',
                'date_end.required' => 'date obligatoire',
                'date_end.date' => 'date invalide',
            ]);

            $this->data = Bilan('actif');
            $this->dico = Bilan_dico($this->data,$this->date_start,$this->date_end);
        }

        if($this->journal == "amortissement"){

            $this->validate([
                'amort_sur'       => ['required','int'],
                'amort_date'    => ['required','date'],
                'affiche_amort' => ['required','string'],
                'devise'        => ['required']
            ],
            [   'amort_sur.required' => 'obligatoire',
                'amort_sur.int' => 'un nombre attendu',
                'amort_date.required' => 'date obligatoire',
                'amort_date.date' => 'date invalide',
            ]);

            $this->data = tab_compte_immo();
            $this->dico_immo = generate_dico_immo($this->amort_date,$this->amort_sur,$this->data);
           
        }

        if($this->journal == "test"){

            $data = get_poste_bilan_for_test();
           // dd($this->data);
           // $this->data = tab_compte_immo();
          //  $this->dico_immo = generate_dico_immo($this->amort_date,$this->amort_sur,$this->data);
          $name_file = 'tableau_test_'.Carbon::now()->format('d-m-Y_His').'.pdf' ; 

          $pdf = Pdf::loadView('pdf.test_bilan',compact('data'));
          $pdf->setPaper('A4', 'landscape'); // landscape : portrait
          return response()->streamDownload(function () use($pdf) {
              echo  $pdf->stream();
          }, $name_file);
        }


    }

    public function DownloadTabImmoPdf()
    {
        
        $amort_sur     = $this->amort_sur ;
        $amort_date    = $this->amort_date;
        $devise        = $this->devise ;
        $affiche_amort = $this->affiche_amort;
        $data          = $this->dico_immo ;
        $name_file     = 'tableau_amortissement_'.Carbon::now()->format('d-m-Y_His').'.pdf' ; 

        $pdf = Pdf::loadView('pdf.table_immobilisation',compact('amort_sur','amort_date','devise','affiche_amort','data'));
        return response()->streamDownload(function () use($pdf) {
            echo  $pdf->stream();
        }, $name_file);
    }

    public function DownloadGrandLivrePdf()
    {
        
        $compte        = $this->compte ;
        $date_end      = $this->date_end;
        $date_start      = $this->date_start;
        $devise        = $this->devise ;
        $soldeInitial  = $this->soldeInitial;
        $infoCompte    = $this->infoCompte;
        $data          = $this->data ;
        $exercice      = getExercice();
        $name_file     = 'grand_livre_'.$compte.'_'.Carbon::now()->format('d-m-Y_His').'.pdf' ; 

        $pdf = Pdf::loadView('pdf.grand_livre',compact('compte','date_start','date_end','devise','soldeInitial','infoCompte','exercice','data'));
        return response()->streamDownload(function () use($pdf) {
            echo  $pdf->stream();
        }, $name_file);
    }

    public function DownloadBalancePdf()
    {
        
        $date_end      = $this->date_end;
        $date_start    = $this->date_start;
        $devise        = $this->devise ;
        $exercice      = getExercice();
        $data          = $this->dico ;
        $name_file     = 'balance_'.Carbon::now()->format('d-m-Y_His').'.pdf' ; 

        $pdf = Pdf::loadView('pdf.balance',compact('date_start','date_end','devise','exercice','data'));
        $pdf->setPaper('A4', 'landscape');
        return response()->streamDownload(function () use($pdf) {
            echo  $pdf->stream();
        }, $name_file);
    }

    public function DownloadBilanPdf()
    {
        
        $date_end      = $this->date_end;
        $date_start    = $this->date_start;
        $devise        = $this->devise ;
        $dico         = $this->dico ;
        $name_file     = 'bilan_'.Carbon::now()->format('d-m-Y_His').'.pdf' ; 

        $pdf = Pdf::loadView('pdf.bilan',compact('date_start','date_end','devise','dico'));
        $pdf->setPaper('A4', 'landscape'); // landscape : portrait
        return response()->streamDownload(function () use($pdf) {
            echo  $pdf->stream();
        }, $name_file);
    }

    public function render()
    {   
        return view('livewire.etat-financier');
    }
}
