<?php

namespace App\Livewire;

use App\Rules\CheckCompteTiersExist;
use App\Rules\CheckSizeCompteTiers;
use App\Rules\CheckTiersClient;
use App\Rules\CheckTiersFourn;
use Livewire\Component;
use App\Rules\MaxCompte;
use App\Rules\MinCompte;
use Illuminate\Support\Facades\DB;
use Livewire\WithPagination;
use Illuminate\Database\Query\JoinClause;
use Exception;



class CompteTiers extends Component
{   
    use WithPagination;
    public $tab = null;
    public $tabname = "client" ;
    protected $queryString = ['tab'] ;
   
    public $isNew_cl  , $title_modal_cl , $num_compte_cl , $nom_compte_cl, $tiers_id_cl;
    public $isNew_fn  , $title_modal_fn , $num_compte_fn , $nom_compte_fn, $tiers_id_fn;
    public $per_page_cl , $per_page_fn ;
   
    // General Block *************************/
    public function selectTab($tab){
        $this->tab = $tab ;
       // $this->loadTiersList();
    }

    public function OpenModalNewCompteCl()
    {   
        $this->dispatch('showModalCl');
    }

    
    public function CloseModalNewCompteCl()
    {
        $this->resetFormCompteCl();
        $this->dispatch('hideModalCl');
        $this->setIsNewCl(true) ;
    }

    private function setIsNewCl($bool){
        $this->isNew_cl = $bool ;
        $this->title_modal_cl = ($bool) ? "Nouveau Compte des Tiers - Client " : "Update Compte des Tiers - Client";
    }


    public function saveCompteTiersCl(){

        $this->validate([
            'num_compte_cl'  => ['required','numeric'
                                ,new MinCompte,new MaxCompte,new CheckTiersClient
                                , new CheckSizeCompteTiers,new CheckCompteTiersExist($this->tiers_id_cl)],
            'tiers_id_cl'    => ['required'],
            'nom_compte_cl'  => ['required','string','min:3','max:100'],
        ],
        [
            'num_compte_cl.required'  => "obligatoire",
            'num_compte_cl.numeric'  => "invalide",
            'tiers_id_cl.required' => "obligatoire",
            'nom_compte_cl.required'  => "obligatoire",
            'nom_compte_cl.min'  => "invalide",
            'nom_compte_cl.max'  => "max. 100 caractères",
        ]);

       


        $data = array(
            'num_compte'  => $this->num_compte_cl,
            'nom_compte'  => $this->nom_compte_cl,
            'id_tiers'   => $this->tiers_id_cl,
            'id_app'      => get_id_app(),
            'user'        => get_pseudo()
        );


        try{

            if($this->isNew_cl){

                    $response = DB::select('call CPT_SAVE_COMPTE_TIERS(:num_compte,:nom_compte,:id_tiers,:id_app,:user)'
                        , $data);

                      

                        if(isset($response[0]->Message)){
                                if($response[0]->Message == 1){
                                    $this->showToastr('success|Création effectuée avec success');
                                    $this->resetFormCompte_Cl();
                                }else{
                                    $this->showToastr('failed|'.$response[0]->Message);
                                }
                        }else{
                            $this->showToastr('failed|Echec de création');
                        }   

            }else{

                /*   $compte = CompteComptable::findOrFail($this->id_compte);

                $compte->fill([
                    'nom_compte' => $this->nom_compte ,
                    'type_compte' => $this->type_compte,
                ]);
                $compte->save();
                $this->showToastr('success|Modification effectuée avec success');
                $this->CloseModalNewCompte(); */
            }

        }catch(Exception $e)
        {
            $this->showToastr('failed|Une erreur est survenue'. $e);
        }
        
    }

    public function resetFormCompteCl()
    {
        $this->num_compte_cl = $this->nom_compte_cl = $this->tiers_id_cl = null;
        $this->resetValidation();
        //$this->type_compte = "hybrid";
    }

    public function showToastr($message)
    {
        return $this->dispatch('showToast',
           message : $message
        );
    }

    public function mount()
    {   
        $this->tab = request()->tab ? request()->tab : $this->tabname ;
        $this->setIsNewCl(true) ;
        $this->setIsNewFn(true) ;
        $this->per_page_cl = 10 ;
        $this->per_page_fn = 10 ;
    }

    public function updatingPerPageCl()
    {
        $this->resetPage();
       
    }
    public function updatingPerPageFn()
    {
        $this->resetPage();
       
    }

    public function render()
    {
        return view('livewire.compte-tiers',[
            'list_tiers_client' => DB::table('cpt_tbl_compte_tiers AS cmp')
            ->join('stk_tbl_tiers AS tiers', function (JoinClause $join) {
                $join->on('cmp.id_tiers', '=', 'tiers.id')
                    ->where('cmp.id_app', '=', get_id_app());
            })
            ->where('tiers.type_tiers', 'client')
            ->select('cmp.id', 'tiers.denomination', 'cmp.compte', 'cmp.intitule')
            ->paginate($this->per_page_cl) ,

            'list_tiers_fourn' => DB::table('cpt_tbl_compte_tiers AS cmp')
            ->join('stk_tbl_tiers AS tiers', function (JoinClause $join) {
                $join->on('cmp.id_tiers', '=', 'tiers.id')
                    ->where('cmp.id_app', '=', get_id_app());
            })
            ->where('tiers.type_tiers', 'fourn')
            ->select('cmp.id', 'tiers.denomination', 'cmp.compte', 'cmp.intitule')
            ->paginate($this->per_page_fn) ,
        ]);
    }


    //*** Fourn Part  */

    public function OpenModalNewCompteFn()
    {   
        $this->dispatch('showModalFn');
    }

    
    public function CloseModalNewCompteFn()
    {
        //$this->resetFormCompte_Cl();
        $this->dispatch('hideModalFn');
        $this->setIsNewFn(true) ;
    }

    private function setIsNewFn($bool){
        $this->isNew_fn = $bool ;
        $this->title_modal_fn = ($bool) ? "Nouveau Compte des Tiers - Fournisseur " : "Update Compte des Tiers - Fournisseur";
    }


    public function saveCompteTiersFn(){

        $this->validate([
            'num_compte_fn'  => ['required','numeric'
                                ,new MinCompte,new MaxCompte,new CheckTiersFourn
                                ,new CheckSizeCompteTiers,new CheckCompteTiersExist($this->tiers_id_fn)],
            'tiers_id_fn'    => ['required'],
            'nom_compte_fn'  => ['required','string','min:3','max:100'],
        ],
        [
            'num_compte_fn.required'  => "obligatoire",
            'num_compte_fn.numeric'  => "invalide",
            'tiers_id_fn.required' => "obligatoire",
            'nom_compte_fn.required'  => "obligatoire",
            'nom_compte_fn.min'  => "invalide",
            'nom_compte_fn.max'  => "max. 100 caractères",
        ]);

        $data = array(
            'num_compte'  => $this->num_compte_fn,
            'nom_compte'  => $this->nom_compte_fn,
            'id_tiers'   => $this->tiers_id_fn,
            'id_app'      => get_id_app(),
            'user'        => get_pseudo()
        );


        try{

            if($this->isNew_fn){
                    $response = DB::select('call CPT_SAVE_COMPTE_TIERS(:num_compte,:nom_compte,:id_tiers,:id_app,:user)'
                        , $data);

                      

                        if(isset($response[0]->Message)){
                                if($response[0]->Message == 1){
                                    $this->showToastr('success|Création effectuée avec success');
                                    $this->resetFormCompteFn();
                                }else{
                                    $this->showToastr('failed|'.$response[0]->Message);
                                }
                        }else{
                            $this->showToastr('failed|Echec de création');
                        }   

            }else{

                /*   $compte = CompteComptable::findOrFail($this->id_compte);

                $compte->fill([
                    'nom_compte' => $this->nom_compte ,
                    'type_compte' => $this->type_compte,
                ]);
                $compte->save();
                $this->showToastr('success|Modification effectuée avec success');
                $this->CloseModalNewCompte(); */
            }

        }catch(Exception $e)
        {
            $this->showToastr('failed|Une erreur est survenue'. $e);
        }
        
    }

    public function resetFormCompteFn()
    {
        $this->num_compte_fn = $this->nom_compte_fn = $this->tiers_id_fn = null;
        $this->resetValidation();
        //$this->type_compte = "hybrid";
    }

}

