<?php

namespace App\Livewire;

use App\Imports\BalanceOuvertureImport;
use App\Models\Archive;
use App\Models\Cloture;
use App\Models\CloturePeriode;
use App\Models\Exercices;
use App\Models\TauxChange;
use App\Models\WorkDay;
use App\Rules\CheckClotureExercice;
use App\Rules\CheckCloturePeriode;
use App\Rules\DateBetweenExercice;
use App\Rules\DateEnd;
use App\Rules\DateStart;
use Livewire\Component;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Livewire\WithFileUploads;
use Maatwebsite\Excel\Facades\Excel;

class Administration extends Component
{   
    use WithFileUploads;

    public $tab = null;
    public $tabname = "taux_change" ;
    protected $listeners = [
        'refreshAdministration' => '$refresh',
        'refreshInfoAdministration' => 'getInfo'] ;
    protected $queryString = ['tab'] ;
    public $inputs ,$listComptaDevise  ,$dateChange, $dateCloture;
    public $todo,$file ;
    public $date_start, $date_end;
   
    
    public function selectTab($tab){
        $this->tab = $tab ;
    }

    public function mount(){
      //  dd((mb_substr('ABC0000000000', 0, 1)));
        
        $this->tab = request()->tab ? request()->tab : $this->tabname ;
        $this->getInfo() ;
    }

    public function saveTauxChange(){
       
        $this->validate([
            'dateChange' => ['required','date','date_format:Y-m-d', new DateBetweenExercice, 
                                new CheckCloturePeriode, new CheckClotureExercice ],
            'inputs.*.devise_start' => ['required','string','max:3'],
            'inputs.*.taux'         => ['required','numeric'],
            'inputs.*.devise_end' => ['required','string','max:3'],
        ],[
            'inputs.*.taux.required' => 'le taux est obligatoire',
            'inputs.*.taux.numeric' => 'montant invalide',
            'dateChange.required' => 'obligatoire' ,
            'dateChange.date' => 'date invalide' ,
            'dateChange.date_format' => 'date invalide' ,
        ]);

        $this->dispatch('showConfirmModalTauxChange');  
    }

    public function showToastr($message){
        return $this->dispatch('showToast',
           message : $message
        );
    }

    public function storeTauxChange()
    {   
  
       if(count($this->inputs) > 0)
       {
           
            /**!
             * 
            **/

            try {
                //code...
                $workd = DB::select('CALL CREATE_WORK_DAY(:id_app,:dateChange,:p_user)', [
                                'id_app'  => get_id_app(),
                                'dateChange' => $this->dateChange ,
                                'p_user'  => get_pseudo()
                                ]
                            );

                if(isset($workd[0]->Code) && $workd[0]->Code  == 1 )
                {
                    DB::beginTransaction();
                    foreach( $this->inputs as $input) :
                        TauxChange::create([
                            'fk_idworkday' => $workd[0]->Message,
                            'devise_start' => $input['devise_start'] ,
                            'taux' => $input['taux'] , 
                            'devise_end' =>  $input['devise_end']
                        ]);
                    endforeach ;
            
                    DB::commit();
                    $this->dispatch('hideConfirmModalTauxChange');  
                    $this->showToastr('success|Changement taux effectué ');
            
                }else if(isset($workd[0]->Code) && $workd[0]->Code  == 0){  

                    $this->dispatch('hideConfirmModalTauxChange');
                    $this->showToastr("failed|".$workd[0]->Message);
                }else{

                    $this->dispatch('hideConfirmModalTauxChange');
                    $this->showToastr('failed|Une erreur est survenue');
                }

            } catch (\Exception $e) {
                //DB::rollBack();
                $this->dispatch('hideConfirmModalTauxChange');
                $this->showToastr('failed|Une erreur est survenue');
            }

        }else{
           
            $this->showToastr('failed|Sélectionnez vos devises');
            $this->dispatch('hideConfirmModalTauxChange');
        }

    }

    
    public function ImportConfig(){

        $this->validate([
            'todo' => ['required'],
            'file' => ['required', 'mimes:xlsx'],
        ], 
        [   
            'todo' => 'obligatoire',
            'file.required' => "fichier obligatoire",
            'file.mimes'    => "format attendu .xlsx",
        ]);

       
           
          Excel::import(new BalanceOuvertureImport, $this->file);
            $this->showToastr('success|Importation reussie ');
            //$this->dispatch('hideImportModal');

    }

    /**
     * ! Ouverture Exercice
     */

     public function OpenExercice()
     {
        $validator = $this->validate([
            'date_start' => ['required','date','date_format:Y-m-d', new DateStart],
            'date_end'   => ['required','date','date_format:Y-m-d',new DateEnd,'after:date_start'],
            
        ],[
            'date_start.required' => 'obligatoire' ,
            'date_start.date' => 'invalide' ,
            'date_start.date' => 'format invalide' ,
            'date_end.required' => 'obligatoire' ,
            'date_end.date' => 'invalide' ,
            'date_end.date' => 'format invalide' ,
           
        ]);

        $date_s =  \Carbon\Carbon::parse($this->date_end); 
        $r = $date_s->diffInYears($this->date_start);

       /* if($r <> 1){
            $this->addError('date_end', 'interval date 1 an');
            $this->validate();
        }*/
        //dd('ok');

        try {
            $exec = DB::select('SELECT FCT_OPEN_EXERCICE(:date_start,:date_end,:id_app,:p_user) AS Message', [
                'date_start' => $this->date_start ,
                'date_end' => $this->date_end ,
                'id_app'  => get_id_app(),
                'p_user'  => get_pseudo()
                ]
            );
            
            if(isset($exec[0]->Message))
            {
                $message = $exec[0]->Message ;
                if($message == "NO_F"){
                    $this->showToastr('failed|Impossible de créer l\'exercice');
                }elseif($message == "NO_P"){
                    $this->showToastr('failed|Pas le suivant');
                }else{
                    $this->showToastr('success|Création reussie ');
                    $this->dispatch('refreshListExercice');
                    $this->dispatch('refreshAdministration');
                }
            }else{
                $this->showToastr('failed|Erreur Création Exercice');
            }
        } catch (\Throwable $th) {

            $this->showToastr('failed|Une erreur est survenue');
        }
      
     }

    public function getInfo()
    {
        $this->resetValidation();
        
        $exercice = getCurrentExercice() ;

        /**
         * Recup Dates UI
        */
        if(get_current_idWorkDay())
        {
            $date1 = Carbon::now()->format('m-d') ;
            $this->dateChange = Carbon::parse($exercice->exercice.'-'.$date1)->format('Y-m-d');
        }else{
            $this->dateChange = $exercice->start_date ;
        }

        $this->dateCloture = $exercice->end_date ;
       
        /**
         * Get Info taux Change
         */
        $array = array();

       $ar = DB::select('SELECT cpt.`id`,cpt.`devise` , sys.intitule
                            FROM `cpt_tbl_devise` cpt
                            INNER JOIN `sys_tbl_devise` sys ON cpt.devise = sys.devise AND sys.is_devise_local = 0 
                            WHERE cpt.fk_id_parent = ? ORDER BY sys.intitule', [get_Current_idParent_Devise()]);
           

            foreach($ar as $a):
                    $tab = array('devise_start' => $a->devise ,'taux' => get_current_taux_change($a->devise) , 'devise_end' => get_local_devise()->devise);
                    array_push($array,$tab);
            endforeach ;

            $this->fill([
                'inputs' => collect($array)
            ]);               
    } 

    /**
     * ! Partie Cloture Periodique
     */

    public function CloturePeriode()
     {
        $this->validate([
            'dateCloture' => ['required','date','date_format:Y-m-d', new DateBetweenExercice, 
                new CheckCloturePeriode, new CheckClotureExercice],
        
        ],[
            'dateCloture.required' => 'obligatoire' ,
            'dateCloture.date' => 'invalide' ,
            'dateCloture.date' => 'format invalide' 
        ]);

        $this->dispatch('showConfirmCloturePeriode');  
     }

     public function StoreCloturePeriode()
     {
       
        try {
            CloturePeriode::create([
                'exercice' => getExercice() ,
                'date_valeur' => $this->dateCloture ,
                'user_crea' => get_pseudo(),
                'id_app' => get_id_app()
            ]);

            $this->showToastr('success|Cloture Periode effectué avec success');
            $this->dispatch('refreshAdministration');
            $this->dispatch('hideConfirmCloturePeriode');
        } catch (\Exception $e) {
            $this->showToastr('failed|Une erreur est survenue');
            $this->dispatch('hideConfirmCloturePeriode');
        }
        
     }
    
     /**
     * ! Partie Cloture Exercice
     */
    public function ClotureExercice()
    {
        $this->validate([
            'dateCloture' => ['required','date','date_format:Y-m-d', new DateBetweenExercice, 
                            new DateEnd,new CheckClotureExercice],
        
        ],[
            'dateCloture.required' => 'obligatoire' ,
            'dateCloture.date' => 'invalide' ,
            'dateCloture.date' => 'format invalide' 
        ]);

        $this->dispatch('showConfirmClotureExercice');  
    }

    public function StoreClotureExercice()
    {   
        $this->dispatch('hideConfirmClotureExercice');
       $ex = getCurrentExercice() ;

        try {
            DB::beginTransaction() ;
           /* CloturePeriode::create([
                'exercice' => getExercice() ,
                'date_valeur' => $this->dateCloture ,
                'user_crea' => get_pseudo(),
                'id_app' => get_id_app()
            ]);*/

            /**
             * ? Partie BALANCE : Sauvegarde des Comptes
            */

            $listCompteBalance = Balance($ex->start_date,$ex->end_date);
            $dataBalance = Balance_dico($listCompteBalance,$ex->start_date,$ex->end_date);
           
            $p = null ;
            foreach($dataBalance AS $data):
                $p = intval(mb_substr($data['compte'], 0, 1)) ;
                if( $p > 0 && $p < 6 )
                {  
                    try {
                        Cloture::create([
                            'exercice' => $ex->exercice,
                            'fk_num_compte' => $data['compte'],
                            'solde' => ($data['solde']['debit'])? $data['solde']['debit'] : $data['solde']['credit'],
                            'devise' => 'USD',
                            'fk_idworkday' => 1,
                            'user_crea' => get_pseudo(),
                            'id_app' => get_id_app()
                        ]);
                    } catch (\Throwable $th) {
                        //throw $th;
                        dd(intval(mb_substr($data['compte'], 0, 1)));
                    }
                    
                }
               
            endforeach;

            /**
             * ? Partie RESULTAT : Sauvegarde des postes
            */

            $listPosteResultat = Resultat();
            $dataResultat = Resultat_dico($listPosteResultat,$ex->start_date,$ex->end_date);

            foreach($dataResultat AS $data):
                    Archive::create([
                        'exercice' => $ex->exercice,
                        'fk_poste_code' => $data['poste'],
                        'solde' => $data['exercice_n'] ,
                        'devise' => 'USD',
                        'fk_idworkday' => 1,
                        'user_crea' => get_pseudo(),
                        'id_app' => get_id_app()
                    ]);
            endforeach;


            /**
             * ? Partie BILAN : Sauvegarde des postes
            */

            $listPosteBilan = Bilan('actif');
            $dataBilan = Bilan_dico($listPosteBilan,$ex->start_date,$ex->end_date);

            foreach($dataBilan['actif'] AS $data):
                    Archive::create([
                        'exercice' => $ex->exercice,
                        'fk_poste_code' => $data['poste'],
                        'solde' => $data['exercice_n']['net'] ,
                        'devise' => 'USD',
                        'fk_idworkday' => 1,
                        'user_crea' => get_pseudo(),
                        'id_app' => get_id_app()
                    ]);
            endforeach;

            foreach($dataBilan['passif'] AS $data):
                Archive::create([
                    'exercice' => $ex->exercice,
                    'fk_poste_code' => $data['poste'],
                    'solde' => $data['exercice_n'] ,
                    'devise' => 'USD',
                    'fk_idworkday' => 1,
                    'user_crea' => get_pseudo(),
                    'id_app' => get_id_app()
                ]);
        endforeach;

        /**
        * ? UPDATE CLOTURE : close exercice
        */

        $exercice = Exercices::find($ex->id);
            $exercice->fill([
                        'is_closed' => 1,
                        'user_closed' => get_pseudo(),
                        'date_closed' => Carbon::now()->format('Y-m-d'),
                    ]);
            $exercice->save();

            DB::commit();
            $this->showToastr('success|Exercice cloturé avec success');
            $this->dispatch('refreshAdministration');
           
        } catch (\Exception $e) {
            DB::rollBack();
            $this->showToastr('failed|Une erreur est survenue');
        }
        
    }
 


    public function render()
    {   
        return view('livewire.administration');
    }
}
