<?php

namespace App\Livewire\Admin;

use App\Models\intervenant;
use App\Models\traitement;
use Exception;
use Livewire\Component;
use Livewire\WithPagination;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Illuminate\Support\Str;
use App\Models\Link;



class ViewerDemande extends Component
{
    use WithPagination;
    public $demande, $type, $listIntervenants = [], $listDemande, $listFiles = [];
    protected $listeners = [
        'viewDemande' => 'getList',
        'resetDemande' => 'initDemande'
    ];

    public function mount()
    {
        $this->listDemande = get_list_demande('PENDING');
    }

    public function getDemande($key)
    {
        $this->resetPage();
        $this->demande = get_demande($key);
        // $this->type = $type;
        if ($this->demande) {
            try {
                $this->listIntervenants = get_intervenants($key);
                $this->listFiles = get_files($key);

                if (is_null($this->demande->statut)) {
                    traitement::create([
                        'fk_demande'  => $key,
                        'date_debut'  => $this->demande->date_dd,
                        'heure_debut' => $this->demande->heure_d,
                        'date_fin'    => $this->demande->date_ff,
                        'heure_fin'   => $this->demande->heure_f,
                        'user_crea'   => get_pseudo()
                    ]);
                }
            } catch (Exception $e) {
                dd('eee');
            }
        }
    }

    public function getList($type)
    {
        $this->demande = null;
        $this->listFiles = [];
        $this->type = $type;
        $this->listDemande = get_list_demande($type);
    }

    public function back()
    {
        $this->demande = null;
    }

    public function initDemande()
    {
        $this->demande = null;
        $this->listIntervenants = [];
        $this->listFiles = [];
        $this->listDemande = get_list_demande($this->type);
    }

    public function decision($key, $decision)
    {
        DB::beginTransaction();
        try {
            // $traitment = traitement::where('fk_demande', $key)->get();
            $currentDateTime = Carbon::now();
            $date = $currentDateTime->toDateTimeString();

            if ($decision === "YES") {


                $demande = DB::table('traitment')
                    ->where('fk_demande', $key)
                    ->update([
                        'statut' => 'ALLOWED',
                        'date_traitment' => $date,
                        /* 'link' => , */
                        'user_mod' => get_pseudo()
                    ]);


                $token = Str::random(40);
                $duration = 2;

                Link::create([
                    'token' => $token,
                    'url' => 'access',
                    'demande' => $key,
                    'expires_at' => Carbon::now()->addMinutes($duration),
                ]);

                //$link = route('access', ['token' => $token]);

                $msg = "demande acceptée";
            } else {
                DB::table('traitment')
                    ->where('fk_demande', $key)
                    ->update([
                        'statut' => 'REJECTED',
                        'date_traitment' => $date,
                        'user_mod' => get_pseudo()
                    ]);
                $msg = "demande rejectée";
            }
            DB::commit();
            $this->showToastr('success|' . $msg);
            $this->initDemande();
            $this->dispatch('resetGestDemande');
        } catch (Exception $e) {
            DB::rollBack();
            $this->showToastr('failed|erreur soulevée');
        }
    }

    public function showToastr($message)
    {
        return $this->dispatch(
            'showToast',
            message: $message
        );
    }


    public function render()
    {
        return view('livewire.admin.viewer-demande');
    }
}
