<?php

namespace App\Livewire\Admin;

use App\Models\Society;
use Livewire\Component;
use Livewire\WithPagination;

class Customer extends Component
{   
    use WithPagination;  
    public $per_page = 10 , $search ;

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function render()
    {
        return view('livewire.admin.customer' , [
            'lists' => Society::search($this->search)
                                ->orderBy('raison_sociale', 'ASC')
                                ->paginate($this->per_page)  
        ]);
    }
}
