<?php

namespace App\Exports;

use App\Models\CompteComptable;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;


class CompteComptableExport implements FromCollection , WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        return CompteComptable::where(['id_app' => get_id_app()])->orderBy('num_compte')
                        ->select('num_compte','nom_compte','type_compte','fk_cg_code')->get();
        
    }

    /**
     * Write code on Method
     *
     * @return response()
     */
    public function headings(): array
    {
        return ["COMPTE", "INTITULE", "NATURE COMPTE","CG CODE"];
    }

}
